/**
 * @(#)UserMarketingExceptionCode.java 1.0 2016-11-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.exception;

import org.springframework.util.StringUtils;

/**
 * 描述
 *
 * @author 管春
 * @since 0.6.0
 */
public class MarketingExceptionCode {


    public static final String SYSTEM_ERR_CODE = "010001", PARAMS_ERR_CODE = "010002", REQUEST_ERR_CODE = "010003",
            UNKNOWN_ERR_CODE = "010004", RECORD_NOT_EXIST_CODE = "11002",
            ENGINE_CONFIG_ERR_CODE = "020001", STOCK_EMPTY_CODE = "6010", PARAMETER_ERROR_CODE = "10002",
            TEMPLATE_NAME_EXISTS_CODE = "11003", TEMPLATE_CODE_EXISTS_CODE = "11004",
            ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL_CODE = "11005", ACTIVITY_TEMPLATE_CODE_NOT_EXISTS_CODE = "11006",
            COUPON_CODE_EXISTS_CODE = "11007", ACTIVITY_NAME_EXISTS_CODE = "11008",
            ACTIVITY_ALREADY_AUDIT_CODE = "11009", ACTIVITY_STATUS_NOT_ALLOW_DELETE_CODE = "11010",
            ORDER_ITEM_NOT_ALLOW_EMPTY="11011", NOT_ELIGIBLE_TO_JOIN ="11012";


    public static final MarketingExceptionCode SYSTEM_ERR = new MarketingExceptionCode(SYSTEM_ERR_CODE, "系统异常"),
            PARAMS_ERR = new MarketingExceptionCode(PARAMS_ERR_CODE, "请求参数错误：{}"),
            REQUEST_ERR = new MarketingExceptionCode(REQUEST_ERR_CODE, "接口调用异常：{}"),
            UNKNOWN_ERR = new MarketingExceptionCode(UNKNOWN_ERR_CODE, "未知异常"),
            RECORD_NOT_EXIST = new MarketingExceptionCode(RECORD_NOT_EXIST_CODE, "记录不存在：{}"),
            ENGINE_CONFIG_ERR = new MarketingExceptionCode(ENGINE_CONFIG_ERR_CODE, "引擎配置异常：{}"),
            STOCK_EMPTY = new MarketingExceptionCode(STOCK_EMPTY_CODE, "库存不足"),
            PARAMETER_ERROR = new MarketingExceptionCode(PARAMETER_ERROR_CODE, "{}"),
            TEMPLATE_NAME_EXISTS = new MarketingExceptionCode(TEMPLATE_NAME_EXISTS_CODE, "活动模版名称已存在"),
            TEMPLATE_CODE_EXISTS = new MarketingExceptionCode(TEMPLATE_CODE_EXISTS_CODE, "活动模版编码已存在"),
            ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL = new MarketingExceptionCode(ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL_CODE, "活动模版编码不允许为空"),
            ACTIVITY_TEMPLATE_CODE_NOT_EXISTS = new MarketingExceptionCode(ACTIVITY_TEMPLATE_CODE_NOT_EXISTS_CODE, "活动模版编码不存在"),
            COUPON_CODE_EXISTS = new MarketingExceptionCode(COUPON_CODE_EXISTS_CODE, "优惠券编码已存在"),
            ACTIVITY_NAME_EXISTS = new MarketingExceptionCode(ACTIVITY_NAME_EXISTS_CODE, "活动名称已存在"),
            ACTIVITY_ALREADY_AUDIT = new MarketingExceptionCode(ACTIVITY_ALREADY_AUDIT_CODE, "活动已审核"),
            ACTIVITY_STATUS_NOT_ALLOW_DELETE = new MarketingExceptionCode(ACTIVITY_STATUS_NOT_ALLOW_DELETE_CODE, "激活状态不允许删除活动"),
            ORDER_ITEM_NOT_ALLOW_EMPTY_ERR = new MarketingExceptionCode(ORDER_ITEM_NOT_ALLOW_EMPTY, "下单订单商品列表不能为空");

    private String code;

    private String message;

    public MarketingExceptionCode(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 格式化
     *
     * @param args
     * @return
     */
    public MarketingExceptionCode format(String... args) {
        MarketingExceptionCode code = new MarketingExceptionCode(this.code, this.message);

        if (args != null) {
            String message = this.message;
            for (String arg : args) {
                message = message.replaceFirst("\\{\\}", arg);
            }
            code.setMessage(message);
        }
        return code;
    }

    @Override
    public String toString() {
        return "MarketingExceptionCode{" +
                "code='" + code + '\'' +
                ", message='" + message + '\'' +
                '}';
    }


    public static MarketingExceptionCode valueOf(String resultCode) {
        if (StringUtils.isEmpty(resultCode)) {
            return MarketingExceptionCode.UNKNOWN_ERR;
        }
        switch (resultCode) {
            case SYSTEM_ERR_CODE:
                return MarketingExceptionCode.SYSTEM_ERR;
            case PARAMS_ERR_CODE:
                return MarketingExceptionCode.PARAMS_ERR;
            case REQUEST_ERR_CODE:
                return MarketingExceptionCode.REQUEST_ERR;
            case UNKNOWN_ERR_CODE:
                return MarketingExceptionCode.UNKNOWN_ERR;
            case RECORD_NOT_EXIST_CODE:
                return MarketingExceptionCode.RECORD_NOT_EXIST;
            case ENGINE_CONFIG_ERR_CODE:
                return MarketingExceptionCode.ENGINE_CONFIG_ERR;
            case STOCK_EMPTY_CODE:
                return MarketingExceptionCode.STOCK_EMPTY;
            case PARAMETER_ERROR_CODE:
                return MarketingExceptionCode.PARAMETER_ERROR;
            case TEMPLATE_NAME_EXISTS_CODE:
                return MarketingExceptionCode.TEMPLATE_NAME_EXISTS;
            case TEMPLATE_CODE_EXISTS_CODE:
                return MarketingExceptionCode.TEMPLATE_CODE_EXISTS;
            case ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL_CODE:
                return MarketingExceptionCode.ACTIVITY_TEMPLATE_CODE_CAN_NOT_BE_NULL;
            case ACTIVITY_TEMPLATE_CODE_NOT_EXISTS_CODE:
                return MarketingExceptionCode.ACTIVITY_TEMPLATE_CODE_NOT_EXISTS;
            case COUPON_CODE_EXISTS_CODE:
                return MarketingExceptionCode.COUPON_CODE_EXISTS;
            case ACTIVITY_NAME_EXISTS_CODE:
                return MarketingExceptionCode.ACTIVITY_NAME_EXISTS;
            case ACTIVITY_ALREADY_AUDIT_CODE:
                return MarketingExceptionCode.ACTIVITY_ALREADY_AUDIT;
            case ACTIVITY_STATUS_NOT_ALLOW_DELETE_CODE:
                return MarketingExceptionCode.ACTIVITY_STATUS_NOT_ALLOW_DELETE;
            default:
                return MarketingExceptionCode.SYSTEM_ERR;
        }
    }
}
