/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.ClusterTaskDependReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 营销中心：人群包依赖管理api
 *
 * @author 消息
 * @since 2.0.0
 */
@Api(tags = {"营销中心：人群包依赖管理api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-IClusterTaskDependApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/clusterTaskDepend", url = "${yundt.cube.center.marketing.api:}")
public interface IClusterTaskDependApi {

    @PostMapping
    @ResponseBody
    @ApiOperation(value = "人群包新增依赖管理", notes = "人群包新增依赖管理")
    RestResponse<Void> add(@RequestBody ClusterTaskDependReqDto dto);

    @PutMapping
    @ResponseBody
    @ApiOperation(value = "人群包更新依赖管理", notes = "人群包更新依赖管理")
    RestResponse<Void> update(@RequestBody ClusterTaskDependReqDto dto);

    @PostMapping("/status")
    @ResponseBody
    @ApiOperation(value = "人群包更新状态依赖管理", notes = "人群包更新状态依赖管理")
    RestResponse<Void> updateStatus(@RequestBody ClusterTaskDependReqDto dto);

    @DeleteMapping
    @ResponseBody
    @ApiOperation(value = "批量删除人群包依赖管理", notes = "批量删除人群包依赖管理")
    RestResponse<Void> delete(@RequestParam("id") List<Long> ids);
}
