package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service;

import com.dtyunxi.rest.RestResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @Author huangtongsheng
 * @Description  营销初始数据
 * @Date 11:05 2020/1/17
**/
@ApiIgnore
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-MarketingDataInitApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/marketing/data/init", url = "${yundt.cube.center.marketing.api:}")
public interface MarketingDataInitApi{

    /**
     * 营销业务模拟初始化数据
     * @return
     */
    @PostMapping("")
    RestResponse<String> marketingDataInit();


    /**
     * 清空初始业务营销数据
     * @return
     */
    @DeleteMapping("")
    RestResponse deletemarketingInitData();
}
