/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.service.query;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TaskDependReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.response.TaskDependRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 营销中心：人群包依赖管理查询api
 *
 * @author shenfei
 * @since 2.0.0
 */
@Api(tags = {"营销中心：人群包依赖管理查询api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-common-service-ITaskDependQueryApi", name = "${yundt.cube.center.marketing.api.name:yundt-cube-center-marketing}", path = "/v1/taskDepend", url = "${yundt.cube.center.marketing.api:}")
public interface ITaskDependQueryApi {

    @GetMapping
    @ResponseBody
    @ApiOperation(value = "人群包新增依赖管理", notes = "人群包新增依赖管理")
    PageInfo<TaskDependRespDto> page(@SpringQueryMap TaskDependReqDto dto);

}
