/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;

@Configuration
public class MySpringEncoder
extends SpringEncoder {
    private static Logger logger = LoggerFactory.getLogger(MySpringEncoder.class);

    public MySpringEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        super(messageConverters);
    }

    public static Field[] getAllFields(Class<?> clz) {
        if (clz == null) {
            return new Field[0];
        }
        Field[] fields = clz.getDeclaredFields();
        Field[] parentFields = MySpringEncoder.getAllFields(clz.getSuperclass());
        Field[] finalF = new Field[fields.length + parentFields.length];
        int i = 0;
        HashMap<String, Boolean> existMap = new HashMap<String, Boolean>();
        for (Field field : parentFields) {
            existMap.put(field.getName(), true);
            finalF[i++] = field;
        }
        for (Field field : fields) {
            if (existMap.containsKey(field.getName())) continue;
            finalF[i++] = field;
        }
        return finalF;
    }

    public void encode(Object requestBody, Type bodyType, RequestTemplate request) throws EncodeException {
        if (request.method().equals(HttpMethod.GET.name()) && requestBody != null) {
            HashMap<String, Collection<String>> queries = new HashMap<String, Collection<String>>();
            try {
                Field[] fields = MySpringEncoder.getAllFields(Class.forName(bodyType.getTypeName()));
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (null == field) continue;
                    try {
                        field.setAccessible(true);
                        Object value = field.get(requestBody);
                        if (value == null) continue;
                        this.getValueOfFiled("", queries, field, requestBody, value, field.getDeclaredAnnotations());
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        logger.warn("GET\u8bf7\u6c42\u4f53\u53c2\u6570\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Throwable)e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("GET\u8bf7\u6c42\u4f53\u53c2\u6570\u8f6c\u6362\u5f02\u5e382\uff1a{}", (Throwable)e);
            }
            request.queries(queries);
            super.encode(null, null, request);
        } else {
            super.encode(requestBody, bodyType, request);
        }
    }

    private void getValueOfFiled(String prefix, Map<String, Collection<String>> queries, Field field, Object requestBody, Object value, Annotation[] annotations) throws IllegalAccessException {
        Class<?> clz = field.getType();
        if (Collection.class.isAssignableFrom(clz)) {
            Collection collection = (Collection)value;
            int i = 0;
            for (Object o : collection) {
                this.dealWithElement(prefix, queries, field.getName(), o, i++, annotations);
            }
        } else if (Map.class.isAssignableFrom(clz)) {
            try {
                this.buildMapProperty2Query(prefix, queries, (Map)field.get(requestBody), field.getName());
            }
            catch (IllegalAccessException e) {
                logger.warn("\u5c5e\u6027\u8bbf\u95ee\u5b89\u5168\u6027\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        } else if (Date.class.isAssignableFrom(clz)) {
            JsonFormat jsonFormat = field.getAnnotation(JsonFormat.class);
            if (jsonFormat != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(jsonFormat.pattern());
                this.putQuery(queries, prefix + field.getName(), simpleDateFormat.format((Date)value));
            } else {
                this.putQuery(queries, prefix + field.getName(), value);
            }
        } else if (clz.isArray()) {
            Object[] objects = (Object[])value;
            for (int i = 0; i < objects.length; ++i) {
                this.dealWithElement(prefix, queries, field.getName(), objects[i], i, annotations);
            }
        } else if (Enum.class.isAssignableFrom(clz)) {
            Enum e = (Enum)value;
            this.putQuery(queries, prefix + field.getName(), e.name());
        } else if (MySpringEncoder.canDirectlyTransefer(clz)) {
            this.putQuery(queries, prefix + field.getName(), field.get(requestBody));
        } else {
            Field[] fields;
            for (Field f : fields = value.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = f.get(value);
                if (v == null) continue;
                this.getValueOfFiled(field.getName() + ".", queries, f, value, v, annotations);
            }
        }
    }

    private void buildMapProperty2Query(String prefix, Map<String, Collection<String>> queries, Map o2, String name) {
        Map map = o2;
        for (Map.Entry entry : map.entrySet()) {
            StringBuilder key = new StringBuilder();
            StringBuilder value = new StringBuilder();
            value.append("[").append(entry.getKey()).append("]");
            key.append(name).append(this.encodeValue(value));
            this.putQuery(queries, prefix + key, entry.getValue());
        }
    }

    private void dealWithElement(String prefix, Map<String, Collection<String>> queries, String key, Object object, int index, Annotation[] annotations) throws IllegalAccessException {
        if (object == null) {
            return;
        }
        Class<?> clz = object.getClass();
        if (Collection.class.isAssignableFrom(clz)) {
            Collection collection = (Collection)object;
            int i = 0;
            for (Object o : collection) {
                this.dealWithElement(prefix, queries, key, o, i++, annotations);
            }
        } else if (Map.class.isAssignableFrom(clz)) {
            this.buildMapProperty2Query(prefix, queries, (Map)object, key);
        } else if (Date.class.isAssignableFrom(clz)) {
            JsonFormat jsonFormat = null;
            for (Annotation annotation : annotations) {
                if (!annotation.getClass().isAssignableFrom(JsonFormat.class)) continue;
                jsonFormat = (JsonFormat)annotation;
            }
            if (jsonFormat != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(jsonFormat.pattern());
                this.putQuery(queries, prefix + key, simpleDateFormat.format((Date)object));
            } else {
                this.putQuery(queries, prefix + key, object);
            }
        } else if (clz.isArray()) {
            Object[] objects = (Object[])object;
            for (int i = 0; i < objects.length; ++i) {
                this.dealWithElement(prefix, queries, key, objects[i], i, annotations);
            }
        } else if (Enum.class.isAssignableFrom(clz)) {
            Enum e = (Enum)object;
            this.putQuery(queries, prefix + key, e.name());
        } else if (MySpringEncoder.canDirectlyTransefer(clz)) {
            this.putQuery(queries, prefix + key, object);
        } else {
            Field[] fields;
            for (Field f : fields = object.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = f.get(object);
                if (v == null) continue;
                this.getValueOfFiled(prefix + key + this.encodeValue("[" + index + "]."), queries, f, object, v, annotations);
            }
        }
    }

    public static boolean canDirectlyTransefer(Class<?> clz) {
        return Integer.TYPE.isAssignableFrom(clz) || Short.TYPE.isAssignableFrom(clz) || Byte.TYPE.isAssignableFrom(clz) || Boolean.TYPE.isAssignableFrom(clz) || Long.TYPE.isAssignableFrom(clz) || Float.TYPE.isAssignableFrom(clz) || Double.TYPE.isAssignableFrom(clz) || Character.TYPE.isAssignableFrom(clz) || Integer.class.isAssignableFrom(clz) || Short.class.isAssignableFrom(clz) || Byte.class.isAssignableFrom(clz) || Boolean.class.isAssignableFrom(clz) || Long.class.isAssignableFrom(clz) || Float.class.isAssignableFrom(clz) || Double.class.isAssignableFrom(clz) || Character.class.isAssignableFrom(clz) || String.class.isAssignableFrom(clz) || StringBuilder.class.isAssignableFrom(clz) || StringBuffer.class.isAssignableFrom(clz);
    }

    private String encodeValue(Object value) {
        return String.valueOf(value);
    }

    private void putQuery(Map<String, Collection<String>> queries, String key, Object value) {
        Collection<Object> values = null;
        if (queries.containsKey(key)) {
            values = queries.get(key);
        } else {
            values = new ArrayList();
            queries.put(key, values);
        }
        values.add(this.encodeValue(value));
    }
}

