/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.enums.tag;

import org.apache.commons.lang3.StringUtils;

public enum TagCompareEnum {
    eq("=", "\u7b49\u4e8e"),
    ne("!=", "\u4e0d\u7b49\u4e8e"),
    gt(">", "\u5927\u4e8e"),
    ge(">=", "\u5927\u4e8e\u7b49\u4e8e"),
    lt("<", "\u5c0f\u4e8e"),
    le("<=", "\u5c0f\u4e8e\u7b49\u4e8e"),
    in("in", "\u5728\u5217\u8868"),
    notIn("not in", "\u4e0d\u5728\u5217\u8868"),
    isNull("is null", "\u7b49\u4e8e\u7a7a"),
    isNotNull("is not null", "\u4e0d\u7b49\u4e8e\u7a7a"),
    like("like", "\u5305\u542b"),
    notLike("no like", "\u4e0d\u5305\u542b");

    private String code;
    private String desc;

    public static TagCompareEnum getByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        for (TagCompareEnum tagTypeEnum : TagCompareEnum.values()) {
            if (!code.equals(tagTypeEnum.getCode())) continue;
            return tagTypeEnum;
        }
        return null;
    }

    private TagCompareEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static TagCompareEnum negateCompare(TagCompareEnum compare) {
        if (compare == null) {
            return null;
        }
        switch (compare) {
            case eq: {
                compare = ne;
                break;
            }
            case ne: {
                compare = eq;
                break;
            }
            case gt: {
                compare = le;
                break;
            }
            case ge: {
                compare = lt;
                break;
            }
            case le: {
                compare = gt;
                break;
            }
            case lt: {
                compare = ge;
                break;
            }
            case in: {
                compare = notIn;
                break;
            }
            case notIn: {
                compare = in;
                break;
            }
            case like: {
                compare = notLike;
                break;
            }
            case notLike: {
                compare = like;
            }
        }
        return compare;
    }
}

