/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.bean.name.PluginAnnotationBeanNameGenerator;
import java.util.HashSet;
import java.util.List;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.GenericApplicationContext;

public class MapperHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapperHandler.class);
    private static final String MAPPER_INTERFACE_NAMES = "MybatisMapperInterfaceNames";
    private final ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();

    public void processMapper(PluginRegistryInfo pluginRegistryInfo, ProcessMapper processMapper) {
        GenericApplicationContext applicationContext = pluginRegistryInfo.getPluginApplicationContext();
        List groupClasses = pluginRegistryInfo.getGroupClasses("plugin_mybatis_mapper");
        if (groupClasses == null || groupClasses.isEmpty()) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        HashSet<String> beanNames = new HashSet<String>();
        for (Class groupClass : groupClasses) {
            if (groupClass == null) continue;
            PluginAnnotationBeanNameGenerator beanNameGenerator = new PluginAnnotationBeanNameGenerator(pluginId);
            AnnotatedGenericBeanDefinition abd = new AnnotatedGenericBeanDefinition(groupClass);
            ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata((BeanDefinition)abd);
            abd.setScope(scopeMetadata.getScopeName());
            String beanName = beanNameGenerator.generateBeanName((BeanDefinition)abd, (BeanDefinitionRegistry)applicationContext);
            BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder((BeanDefinition)abd, beanName);
            AnnotationConfigUtils.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)abd);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)applicationContext);
            try {
                processMapper.process(definitionHolder, groupClass);
                beanNames.add(beanName);
            }
            catch (Exception e) {
                LOGGER.error("process mapper '{}' error. {}", new Object[]{groupClass.getName(), e.getMessage(), e});
            }
        }
        pluginRegistryInfo.addExtension(MAPPER_INTERFACE_NAMES, beanNames);
    }

    public void commonProcessMapper(BeanDefinitionHolder holder, Class<?> mapperClass, SqlSessionFactory sqlSessionFactory, SqlSessionTemplate sqlSessionTemplate) {
        GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
        definition.getConstructorArgumentValues().addGenericArgumentValue(mapperClass);
        definition.setBeanClass(MapperFactoryBean.class);
        definition.getPropertyValues().add("addToConfig", (Object)true);
        definition.getPropertyValues().add("sqlSessionFactory", (Object)sqlSessionFactory);
        definition.getPropertyValues().add("sqlSessionTemplate", (Object)sqlSessionTemplate);
        definition.setAutowireMode(2);
    }

    @FunctionalInterface
    public static interface ProcessMapper {
        public void process(BeanDefinitionHolder var1, Class<?> var2) throws Exception;
    }
}

