/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis;

import com.gitee.starblues.factory.PluginRegistryInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class PluginResourceFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginResourceFinder.class);
    private static final String TYPE_FILE = "file";
    private static final String TYPE_CLASSPATH = "classpath";
    private static final String TYPE_PACKAGE = "package";
    private final ClassLoader classLoader;
    private final ResourcePatternResolver resourcePatternResolver;
    private final MetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();

    public PluginResourceFinder(PluginRegistryInfo pluginRegistryInfo) {
        this.classLoader = pluginRegistryInfo.getDefaultPluginClassLoader();
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver(this.classLoader);
    }

    public Resource[] getXmlResource(Set<String> xmlLocationsMatchSet) throws IOException {
        if (xmlLocationsMatchSet == null || xmlLocationsMatchSet.isEmpty()) {
            return null;
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String xmlLocationsMatch : xmlLocationsMatchSet) {
            List<Resource> loadResources;
            if (StringUtils.isEmpty((Object)xmlLocationsMatch) || (loadResources = this.getXmlResources(xmlLocationsMatch)) == null || loadResources.isEmpty()) continue;
            resources.addAll(loadResources);
        }
        if (resources.isEmpty()) {
            return null;
        }
        return resources.toArray(new Resource[0]);
    }

    public Class<?>[] getAliasesClasses(Set<String> packagePatterns) throws IOException {
        if (packagePatterns == null || packagePatterns.isEmpty()) {
            return null;
        }
        HashSet aliasesClasses = new HashSet();
        for (String packagePattern : packagePatterns) {
            Resource[] resources;
            for (Resource resource : resources = this.resourcePatternResolver.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packagePattern) + "/**/*.class")) {
                try {
                    ClassMetadata classMetadata = this.metadataReaderFactory.getMetadataReader(resource).getClassMetadata();
                    Class<?> clazz = this.classLoader.loadClass(classMetadata.getClassName());
                    aliasesClasses.add(clazz);
                }
                catch (Throwable e) {
                    LOGGER.warn("Cannot load the '{}'. Cause by {}", (Object)resource, (Object)e.toString());
                }
            }
        }
        return aliasesClasses.toArray(new Class[0]);
    }

    private List<Resource> getXmlResources(String mybatisMapperXmlLocationMatch) throws IOException {
        String[] split = mybatisMapperXmlLocationMatch.split(":");
        if (split.length != 2) {
            return null;
        }
        String type = split[0];
        String location = split[1];
        String matchLocation = null;
        if (Objects.equals(type, TYPE_CLASSPATH) || Objects.equals(type, TYPE_FILE)) {
            matchLocation = location;
        } else if (Objects.equals(type, TYPE_PACKAGE)) {
            matchLocation = location.replace(".", "/");
        }
        if (matchLocation == null) {
            LOGGER.error("mybatisMapperXmlLocation {} illegal", (Object)mybatisMapperXmlLocationMatch);
            return null;
        }
        try {
            Resource[] resources = this.resourcePatternResolver.getResources(matchLocation);
            if (resources.length > 0) {
                return Arrays.asList(resources);
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.error("mybatis xml resource '{}' match error : {}", new Object[]{mybatisMapperXmlLocationMatch, e.getMessage(), e});
            throw e;
        }
    }
}

