/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis.mybatisplus;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.gitee.starblues.extension.mybatis.MapperHandler;
import com.gitee.starblues.extension.mybatis.PluginFollowCoreConfig;
import com.gitee.starblues.extension.mybatis.PluginResourceFinder;
import com.gitee.starblues.extension.mybatis.mybatisplus.SpringBootMybatisPlusConfig;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

public class MybatisPlusProcessor
implements PluginBeanRegistrarExtend {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisPlusProcessor.class);

    public String key() {
        return "MybatisPlusProcessor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Resource[] xmlResource;
        SpringBootMybatisPlusConfig config = (SpringBootMybatisPlusConfig)SpringBeanUtils.getObjectByInterfaceClass((Set)pluginRegistryInfo.getConfigSingletons(), SpringBootMybatisPlusConfig.class);
        if (config == null) {
            return;
        }
        MybatisSqlSessionFactoryBean factory = new MybatisSqlSessionFactoryBean();
        if (config.enableOneselfConfig()) {
            config.oneselfConfig(factory);
        } else {
            LanguageDriver[] languageDriver;
            DatabaseIdProvider databaseIdProvider;
            PluginFollowCoreConfig followCoreConfig = new PluginFollowCoreConfig((ApplicationContext)pluginRegistryInfo.getMainApplicationContext());
            factory.setDataSource(followCoreConfig.getDataSource());
            factory.setConfiguration(followCoreConfig.getMybatisPlusConfiguration());
            Interceptor[] interceptor = followCoreConfig.getInterceptor();
            if (interceptor != null && interceptor.length > 0) {
                factory.setPlugins(interceptor);
            }
            if ((databaseIdProvider = followCoreConfig.getDatabaseIdProvider()) != null) {
                factory.setDatabaseIdProvider(databaseIdProvider);
            }
            if ((languageDriver = followCoreConfig.getLanguageDriver()) != null) {
                factory.setScriptingLanguageDrivers(languageDriver);
            }
            this.mybatisPlusFollowCoreConfig(factory, pluginRegistryInfo.getMainApplicationContext());
        }
        PluginResourceFinder pluginResourceFinder = new PluginResourceFinder(pluginRegistryInfo);
        Class[] aliasesClasses = pluginResourceFinder.getAliasesClasses(config.entityPackage());
        if (aliasesClasses != null && aliasesClasses.length > 0) {
            factory.setTypeAliases(aliasesClasses);
        }
        if ((xmlResource = pluginResourceFinder.getXmlResource(config.xmlLocationsMatch())) != null && xmlResource.length > 0) {
            factory.setMapperLocations(xmlResource);
        }
        ClassLoader defaultClassLoader = Resources.getDefaultClassLoader();
        try {
            Resources.setDefaultClassLoader((ClassLoader)pluginRegistryInfo.getDefaultPluginClassLoader());
            SqlSessionFactory sqlSessionFactory = factory.getObject();
            if (sqlSessionFactory == null) {
                throw new Exception("Get mybatis-plus sqlSessionFactory is null");
            }
            SqlSessionTemplate sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory);
            MapperHandler mapperHandler = new MapperHandler();
            mapperHandler.processMapper(pluginRegistryInfo, (holder, mapperClass) -> mapperHandler.commonProcessMapper(holder, mapperClass, sqlSessionFactory, sqlSessionTemplate));
        }
        finally {
            Resources.setDefaultClassLoader((ClassLoader)defaultClassLoader);
        }
    }

    private void mybatisPlusFollowCoreConfig(MybatisSqlSessionFactoryBean factory, GenericApplicationContext parentApplicationContext) {
        IKeyGenerator keyGenerator;
        MybatisPlusProperties plusProperties = (MybatisPlusProperties)parentApplicationContext.getBean(MybatisPlusProperties.class);
        GlobalConfig globalConfig = plusProperties.getGlobalConfig();
        if (parentApplicationContext.getBeanNamesForType(IKeyGenerator.class, false, false).length > 0) {
            keyGenerator = (IKeyGenerator)parentApplicationContext.getBean(IKeyGenerator.class);
            globalConfig.getDbConfig().setKeyGenerator(keyGenerator);
        }
        if (parentApplicationContext.getBeanNamesForType(MetaObjectHandler.class, false, false).length > 0) {
            MetaObjectHandler metaObjectHandler = (MetaObjectHandler)parentApplicationContext.getBean(MetaObjectHandler.class);
            globalConfig.setMetaObjectHandler(metaObjectHandler);
        }
        if (parentApplicationContext.getBeanNamesForType(IKeyGenerator.class, false, false).length > 0) {
            keyGenerator = (IKeyGenerator)parentApplicationContext.getBean(IKeyGenerator.class);
            globalConfig.getDbConfig().setKeyGenerator(keyGenerator);
        }
        if (parentApplicationContext.getBeanNamesForType(ISqlInjector.class, false, false).length > 0) {
            ISqlInjector iSqlInjector = (ISqlInjector)parentApplicationContext.getBean(ISqlInjector.class);
            globalConfig.setSqlInjector(iSqlInjector);
        }
        factory.setGlobalConfig(globalConfig);
    }
}

