/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.extension.mybatis.tkmyabtis;

import com.gitee.starblues.extension.mybatis.MapperHandler;
import com.gitee.starblues.extension.mybatis.PluginFollowCoreConfig;
import com.gitee.starblues.extension.mybatis.PluginResourceFinder;
import com.gitee.starblues.extension.mybatis.SpringBootMybatisExtension;
import com.gitee.starblues.extension.mybatis.tkmyabtis.SpringBootTkMybatisConfig;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.spring.mapper.MapperFactoryBean;

public class TkMybatisProcessor
implements PluginBeanRegistrarExtend {
    private static final Logger LOGGER = LoggerFactory.getLogger(TkMybatisProcessor.class);
    private final MapperFactoryBean<?> mapperFactoryBean = new MapperFactoryBean();

    public String key() {
        return "TkMybatisProcessor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Resource[] xmlResource;
        PluginResourceFinder pluginResourceFinder;
        Class[] aliasesClasses;
        SpringBootTkMybatisConfig config = (SpringBootTkMybatisConfig)SpringBeanUtils.getObjectByInterfaceClass((Set)pluginRegistryInfo.getConfigSingletons(), SpringBootTkMybatisConfig.class);
        if (config == null) {
            return;
        }
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        Config tkConfig = null;
        if (config.enableOneselfConfig()) {
            config.oneselfConfig(factory);
            tkConfig = new Config();
            config.oneselfConfig(tkConfig);
        } else {
            DatabaseIdProvider databaseIdProvider;
            GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
            PluginFollowCoreConfig followCoreConfig = new PluginFollowCoreConfig((ApplicationContext)mainApplicationContext);
            factory.setDataSource(followCoreConfig.getDataSource());
            factory.setConfiguration(followCoreConfig.getConfiguration(SpringBootMybatisExtension.Type.TK_MYBATIS));
            Interceptor[] interceptor = followCoreConfig.getInterceptor();
            if (interceptor != null && interceptor.length > 0) {
                factory.setPlugins(interceptor);
            }
            if ((databaseIdProvider = followCoreConfig.getDatabaseIdProvider()) != null) {
                factory.setDatabaseIdProvider(databaseIdProvider);
            }
            if (mainApplicationContext.getBeanNamesForType(Config.class, false, false).length > 0) {
                tkConfig = (Config)mainApplicationContext.getBean(Config.class);
            }
        }
        MapperHelper mapperHelper = new MapperHelper();
        if (tkConfig != null) {
            mapperHelper.setConfig(tkConfig);
        }
        if ((aliasesClasses = (pluginResourceFinder = new PluginResourceFinder(pluginRegistryInfo)).getAliasesClasses(config.entityPackage())) != null && aliasesClasses.length > 0) {
            factory.setTypeAliases(aliasesClasses);
        }
        if ((xmlResource = pluginResourceFinder.getXmlResource(config.xmlLocationsMatch())) != null && xmlResource.length > 0) {
            factory.setMapperLocations(xmlResource);
        }
        ClassLoader pluginClassLoader = pluginRegistryInfo.getDefaultPluginClassLoader();
        ClassLoader defaultClassLoader = Resources.getDefaultClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Resources.setDefaultClassLoader((ClassLoader)pluginClassLoader);
            SqlSessionFactory sqlSessionFactory = factory.getObject();
            if (sqlSessionFactory == null) {
                throw new Exception("Get tk-mybatis sqlSessionFactory is null");
            }
            SqlSessionTemplate sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory);
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            MapperHandler mapperHandler = new MapperHandler();
            mapperHandler.processMapper(pluginRegistryInfo, (holder, mapperClass) -> this.processMapper(holder, mapperClass, mapperHelper, sqlSessionFactory, sqlSessionTemplate));
        }
        finally {
            Resources.setDefaultClassLoader((ClassLoader)defaultClassLoader);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void processMapper(BeanDefinitionHolder holder, Class<?> mapperClass, MapperHelper mapperHelper, SqlSessionFactory sqlSessionFactory, SqlSessionTemplate sqlSessionTemplate) {
        GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
        definition.getConstructorArgumentValues().addGenericArgumentValue(mapperClass);
        definition.setBeanClass(this.mapperFactoryBean.getClass());
        definition.getPropertyValues().add("mapperHelper", (Object)mapperHelper);
        definition.getPropertyValues().add("addToConfig", (Object)true);
        definition.getPropertyValues().add("sqlSessionFactory", (Object)sqlSessionFactory);
        definition.getPropertyValues().add("sqlSessionTemplate", (Object)sqlSessionTemplate);
        definition.setAutowireMode(2);
    }
}

