/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpClientBuilder;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultOkHttpClientBuilder
implements OkHttpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultOkHttpClientBuilder.class);
    private final AtomicBoolean prepared = new AtomicBoolean(false);
    private Proxy proxy;
    private Authenticator authenticator;
    private final List<Interceptor> interceptorList = new ArrayList<Interceptor>();
    private Dispatcher dispatcher;
    private ConnectionPool connectionPool;
    private EventListener.Factory eventListenerFactory;
    private Boolean retryOnConnectionFailure;
    private Boolean followRedirects;
    private Long connectTimeout;
    private TimeUnit connectTimeUnit;
    private Long callTimeout;
    private TimeUnit callTimeUnit;
    private Long readTimeout;
    private TimeUnit readTimeUnit;
    private Long writeTimeout;
    private TimeUnit writeTimeUnit;
    private Integer pingInterval;
    private OkHttpClient okHttpClient;

    private DefaultOkHttpClientBuilder() {
    }

    public static DefaultOkHttpClientBuilder get() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public OkHttpClient build() {
        if (!this.prepared.get()) {
            this.prepare();
        }
        return this.okHttpClient;
    }

    @Override
    public OkHttpClientBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public OkHttpClientBuilder authenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    @Override
    public OkHttpClientBuilder addInterceptor(Interceptor interceptor) {
        this.interceptorList.add(interceptor);
        return this;
    }

    @Override
    public OkHttpClientBuilder setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    @Override
    public OkHttpClientBuilder setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    @Override
    public OkHttpClientBuilder setEventListenerFactory(EventListener.Factory eventListenerFactory) {
        this.eventListenerFactory = eventListenerFactory;
        return this;
    }

    @Override
    public OkHttpClientBuilder setRetryOnConnectionFailure(Boolean retryOnConnectionFailure) {
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        return this;
    }

    @Override
    public OkHttpClientBuilder setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public OkHttpClientBuilder connectTimeout(Long timeout, TimeUnit unit) {
        this.connectTimeout = timeout;
        this.connectTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder callTimeout(Long timeout, TimeUnit unit) {
        this.callTimeout = timeout;
        this.callTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder readTimeout(Long timeout, TimeUnit unit) {
        this.readTimeout = timeout;
        this.readTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder writeTimeout(Long timeout, TimeUnit unit) {
        this.writeTimeout = timeout;
        this.writeTimeUnit = unit;
        return this;
    }

    @Override
    public OkHttpClientBuilder setPingInterval(Integer pingInterval) {
        this.pingInterval = pingInterval;
        return this;
    }

    private synchronized void prepare() {
        if (this.prepared.get()) {
            return;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (this.authenticator != null) {
            builder.authenticator(this.authenticator);
        }
        if (this.proxy != null) {
            builder.proxy(this.proxy);
        }
        for (Interceptor interceptor : this.interceptorList) {
            builder.addInterceptor(interceptor);
        }
        if (this.dispatcher != null) {
            builder.dispatcher(this.dispatcher);
        }
        if (this.connectionPool != null) {
            builder.connectionPool(this.connectionPool);
        }
        if (this.eventListenerFactory != null) {
            builder.eventListenerFactory(this.eventListenerFactory);
        }
        if (this.retryOnConnectionFailure != null) {
            builder.setRetryOnConnectionFailure$okhttp(this.retryOnConnectionFailure.booleanValue());
        }
        if (this.followRedirects != null) {
            builder.followRedirects(this.followRedirects.booleanValue());
        }
        if (this.connectTimeout != null && this.connectTimeUnit != null) {
            builder.connectTimeout(this.connectTimeout.longValue(), this.connectTimeUnit);
        }
        if (this.callTimeout != null && this.callTimeUnit != null) {
            builder.callTimeout(this.callTimeout.longValue(), this.callTimeUnit);
        }
        if (this.readTimeout != null && this.readTimeUnit != null) {
            builder.readTimeout(this.readTimeout.longValue(), this.readTimeUnit);
        }
        if (this.writeTimeout != null && this.writeTimeUnit != null) {
            builder.writeTimeout(this.writeTimeout.longValue(), this.writeTimeUnit);
        }
        if (this.pingInterval != null) {
            builder.setPingInterval$okhttp(this.pingInterval.intValue());
        }
        this.okHttpClient = builder.build();
        this.prepared.set(true);
    }

    public AtomicBoolean getPrepared() {
        return this.prepared;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public List<Interceptor> getInterceptorList() {
        return this.interceptorList;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public EventListener.Factory getEventListenerFactory() {
        return this.eventListenerFactory;
    }

    public Boolean getRetryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeUnit getConnectTimeUnit() {
        return this.connectTimeUnit;
    }

    public Long getCallTimeout() {
        return this.callTimeout;
    }

    public TimeUnit getCallTimeUnit() {
        return this.callTimeUnit;
    }

    public Long getReadTimeout() {
        return this.readTimeout;
    }

    public TimeUnit getReadTimeUnit() {
        return this.readTimeUnit;
    }

    public Long getWriteTimeout() {
        return this.writeTimeout;
    }

    public TimeUnit getWriteTimeUnit() {
        return this.writeTimeUnit;
    }

    public Integer getPingInterval() {
        return this.pingInterval;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectTimeUnit(TimeUnit connectTimeUnit) {
        this.connectTimeUnit = connectTimeUnit;
    }

    public void setCallTimeout(Long callTimeout) {
        this.callTimeout = callTimeout;
    }

    public void setCallTimeUnit(TimeUnit callTimeUnit) {
        this.callTimeUnit = callTimeUnit;
    }

    public void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setReadTimeUnit(TimeUnit readTimeUnit) {
        this.readTimeUnit = readTimeUnit;
    }

    public void setWriteTimeout(Long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setWriteTimeUnit(TimeUnit writeTimeUnit) {
        this.writeTimeUnit = writeTimeUnit;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultOkHttpClientBuilder)) {
            return false;
        }
        DefaultOkHttpClientBuilder other = (DefaultOkHttpClientBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$retryOnConnectionFailure = this.getRetryOnConnectionFailure();
        Boolean other$retryOnConnectionFailure = other.getRetryOnConnectionFailure();
        if (this$retryOnConnectionFailure == null ? other$retryOnConnectionFailure != null : !((Object)this$retryOnConnectionFailure).equals(other$retryOnConnectionFailure)) {
            return false;
        }
        Boolean this$followRedirects = this.getFollowRedirects();
        Boolean other$followRedirects = other.getFollowRedirects();
        if (this$followRedirects == null ? other$followRedirects != null : !((Object)this$followRedirects).equals(other$followRedirects)) {
            return false;
        }
        Long this$connectTimeout = this.getConnectTimeout();
        Long other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Long this$callTimeout = this.getCallTimeout();
        Long other$callTimeout = other.getCallTimeout();
        if (this$callTimeout == null ? other$callTimeout != null : !((Object)this$callTimeout).equals(other$callTimeout)) {
            return false;
        }
        Long this$readTimeout = this.getReadTimeout();
        Long other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Long this$writeTimeout = this.getWriteTimeout();
        Long other$writeTimeout = other.getWriteTimeout();
        if (this$writeTimeout == null ? other$writeTimeout != null : !((Object)this$writeTimeout).equals(other$writeTimeout)) {
            return false;
        }
        Integer this$pingInterval = this.getPingInterval();
        Integer other$pingInterval = other.getPingInterval();
        if (this$pingInterval == null ? other$pingInterval != null : !((Object)this$pingInterval).equals(other$pingInterval)) {
            return false;
        }
        AtomicBoolean this$prepared = this.getPrepared();
        AtomicBoolean other$prepared = other.getPrepared();
        if (this$prepared == null ? other$prepared != null : !this$prepared.equals(other$prepared)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        Authenticator this$authenticator = this.getAuthenticator();
        Authenticator other$authenticator = other.getAuthenticator();
        if (this$authenticator == null ? other$authenticator != null : !this$authenticator.equals(other$authenticator)) {
            return false;
        }
        List<Interceptor> this$interceptorList = this.getInterceptorList();
        List<Interceptor> other$interceptorList = other.getInterceptorList();
        if (this$interceptorList == null ? other$interceptorList != null : !((Object)this$interceptorList).equals(other$interceptorList)) {
            return false;
        }
        Dispatcher this$dispatcher = this.getDispatcher();
        Dispatcher other$dispatcher = other.getDispatcher();
        if (this$dispatcher == null ? other$dispatcher != null : !this$dispatcher.equals(other$dispatcher)) {
            return false;
        }
        ConnectionPool this$connectionPool = this.getConnectionPool();
        ConnectionPool other$connectionPool = other.getConnectionPool();
        if (this$connectionPool == null ? other$connectionPool != null : !this$connectionPool.equals(other$connectionPool)) {
            return false;
        }
        EventListener.Factory this$eventListenerFactory = this.getEventListenerFactory();
        EventListener.Factory other$eventListenerFactory = other.getEventListenerFactory();
        if (this$eventListenerFactory == null ? other$eventListenerFactory != null : !this$eventListenerFactory.equals(other$eventListenerFactory)) {
            return false;
        }
        TimeUnit this$connectTimeUnit = this.getConnectTimeUnit();
        TimeUnit other$connectTimeUnit = other.getConnectTimeUnit();
        if (this$connectTimeUnit == null ? other$connectTimeUnit != null : !((Object)((Object)this$connectTimeUnit)).equals((Object)other$connectTimeUnit)) {
            return false;
        }
        TimeUnit this$callTimeUnit = this.getCallTimeUnit();
        TimeUnit other$callTimeUnit = other.getCallTimeUnit();
        if (this$callTimeUnit == null ? other$callTimeUnit != null : !((Object)((Object)this$callTimeUnit)).equals((Object)other$callTimeUnit)) {
            return false;
        }
        TimeUnit this$readTimeUnit = this.getReadTimeUnit();
        TimeUnit other$readTimeUnit = other.getReadTimeUnit();
        if (this$readTimeUnit == null ? other$readTimeUnit != null : !((Object)((Object)this$readTimeUnit)).equals((Object)other$readTimeUnit)) {
            return false;
        }
        TimeUnit this$writeTimeUnit = this.getWriteTimeUnit();
        TimeUnit other$writeTimeUnit = other.getWriteTimeUnit();
        if (this$writeTimeUnit == null ? other$writeTimeUnit != null : !((Object)((Object)this$writeTimeUnit)).equals((Object)other$writeTimeUnit)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        return !(this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultOkHttpClientBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $retryOnConnectionFailure = this.getRetryOnConnectionFailure();
        result = result * 59 + ($retryOnConnectionFailure == null ? 43 : ((Object)$retryOnConnectionFailure).hashCode());
        Boolean $followRedirects = this.getFollowRedirects();
        result = result * 59 + ($followRedirects == null ? 43 : ((Object)$followRedirects).hashCode());
        Long $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Long $callTimeout = this.getCallTimeout();
        result = result * 59 + ($callTimeout == null ? 43 : ((Object)$callTimeout).hashCode());
        Long $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Long $writeTimeout = this.getWriteTimeout();
        result = result * 59 + ($writeTimeout == null ? 43 : ((Object)$writeTimeout).hashCode());
        Integer $pingInterval = this.getPingInterval();
        result = result * 59 + ($pingInterval == null ? 43 : ((Object)$pingInterval).hashCode());
        AtomicBoolean $prepared = this.getPrepared();
        result = result * 59 + ($prepared == null ? 43 : $prepared.hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        Authenticator $authenticator = this.getAuthenticator();
        result = result * 59 + ($authenticator == null ? 43 : $authenticator.hashCode());
        List<Interceptor> $interceptorList = this.getInterceptorList();
        result = result * 59 + ($interceptorList == null ? 43 : ((Object)$interceptorList).hashCode());
        Dispatcher $dispatcher = this.getDispatcher();
        result = result * 59 + ($dispatcher == null ? 43 : $dispatcher.hashCode());
        ConnectionPool $connectionPool = this.getConnectionPool();
        result = result * 59 + ($connectionPool == null ? 43 : $connectionPool.hashCode());
        EventListener.Factory $eventListenerFactory = this.getEventListenerFactory();
        result = result * 59 + ($eventListenerFactory == null ? 43 : $eventListenerFactory.hashCode());
        TimeUnit $connectTimeUnit = this.getConnectTimeUnit();
        result = result * 59 + ($connectTimeUnit == null ? 43 : ((Object)((Object)$connectTimeUnit)).hashCode());
        TimeUnit $callTimeUnit = this.getCallTimeUnit();
        result = result * 59 + ($callTimeUnit == null ? 43 : ((Object)((Object)$callTimeUnit)).hashCode());
        TimeUnit $readTimeUnit = this.getReadTimeUnit();
        result = result * 59 + ($readTimeUnit == null ? 43 : ((Object)((Object)$readTimeUnit)).hashCode());
        TimeUnit $writeTimeUnit = this.getWriteTimeUnit();
        result = result * 59 + ($writeTimeUnit == null ? 43 : ((Object)((Object)$writeTimeUnit)).hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultOkHttpClientBuilder(prepared=" + this.getPrepared() + ", proxy=" + this.getProxy() + ", authenticator=" + this.getAuthenticator() + ", interceptorList=" + this.getInterceptorList() + ", dispatcher=" + this.getDispatcher() + ", connectionPool=" + this.getConnectionPool() + ", eventListenerFactory=" + this.getEventListenerFactory() + ", retryOnConnectionFailure=" + this.getRetryOnConnectionFailure() + ", followRedirects=" + this.getFollowRedirects() + ", connectTimeout=" + this.getConnectTimeout() + ", connectTimeUnit=" + (Object)((Object)this.getConnectTimeUnit()) + ", callTimeout=" + this.getCallTimeout() + ", callTimeUnit=" + (Object)((Object)this.getCallTimeUnit()) + ", readTimeout=" + this.getReadTimeout() + ", readTimeUnit=" + (Object)((Object)this.getReadTimeUnit()) + ", writeTimeout=" + this.getWriteTimeout() + ", writeTimeUnit=" + (Object)((Object)this.getWriteTimeUnit()) + ", pingInterval=" + this.getPingInterval() + ", okHttpClient=" + this.getOkHttpClient() + ")";
    }

    private static class SingletonHolder {
        private static final DefaultOkHttpClientBuilder INSTANCE = new DefaultOkHttpClientBuilder();

        private SingletonHolder() {
        }
    }
}

