/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.InputStreamData;
import me.chanjar.weixin.common.util.http.MediaInputStreamUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.cp.api.WxCpMediaService;
import me.chanjar.weixin.cp.api.WxCpService;

public class WxCpMediaServiceImpl
implements WxCpMediaService {
    private final WxCpService mainService;

    @Override
    public WxMediaUploadResult upload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.upload(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxMediaUploadResult upload(String mediaType, String filename, String url) throws WxErrorException, IOException {
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        try {
            URL remote = new URL(url);
            conn = (HttpURLConnection)remote.openConnection();
            conn.setConnectTimeout(60000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            WxMediaUploadResult wxMediaUploadResult = (WxMediaUploadResult)this.mainService.execute(MediaInputStreamUploadRequestExecutor.create(this.mainService.getRequestHttp()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/upload?type=" + mediaType), new InputStreamData(inputStream, filename));
            return wxMediaUploadResult;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public WxMediaUploadResult upload(String mediaType, File file) throws WxErrorException {
        return (WxMediaUploadResult)this.mainService.execute(MediaUploadRequestExecutor.create(this.mainService.getRequestHttp()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/upload?type=" + mediaType), file);
    }

    @Override
    public File download(String mediaId) throws WxErrorException {
        return (File)this.mainService.execute(BaseMediaDownloadRequestExecutor.create(this.mainService.getRequestHttp(), (File)this.mainService.getWxCpConfigStorage().getTmpDirFile()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/get"), "media_id=" + mediaId);
    }

    @Override
    public File getJssdkFile(String mediaId) throws WxErrorException {
        return (File)this.mainService.execute(BaseMediaDownloadRequestExecutor.create(this.mainService.getRequestHttp(), (File)this.mainService.getWxCpConfigStorage().getTmpDirFile()), this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/get/jssdk"), "media_id=" + mediaId);
    }

    @Override
    public String uploadImg(File file) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/uploadimg");
        return ((WxMediaUploadResult)this.mainService.execute(MediaUploadRequestExecutor.create(this.mainService.getRequestHttp()), url, file)).getUrl();
    }

    public WxCpMediaServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

