/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.external.msg;

import me.chanjar.weixin.cp.bean.external.msg.Attachment;
import me.chanjar.weixin.cp.bean.external.msg.File;
import me.chanjar.weixin.cp.bean.external.msg.Image;
import me.chanjar.weixin.cp.bean.external.msg.Link;
import me.chanjar.weixin.cp.bean.external.msg.MiniProgram;
import me.chanjar.weixin.cp.bean.external.msg.Video;

public class AttachmentBuilder {
    private static Attachment image(String mediaId, String picUrl) {
        Image image = new Image().setMediaId(mediaId).setPicUrl(picUrl);
        return new Attachment().setImage(image);
    }

    private static Attachment video(String mediaId) {
        Video video = new Video().setMediaId(mediaId);
        return new Attachment().setVideo(video);
    }

    private static Attachment file(String mediaId) {
        File file = new File().setMediaId(mediaId);
        return new Attachment().setFile(file);
    }

    private static Attachment link(String title, String url, String picUrl, String desc) {
        Link link = new Link().setTitle(title).setPicUrl(picUrl).setUrl(url).setDesc(desc);
        return new Attachment().setLink(link);
    }

    private static Attachment miniProgram(String title, String picMediaId, String appId, String page) {
        MiniProgram miniProgram = new MiniProgram().setTitle(title).setPicMediaId(picMediaId).setAppid(appId).setPage(page);
        return new Attachment().setMiniProgram(miniProgram);
    }

    public static ImageBuilder imageBuilder() {
        return new ImageBuilder();
    }

    public static VideoBuilder videoBuilder() {
        return new VideoBuilder();
    }

    public static FileBuilder fileBuilder() {
        return new FileBuilder();
    }

    public static LinkBuilder linkBuilder() {
        return new LinkBuilder();
    }

    public static MiniProgramBuilder miniProgramBuilder() {
        return new MiniProgramBuilder();
    }

    public static class MiniProgramBuilder {
        private String title;
        private String picMediaId;
        private String appId;
        private String page;

        MiniProgramBuilder() {
        }

        public MiniProgramBuilder title(String title) {
            this.title = title;
            return this;
        }

        public MiniProgramBuilder picMediaId(String picMediaId) {
            this.picMediaId = picMediaId;
            return this;
        }

        public MiniProgramBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public MiniProgramBuilder page(String page) {
            this.page = page;
            return this;
        }

        public Attachment build() {
            return AttachmentBuilder.miniProgram(this.title, this.picMediaId, this.appId, this.page);
        }

        public String toString() {
            return "AttachmentBuilder.MiniProgramBuilder(title=" + this.title + ", picMediaId=" + this.picMediaId + ", appId=" + this.appId + ", page=" + this.page + ")";
        }
    }

    public static class LinkBuilder {
        private String title;
        private String url;
        private String picUrl;
        private String desc;

        LinkBuilder() {
        }

        public LinkBuilder title(String title) {
            this.title = title;
            return this;
        }

        public LinkBuilder url(String url) {
            this.url = url;
            return this;
        }

        public LinkBuilder picUrl(String picUrl) {
            this.picUrl = picUrl;
            return this;
        }

        public LinkBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public Attachment build() {
            return AttachmentBuilder.link(this.title, this.url, this.picUrl, this.desc);
        }

        public String toString() {
            return "AttachmentBuilder.LinkBuilder(title=" + this.title + ", url=" + this.url + ", picUrl=" + this.picUrl + ", desc=" + this.desc + ")";
        }
    }

    public static class FileBuilder {
        private String mediaId;

        FileBuilder() {
        }

        public FileBuilder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public Attachment build() {
            return AttachmentBuilder.file(this.mediaId);
        }

        public String toString() {
            return "AttachmentBuilder.FileBuilder(mediaId=" + this.mediaId + ")";
        }
    }

    public static class VideoBuilder {
        private String mediaId;

        VideoBuilder() {
        }

        public VideoBuilder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public Attachment build() {
            return AttachmentBuilder.video(this.mediaId);
        }

        public String toString() {
            return "AttachmentBuilder.VideoBuilder(mediaId=" + this.mediaId + ")";
        }
    }

    public static class ImageBuilder {
        private String mediaId;
        private String picUrl;

        ImageBuilder() {
        }

        public ImageBuilder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public ImageBuilder picUrl(String picUrl) {
            this.picUrl = picUrl;
            return this;
        }

        public Attachment build() {
            return AttachmentBuilder.image(this.mediaId, this.picUrl);
        }

        public String toString() {
            return "AttachmentBuilder.ImageBuilder(mediaId=" + this.mediaId + ", picUrl=" + this.picUrl + ")";
        }
    }
}

