/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.license.WxCpTpLicenseActiveAccount;
import me.chanjar.weixin.cp.bean.license.WxCpTpLicenseTransfer;
import me.chanjar.weixin.cp.bean.license.account.WxCpTpLicenseActiveInfoByUserResp;
import me.chanjar.weixin.cp.bean.license.account.WxCpTpLicenseBatchActiveResultResp;
import me.chanjar.weixin.cp.bean.license.account.WxCpTpLicenseBatchCodeInfoResp;
import me.chanjar.weixin.cp.bean.license.account.WxCpTpLicenseBatchTransferResp;
import me.chanjar.weixin.cp.bean.license.account.WxCpTpLicenseCodeInfoResp;
import me.chanjar.weixin.cp.bean.license.account.WxCpTpLicenseCorpAccountListResp;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseCreateOrderResp;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseNewOrderRequest;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseOrderAccountListResp;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseOrderInfoResp;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseOrderListResp;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseRenewOrderJobRequest;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseRenewOrderJobResp;
import me.chanjar.weixin.cp.bean.license.order.WxCpTpLicenseRenewOrderRequest;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.tp.service.WxCpTpLicenseService;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;

public class WxCpTpLicenseServiceImpl
implements WxCpTpLicenseService {
    private final WxCpTpService mainService;

    @Override
    public WxCpTpLicenseCreateOrderResp createNewOrder(WxCpTpLicenseNewOrderRequest licenseNewOrderRequest) throws WxErrorException {
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/create_new_order") + this.getProviderAccessToken(), licenseNewOrderRequest.toJson());
        return WxCpTpLicenseCreateOrderResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseRenewOrderJobResp createRenewOrderJob(WxCpTpLicenseRenewOrderJobRequest licenseRenewOrderJobRequest) throws WxErrorException {
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/create_renew_order_job") + this.getProviderAccessToken(), licenseRenewOrderJobRequest.toJson());
        return WxCpTpLicenseRenewOrderJobResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseCreateOrderResp submitRenewOrder(WxCpTpLicenseRenewOrderRequest licenseRenewOrderRequest) throws WxErrorException {
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/submit_order_job") + this.getProviderAccessToken(), licenseRenewOrderRequest.toJson());
        return WxCpTpLicenseCreateOrderResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseOrderListResp getOrderList(String corpId, Date startTime, Date endTime, String cursor, int limit) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("corpid", corpId);
        jsonObject.addProperty("cursor", cursor);
        jsonObject.addProperty("limit", (Number)limit);
        if (startTime != null) {
            jsonObject.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        }
        if (endTime != null) {
            jsonObject.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        }
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/list_order") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpTpLicenseOrderListResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseOrderInfoResp getOrderInfo(String orderId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("order_id", orderId);
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/get_order") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpTpLicenseOrderInfoResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseOrderAccountListResp getOrderAccountList(String orderId, int limit, String cursor) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("order_id", orderId);
        jsonObject.addProperty("cursor", cursor);
        jsonObject.addProperty("limit", (Number)limit);
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/list_order_account") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpTpLicenseOrderAccountListResp.fromJson(resultText);
    }

    @Override
    public WxCpBaseResp activeCode(String code, String corpId, String userId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("active_code", code);
        jsonObject.addProperty("corpid", corpId);
        jsonObject.addProperty("userid", userId);
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/active_account") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpBaseResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseBatchActiveResultResp batchActiveCode(String corpId, List<WxCpTpLicenseActiveAccount> activeAccountList) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("corpid", corpId);
        map.put("active_list", activeAccountList);
        GsonBuilder gsonBuilder = new GsonBuilder();
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/batch_active_account") + this.getProviderAccessToken(), gsonBuilder.create().toJson(map));
        return WxCpTpLicenseBatchActiveResultResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseCodeInfoResp getActiveInfoByCode(String code, String corpId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("active_code", code);
        jsonObject.addProperty("corpid", corpId);
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/get_active_info_by_code") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpTpLicenseCodeInfoResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseBatchCodeInfoResp batchGetActiveInfoByCode(Collection<String> codes, String corpId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        JsonArray list = new JsonArray();
        for (String code : codes) {
            list.add((JsonElement)new JsonPrimitive(code));
        }
        jsonObject.add("active_code_list", (JsonElement)list);
        jsonObject.addProperty("corpid", corpId);
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/batch_get_active_info_by_code") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpTpLicenseBatchCodeInfoResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseCorpAccountListResp getCorpAccountList(String corpId, int limit, String cursor) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("corpid", corpId);
        jsonObject.addProperty("cursor", cursor);
        jsonObject.addProperty("limit", (Number)limit);
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/list_actived_account") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpTpLicenseCorpAccountListResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseActiveInfoByUserResp getActiveInfoByUser(String corpId, String userId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("corpid", corpId);
        jsonObject.addProperty("userid", userId);
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/get_active_info_by_user") + this.getProviderAccessToken(), jsonObject.toString());
        return WxCpTpLicenseActiveInfoByUserResp.fromJson(resultText);
    }

    @Override
    public WxCpTpLicenseBatchTransferResp batchTransferLicense(String corpId, List<WxCpTpLicenseTransfer> transferList) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("corpid", corpId);
        map.put("transfer_list", transferList);
        GsonBuilder gsonBuilder = new GsonBuilder();
        String resultText = this.mainService.post(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/license/batch_transfer_license") + this.getProviderAccessToken(), gsonBuilder.create().toJson(map));
        return WxCpTpLicenseBatchTransferResp.fromJson(resultText);
    }

    private String getProviderAccessToken() throws WxErrorException {
        return "?provider_access_token=" + this.mainService.getWxCpProviderToken();
    }

    private WxCpTpConfigStorage getWxCpTpConfigStorage() {
        return this.mainService.getWxCpTpConfigStorage();
    }

    public WxCpTpLicenseServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

