/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.util.crypt;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import com.google.common.base.CharMatcher;
import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.crypto.PKCS7Encoder;
import me.chanjar.weixin.common.util.crypto.WxCryptUtil;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WxMaCryptUtils
extends WxCryptUtil {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    public WxMaCryptUtils(WxMaConfig config) {
        this.appidOrCorpid = config.getAppid();
        this.token = config.getToken();
        this.aesKey = BaseEncoding.base64().decode((CharSequence)CharMatcher.whitespace().removeFrom((CharSequence)config.getAesKey()));
    }

    public static String decrypt(String sessionKey, String encryptedData, String ivStr) {
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
            params.init(new IvParameterSpec(Base64.decodeBase64((String)ivStr)));
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(Base64.decodeBase64((String)sessionKey), "AES"), params);
            return new String(PKCS7Encoder.decode((byte[])cipher.doFinal(Base64.decodeBase64((String)encryptedData))), UTF_8);
        }
        catch (Exception e) {
            throw new WxRuntimeException("AES\u89e3\u5bc6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static String decryptAnotherWay(String sessionKey, String encryptedData, String ivStr) {
        int base;
        byte[] keyBytes = Base64.decodeBase64((byte[])sessionKey.getBytes(UTF_8));
        if (keyBytes.length % (base = 16) != 0) {
            int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            cipher.init(2, (Key)key, new IvParameterSpec(Base64.decodeBase64((byte[])ivStr.getBytes(UTF_8))));
            return new String(cipher.doFinal(Base64.decodeBase64((byte[])encryptedData.getBytes(UTF_8))), UTF_8);
        }
        catch (Exception e) {
            throw new WxRuntimeException("AES\u89e3\u5bc6\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

