/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.impl.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SchemaCleanUpUtils {
    private final SchemaGeneratorConfig config;
    private final Map<SchemaKeyword, BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>> allOfMergeFunctions;

    public SchemaCleanUpUtils(SchemaGeneratorConfig config) {
        this.config = config;
        this.allOfMergeFunctions = this.prepareAllOfMergeFunctions();
    }

    private Map<SchemaKeyword, BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>> prepareAllOfMergeFunctions() {
        HashMap<SchemaKeyword, BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>> result = new HashMap<SchemaKeyword, BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>>();
        BiFunction<List, Map, Supplier> mergeArrays = (valuesToMerge, _ignored) -> this.mergeArrays((List<JsonNode>)valuesToMerge);
        Stream.of(SchemaKeyword.TAG_ALLOF, SchemaKeyword.TAG_REQUIRED).forEach(keyword -> result.put((SchemaKeyword)((Object)keyword), (BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>)mergeArrays));
        result.put(SchemaKeyword.TAG_PROPERTIES, (valuesToMerge, _ignored) -> this.mergeObjectProperties((List<JsonNode>)valuesToMerge));
        result.put(SchemaKeyword.TAG_DEPENDENT_REQUIRED, (valuesToMerge, _ignored) -> this.mergeDependentRequiredNode((List<JsonNode>)valuesToMerge));
        result.put(SchemaKeyword.TAG_DEPENDENT_SCHEMAS, (valuesToMerge, _ignored) -> {
            if (this.config.getSchemaVersion() == SchemaVersion.DRAFT_6 || this.config.getSchemaVersion() == SchemaVersion.DRAFT_7) {
                return Optional.ofNullable(this.mergeDependentRequiredNode((List<JsonNode>)valuesToMerge)).orElseGet(() -> this.mergeObjectProperties((List<JsonNode>)valuesToMerge));
            }
            return this.mergeObjectProperties((List<JsonNode>)valuesToMerge);
        });
        BiFunction<List, Map, Supplier> schemaMerge = (valuesToMerge, reverseKeywordMap) -> this.mergeSchemas(null, (List<JsonNode>)valuesToMerge, (Map<String, SchemaKeyword>)reverseKeywordMap);
        Stream.of(SchemaKeyword.TAG_ITEMS, SchemaKeyword.TAG_UNEVALUATED_ITEMS, SchemaKeyword.TAG_ADDITIONAL_PROPERTIES, SchemaKeyword.TAG_UNEVALUATED_PROPERTIES).forEach(keyword -> result.put((SchemaKeyword)((Object)keyword), (BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>)schemaMerge));
        result.put(SchemaKeyword.TAG_TYPE, (valuesToMerge, _ignored) -> this.returnOverlapOfStringsOrStringArrays((List<JsonNode>)valuesToMerge));
        BiFunction<List, Map, Supplier> minimumNumeric = (valuesToMerge, _ignored) -> this.returnMinimumNumericValue((List<JsonNode>)valuesToMerge);
        Stream.of(SchemaKeyword.TAG_ITEMS_MAX, SchemaKeyword.TAG_PROPERTIES_MAX, SchemaKeyword.TAG_MAXIMUM, SchemaKeyword.TAG_MAXIMUM_EXCLUSIVE, SchemaKeyword.TAG_LENGTH_MAX).forEach(keyword -> result.put((SchemaKeyword)((Object)keyword), (BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>)minimumNumeric));
        BiFunction<List, Map, Supplier> maximumNumeric = (valuesToMerge, _ignored) -> this.returnMaximumNumericValue((List<JsonNode>)valuesToMerge);
        Stream.of(SchemaKeyword.TAG_ITEMS_MIN, SchemaKeyword.TAG_PROPERTIES_MIN, SchemaKeyword.TAG_MINIMUM, SchemaKeyword.TAG_MINIMUM_EXCLUSIVE, SchemaKeyword.TAG_LENGTH_MIN).forEach(keyword -> result.put((SchemaKeyword)((Object)keyword), (BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>>)maximumNumeric));
        return result;
    }

    public void reduceAllOfNodes(List<ObjectNode> jsonSchemas) {
        String allOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ALLOF);
        Map<String, SchemaKeyword> reverseTagMap = SchemaKeyword.getReverseTagMap(this.config.getSchemaVersion(), _tag -> true);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.mergeAllOfPartsIfPossible((JsonNode)nodeToCheck, allOfTagName, reverseTagMap));
    }

    public void reduceAnyOfNodes(List<ObjectNode> jsonSchemas) {
        String anyOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ANYOF);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.reduceAnyOfWrappersIfPossible((JsonNode)nodeToCheck, anyOfTagName));
    }

    public void reduceRedundantMemberAttributes(List<ObjectNode> jsonSchemas, ObjectNode definitionsNode, String referenceKeyPrefix) {
        HashMap definitions = new HashMap();
        Iterator defIt = definitionsNode.fields();
        while (defIt.hasNext()) {
            Map.Entry definition = (Map.Entry)defIt.next();
            HashMap<String, JsonNode> attributes = new HashMap<String, JsonNode>();
            Iterator attIt = ((JsonNode)definition.getValue()).fields();
            while (attIt.hasNext()) {
                Map.Entry attriibute = (Map.Entry)attIt.next();
                attributes.put((String)attriibute.getKey(), (JsonNode)attriibute.getValue());
            }
            definitions.put(referenceKeyPrefix + (String)definition.getKey(), attributes);
        }
        String propertiesKeyword = this.config.getKeyword(SchemaKeyword.TAG_PROPERTIES);
        String refKeyWord = this.config.getKeyword(SchemaKeyword.TAG_REF);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.reduceRedundantMemberAttributesIfPossible((ObjectNode)nodeToCheck, propertiesKeyword, refKeyWord, definitions));
    }

    public void setStrictTypeInfo(List<ObjectNode> jsonSchemas, boolean considerNullType) {
        String typeTagName = this.config.getKeyword(SchemaKeyword.TAG_TYPE);
        Map<String, SchemaKeyword> reverseTagMap = SchemaKeyword.getReverseTagMap(this.config.getSchemaVersion(), tag -> !tag.getImpliedTypes().isEmpty());
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.addTypeInfoWhereMissing((ObjectNode)nodeToCheck, typeTagName, considerNullType, reverseTagMap));
    }

    private Set<String> getTagNamesSupporting(SchemaKeyword.TagContent contentType) {
        return SchemaKeyword.getReverseTagMap(this.config.getSchemaVersion(), tag -> tag.supportsContentType(contentType)).keySet();
    }

    private void finaliseSchemaParts(List<ObjectNode> schemaNodes, Consumer<ObjectNode> performCleanUpOnSingleSchemaNode) {
        ArrayList<ObjectNode> nextNodesToCheck = new ArrayList<ObjectNode>(schemaNodes);
        Consumer<JsonNode> addNodeToCheck = node -> {
            if (node instanceof ObjectNode) {
                nextNodesToCheck.add((ObjectNode)node);
            }
        };
        Set<String> tagsWithSchemas = this.getTagNamesSupporting(SchemaKeyword.TagContent.SCHEMA);
        Set<String> tagsWithSchemaArrays = this.getTagNamesSupporting(SchemaKeyword.TagContent.ARRAY_OF_SCHEMAS);
        Set<String> tagsWithSchemaObjects = this.getTagNamesSupporting(SchemaKeyword.TagContent.NAMED_SCHEMAS);
        do {
            ArrayList<ObjectNode> currentNodesToCheck = new ArrayList<ObjectNode>(nextNodesToCheck);
            nextNodesToCheck.clear();
            for (ObjectNode nodeToCheck : currentNodesToCheck) {
                performCleanUpOnSingleSchemaNode.accept(nodeToCheck);
                tagsWithSchemas.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).forEach(addNodeToCheck);
                tagsWithSchemaArrays.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(ArrayNode.class::isInstance).forEach(arrayNode -> arrayNode.forEach(addNodeToCheck));
                tagsWithSchemaObjects.stream().map(arg_0 -> ((ObjectNode)nodeToCheck).get(arg_0)).filter(ObjectNode.class::isInstance).forEach(objectNode -> objectNode.forEach(addNodeToCheck));
            }
        } while (!nextNodesToCheck.isEmpty());
    }

    private void mergeAllOfPartsIfPossible(JsonNode schemaNode, String allOfTagName, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        ObjectNode schemaObjectNode = (ObjectNode)schemaNode;
        JsonNode allOfTag = schemaObjectNode.get(allOfTagName);
        if (!(allOfTag instanceof ArrayNode)) {
            return;
        }
        allOfTag.forEach(part -> this.mergeAllOfPartsIfPossible((JsonNode)part, allOfTagName, reverseKeywordMap));
        ArrayList<JsonNode> allParts = new ArrayList<JsonNode>(1 + allOfTag.size());
        allParts.add((JsonNode)schemaObjectNode);
        allOfTag.forEach(allParts::add);
        Supplier<ObjectNode> successfulMergeResultSupplier = this.mergeSchemas(schemaObjectNode, allParts, reverseKeywordMap);
        if (successfulMergeResultSupplier == null) {
            return;
        }
        schemaObjectNode.remove(allOfTagName);
        schemaObjectNode.setAll(successfulMergeResultSupplier.get());
    }

    private Supplier<? extends JsonNode> getAllOfMergeFunctionFor(SchemaKeyword keyword, List<JsonNode> valuesToMerge, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (valuesToMerge.size() == 1) {
            return () -> (JsonNode)valuesToMerge.get(0);
        }
        BiFunction<List<JsonNode>, Map<String, SchemaKeyword>, Supplier<? extends JsonNode>> specificMergeFunction = this.allOfMergeFunctions.get((Object)keyword);
        if (specificMergeFunction == null) {
            return this.returnOneIfAllEqual(valuesToMerge);
        }
        return specificMergeFunction.apply(valuesToMerge, reverseKeywordMap);
    }

    private Supplier<JsonNode> mergeArrays(List<JsonNode> arrayNodesToMerge) {
        if (!arrayNodesToMerge.stream().allMatch(JsonNode::isArray)) {
            return null;
        }
        return () -> {
            ArrayNode mergedArrayNode = this.config.createArrayNode();
            arrayNodesToMerge.forEach(node -> node.forEach(arg_0 -> ((ArrayNode)mergedArrayNode).add(arg_0)));
            return mergedArrayNode;
        };
    }

    private Supplier<JsonNode> mergeObjectProperties(List<JsonNode> objectNodesToMerge) {
        if (!objectNodesToMerge.stream().allMatch(JsonNode::isObject)) {
            return null;
        }
        ObjectNode mergedObjectNode = this.config.createObjectNode();
        for (JsonNode singleObjectNode : objectNodesToMerge) {
            Iterator it = singleObjectNode.fields();
            while (it.hasNext()) {
                Map.Entry singleField = (Map.Entry)it.next();
                if (!mergedObjectNode.has((String)singleField.getKey())) {
                    mergedObjectNode.set((String)singleField.getKey(), (JsonNode)singleField.getValue());
                    continue;
                }
                if (mergedObjectNode.get((String)singleField.getKey()).equals(singleField.getValue())) continue;
                return null;
            }
        }
        return () -> mergedObjectNode;
    }

    private Supplier<JsonNode> mergeDependentRequiredNode(List<JsonNode> dependentRequiredNodesToMerge) {
        LinkedHashMap<String, Set<String>> mergedDependentRequiredNames = new LinkedHashMap<String, Set<String>>();
        for (JsonNode singleNode : dependentRequiredNodesToMerge) {
            if (this.collectDependentRequiredNamesIfMergeAllowed(singleNode, mergedDependentRequiredNames)) continue;
            return null;
        }
        return () -> {
            ObjectNode mergedDependentRequiredNode = this.config.createObjectNode();
            mergedDependentRequiredNames.forEach((leadName, dependentNames) -> dependentNames.forEach(arg_0 -> ((ArrayNode)mergedDependentRequiredNode.withArray(leadName)).add(arg_0)));
            return mergedDependentRequiredNode;
        };
    }

    private boolean collectDependentRequiredNamesIfMergeAllowed(JsonNode objectNode, Map<String, Set<String>> mergedDependentRequiredNames) {
        if (!objectNode.isObject()) {
            return false;
        }
        Iterator it = objectNode.fields();
        while (it.hasNext()) {
            Map.Entry dependentRequiredFieldsOfSingleLead = (Map.Entry)it.next();
            Set<String> propertyNames = this.collectTextItemsFromArrayNode((JsonNode)dependentRequiredFieldsOfSingleLead.getValue());
            if (propertyNames == null) {
                return false;
            }
            mergedDependentRequiredNames.computeIfAbsent((String)dependentRequiredFieldsOfSingleLead.getKey(), leadName -> new LinkedHashSet()).addAll(propertyNames);
        }
        return true;
    }

    private Set<String> collectTextItemsFromArrayNode(JsonNode arrayNode) {
        if (!arrayNode.isArray()) {
            return null;
        }
        LinkedHashSet<String> textItems = new LinkedHashSet<String>();
        for (JsonNode item : arrayNode) {
            if (!item.isTextual()) {
                return null;
            }
            textItems.add(item.asText());
        }
        return textItems;
    }

    private Supplier<ObjectNode> mergeSchemas(ObjectNode mainNodeIncludingAllOf, List<JsonNode> nodes, Map<String, SchemaKeyword> reverseKeywordMap) {
        Map<String, List<JsonNode>> fieldsFromAllParts;
        if (nodes.stream().anyMatch(part -> part.isBoolean() && !part.asBoolean())) {
            return null;
        }
        List<ObjectNode> parts = nodes.stream().filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).collect(Collectors.toList());
        if (this.shouldSkipMergingAllOf(mainNodeIncludingAllOf, parts, fieldsFromAllParts = this.getFieldsFromAllParts(parts))) {
            return null;
        }
        Map unsupportedTagValues = fieldsFromAllParts.entrySet().stream().filter(entry -> !reverseKeywordMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, SchemaCleanUpUtils::throwingMerger, LinkedHashMap::new));
        if (unsupportedTagValues.values().stream().anyMatch(occurrences -> occurrences.size() > 1)) {
            return null;
        }
        Map<SchemaKeyword, Supplier<? extends JsonNode>> supportedTagValueSuppliers = this.collectSupportedTagValueSuppliers(fieldsFromAllParts, reverseKeywordMap, mainNodeIncludingAllOf);
        if (supportedTagValueSuppliers == null) {
            return null;
        }
        return () -> {
            ObjectNode mergedNode = this.config.createObjectNode();
            supportedTagValueSuppliers.forEach((keyword, valueSupplier) -> mergedNode.set(this.config.getKeyword((SchemaKeyword)((Object)((Object)keyword))), (JsonNode)valueSupplier.get()));
            unsupportedTagValues.forEach((tagName, valueList) -> mergedNode.set(tagName, (JsonNode)valueList.get(0)));
            return mergedNode;
        };
    }

    private Map<String, List<JsonNode>> getFieldsFromAllParts(List<ObjectNode> parts) {
        return parts.stream().flatMap(part -> StreamSupport.stream(((Iterable)() -> ((ObjectNode)part).fields()).spliterator(), false)).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private boolean shouldSkipMergingAllOf(ObjectNode mainNode, List<ObjectNode> parts, Map<String, List<JsonNode>> fieldsFromAllParts) {
        if (this.config.getSchemaVersion() != SchemaVersion.DRAFT_6 && this.config.getSchemaVersion() != SchemaVersion.DRAFT_7) {
            return false;
        }
        if (!fieldsFromAllParts.containsKey(this.config.getKeyword(SchemaKeyword.TAG_REF))) {
            return false;
        }
        if (mainNode == null) {
            return parts.size() > 1;
        }
        return mainNode.size() > 1 || parts.size() > 2;
    }

    private Map<SchemaKeyword, Supplier<? extends JsonNode>> collectSupportedTagValueSuppliers(Map<String, List<JsonNode>> fieldsFromAllParts, Map<String, SchemaKeyword> reverseKeywordMap, ObjectNode mainNodeIncludingAllOf) {
        Map supportedTagValues = fieldsFromAllParts.entrySet().stream().filter(entry -> reverseKeywordMap.containsKey(entry.getKey())).collect(Collectors.toMap(entry -> (SchemaKeyword)((Object)((Object)reverseKeywordMap.get(entry.getKey()))), Map.Entry::getValue, SchemaCleanUpUtils::throwingMerger, LinkedHashMap::new));
        if (supportedTagValues.containsKey((Object)SchemaKeyword.TAG_IF)) {
            return null;
        }
        LinkedHashMap<SchemaKeyword, Supplier<? extends JsonNode>> supportedTagValueSuppliers = new LinkedHashMap<SchemaKeyword, Supplier<? extends JsonNode>>();
        for (Map.Entry fieldEntries : supportedTagValues.entrySet()) {
            Supplier<? extends JsonNode> mergeResultSupplier;
            SchemaKeyword keyword = (SchemaKeyword)((Object)fieldEntries.getKey());
            List valuesToMerge = (List)fieldEntries.getValue();
            if (keyword == SchemaKeyword.TAG_ALLOF && mainNodeIncludingAllOf != null) {
                if (valuesToMerge.size() == 1) continue;
                valuesToMerge = valuesToMerge.subList(1, valuesToMerge.size());
            }
            if ((mergeResultSupplier = this.getAllOfMergeFunctionFor(keyword, valuesToMerge, reverseKeywordMap)) == null) {
                return null;
            }
            supportedTagValueSuppliers.put(keyword, mergeResultSupplier);
        }
        return supportedTagValueSuppliers;
    }

    private Supplier<JsonNode> returnOverlapOfStringsOrStringArrays(List<JsonNode> nodes) {
        List<String> encounteredValues = this.getStringValuesFromStringOrStringArray(nodes.get(0));
        if (encounteredValues == null) {
            return null;
        }
        for (JsonNode nextNode : nodes.subList(1, nodes.size())) {
            List<String> nextValues = this.getStringValuesFromStringOrStringArray(nextNode);
            if (nextValues == null) {
                return null;
            }
            encounteredValues.retainAll(nextValues);
            if (!encounteredValues.isEmpty()) continue;
            return null;
        }
        if (encounteredValues.size() == 1) {
            return () -> new TextNode((String)encounteredValues.get(0));
        }
        return () -> {
            ArrayNode arrayNode = this.config.createArrayNode();
            encounteredValues.stream().map(TextNode::new).forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            return arrayNode;
        };
    }

    private List<String> getStringValuesFromStringOrStringArray(JsonNode node) {
        ArrayList<String> result = new ArrayList<String>();
        if (node.isArray()) {
            node.forEach(arrayItem -> result.add(arrayItem.asText(null)));
            if (result.contains(null)) {
                return null;
            }
        } else if (node.isTextual()) {
            result.add(node.asText());
        } else {
            return null;
        }
        return result;
    }

    private Supplier<JsonNode> returnMinimumNumericValue(List<JsonNode> nodes) {
        if (nodes.stream().allMatch(JsonNode::isNumber)) {
            return () -> nodes.stream().reduce((a, b) -> a.asDouble() < b.asDouble() ? a : b).orElse(null);
        }
        return null;
    }

    private Supplier<JsonNode> returnMaximumNumericValue(List<JsonNode> nodes) {
        if (nodes.stream().allMatch(JsonNode::isNumber)) {
            return () -> nodes.stream().reduce((a, b) -> a.asDouble() < b.asDouble() ? b : a).orElse(null);
        }
        return null;
    }

    private Supplier<JsonNode> returnOneIfAllEqual(List<JsonNode> nodes) {
        JsonNode firstNode = nodes.get(0);
        if (nodes.subList(1, nodes.size()).stream().allMatch(arg_0 -> ((JsonNode)firstNode).equals(arg_0))) {
            return () -> firstNode;
        }
        return null;
    }

    private void reduceAnyOfWrappersIfPossible(JsonNode schemaNode, String anyOfTagName) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode anyOfTag = schemaNode.get(anyOfTagName);
        if (!(anyOfTag instanceof ArrayNode)) {
            return;
        }
        anyOfTag.forEach(part -> this.reduceAnyOfWrappersIfPossible((JsonNode)part, anyOfTagName));
        for (int index = anyOfTag.size() - 1; index > -1; --index) {
            JsonNode nestedAnyOf;
            JsonNode arrayEntry = anyOfTag.get(index);
            if (!(arrayEntry instanceof ObjectNode) || arrayEntry.size() != 1 || !((nestedAnyOf = arrayEntry.get(anyOfTagName)) instanceof ArrayNode)) continue;
            ((ArrayNode)anyOfTag).remove(index);
            for (int nestedEntryIndex = nestedAnyOf.size() - 1; nestedEntryIndex > -1; --nestedEntryIndex) {
                ((ArrayNode)anyOfTag).insert(index, nestedAnyOf.get(nestedEntryIndex));
            }
        }
    }

    private void reduceRedundantMemberAttributesIfPossible(ObjectNode schemaNode, String propertiesKeyword, String refKeyword, Map<String, Map<String, JsonNode>> definitions) {
        JsonNode propertiesNode = schemaNode.get(propertiesKeyword);
        if (propertiesNode == null || !propertiesNode.isObject()) {
            return;
        }
        Iterator it = propertiesNode.elements();
        while (it.hasNext()) {
            JsonNode memberSchema = (JsonNode)it.next();
            JsonNode reference = memberSchema.get(refKeyword);
            if (reference == null || !(memberSchema instanceof ObjectNode) || !definitions.containsKey(reference.asText())) continue;
            this.reduceRedundantAttributesIfPossible((ObjectNode)memberSchema, definitions.get(reference.asText()));
        }
    }

    private void reduceRedundantAttributesIfPossible(ObjectNode memberSchema, Map<String, JsonNode> referencedDefinition) {
        boolean shouldSkipConditionals;
        HashSet<String> skippedKeywords = new HashSet<String>();
        String ifKeyword = this.config.getKeyword(SchemaKeyword.TAG_IF);
        String thenKeyword = this.config.getKeyword(SchemaKeyword.TAG_THEN);
        String elseKeyword = this.config.getKeyword(SchemaKeyword.TAG_ELSE);
        boolean bl = shouldSkipConditionals = !Util.nullSafeEquals(memberSchema.get(ifKeyword), referencedDefinition.get(ifKeyword)) || !Util.nullSafeEquals(memberSchema.get(thenKeyword), referencedDefinition.get(thenKeyword)) || !Util.nullSafeEquals(memberSchema.get(elseKeyword), referencedDefinition.get(elseKeyword));
        if (shouldSkipConditionals) {
            skippedKeywords.add(ifKeyword);
            skippedKeywords.add(thenKeyword);
            skippedKeywords.add(elseKeyword);
        }
        Iterator it = memberSchema.fields();
        while (it.hasNext()) {
            Map.Entry memberAttribute = (Map.Entry)it.next();
            String keyword = (String)memberAttribute.getKey();
            if (skippedKeywords.contains(keyword) || !((JsonNode)memberAttribute.getValue()).equals((Object)referencedDefinition.get(keyword))) continue;
            it.remove();
        }
    }

    private void addTypeInfoWhereMissing(ObjectNode schemaNode, String typeTagName, boolean considerNullType, Map<String, SchemaKeyword> reverseTagMap) {
        if (schemaNode.has(typeTagName)) {
            return;
        }
        List<String> impliedTypes = reverseTagMap.entrySet().stream().filter(entry -> schemaNode.has((String)entry.getKey())).flatMap(entry -> ((SchemaKeyword)((Object)((Object)entry.getValue()))).getImpliedTypes().stream()).distinct().sorted().map(SchemaKeyword.SchemaType::getSchemaKeywordValue).collect(Collectors.toList());
        if (impliedTypes.isEmpty()) {
            return;
        }
        if (considerNullType) {
            impliedTypes.add(SchemaKeyword.SchemaType.NULL.getSchemaKeywordValue());
        }
        if (impliedTypes.size() == 1) {
            schemaNode.put(typeTagName, (String)impliedTypes.get(0));
        } else {
            impliedTypes.forEach(arg_0 -> ((ArrayNode)schemaNode.putArray(typeTagName)).add(arg_0));
        }
    }

    public String ensureDefinitionKeyIsUriCompatible(String definitionKey) {
        return definitionKey.replaceAll("\\[\\]", "*").replaceAll("<", "(").replaceAll(">", ")").replaceAll("[^a-zA-Z0-9\\.\\-_\\$\\*\\(\\),]+", "");
    }

    public String ensureDefinitionKeyIsPlain(String definitionKey) {
        return definitionKey.replaceAll("\\$", "-").replaceAll("\\[\\]", "...").replaceAll("[<>]", "_").replaceAll(",", ".").replaceAll("[^a-zA-Z0-9\\.\\-_]+", "");
    }

    private static <T> T throwingMerger(T one, T two) {
        throw new IllegalStateException("Duplicate key " + one);
    }
}

