/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.xml;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.xml.ObsSimpleXMLBuilder;
import com.obs.services.model.trash.BucketTrashConfiguration;

public class BucketTrashConfigurationXMLBuilder
extends ObsSimpleXMLBuilder {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");
    private static final String BUCKET_TRASH_CONFIGURATION = "BucketTrashConfiguration";
    public static final String RESERVED_DAYS = "ReservedDays";

    public String buildXML(BucketTrashConfiguration bucketTrashConfiguration) {
        this.checkBucketPublicAccessBlock(bucketTrashConfiguration);
        this.startElement(BUCKET_TRASH_CONFIGURATION);
        this.startElement(RESERVED_DAYS);
        this.append(bucketTrashConfiguration.getReservedDays());
        this.endElement(RESERVED_DAYS);
        this.endElement(BUCKET_TRASH_CONFIGURATION);
        return this.getXmlBuilder().toString();
    }

    protected void checkBucketPublicAccessBlock(BucketTrashConfiguration bucketTrashConfiguration) {
        if (bucketTrashConfiguration == null) {
            String errorMessage = "bucketTrashConfiguration is null, failed to build request XML!";
            log.error(errorMessage);
            throw new ObsException(errorMessage);
        }
    }
}

