/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.IObsClientAsync;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.internal.task.UploadFileTask;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.UploadFileRequest;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ObsClientAsync
extends ObsClient
implements IObsClientAsync {
    private static final ILogger log = LoggerBuilder.getLogger(ObsClientAsync.class);
    private ExecutorService asyncClientExecutorService;
    private static final int DEFAULT_CLIENT_EXECUTOR_SERVICE_SIZE = 128;
    private int queryInterval = 1000;
    private static final String ASYNC_CLIENT_EXECUTOR_SERVICE_THREAD_NAME = "async-client-thread";

    public ObsClientAsync(String endPoint) {
        super(endPoint);
    }

    public ObsClientAsync(ObsConfiguration config) {
        super(config);
    }

    public ObsClientAsync(String accessKey, String secretKey, String endPoint) {
        super(accessKey, secretKey, endPoint);
    }

    public ObsClientAsync(String accessKey, String secretKey, ObsConfiguration config) {
        super(accessKey, secretKey, config);
    }

    public ObsClientAsync(String accessKey, String secretKey, String securityToken, String endPoint) {
        super(accessKey, secretKey, securityToken, endPoint);
    }

    public ObsClientAsync(String accessKey, String secretKey, String securityToken, ObsConfiguration config) {
        super(accessKey, secretKey, securityToken, config);
    }

    public ObsClientAsync(IObsCredentialsProvider provider, String endPoint) {
        super(provider, endPoint);
    }

    public ObsClientAsync(IObsCredentialsProvider provider, ObsConfiguration config) {
        super(provider, config);
    }

    @Override
    public void close() throws IOException {
        log.warn("ObsClientAsync closing");
        try {
            this.getExecutorService().shutdown();
            log.warn("ObsClientAsync closed");
        }
        catch (Exception e) {
            log.warn("ObsClientAsync close failed, detail:", e);
        }
        super.close();
    }

    protected ExecutorService getExecutorService() {
        if (this.asyncClientExecutorService == null) {
            this.asyncClientExecutorService = Executors.newFixedThreadPool(128, r -> new Thread(r, ASYNC_CLIENT_EXECUTOR_SERVICE_THREAD_NAME));
        }
        return this.asyncClientExecutorService;
    }

    public void setExecutorService(ExecutorService service) {
        if (this.asyncClientExecutorService != null) {
            this.asyncClientExecutorService.shutdown();
            while (!this.asyncClientExecutorService.isTerminated()) {
                try {
                    Thread.sleep(this.queryInterval);
                }
                catch (InterruptedException e) {
                    log.warn("ObsClientAsync setExecutorService failed, detail:", e);
                }
            }
        }
        this.asyncClientExecutorService = service;
    }

    public int getQueryInterval() {
        return this.queryInterval;
    }

    public void setQueryInterval(int queryInterval) {
        this.queryInterval = queryInterval;
    }

    @Override
    public UploadFileTask uploadFileAsync(UploadFileRequest uploadFileRequest, TaskCallback<CompleteMultipartUploadResult, UploadFileRequest> completeCallback) {
        log.debug("start uploadFileAsync");
        if (uploadFileRequest.getCancelHandler() != null) {
            uploadFileRequest.getCancelHandler().resetCancelStatus();
        }
        UploadFileTask uploadFileTask = new UploadFileTask(this, uploadFileRequest.getBucketName(), uploadFileRequest, completeCallback);
        Future future = this.getExecutorService().submit(uploadFileTask);
        uploadFileTask.setResultFuture(future);
        return uploadFileTask;
    }
}

