/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.xml;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.xml.ObsSimpleXMLBuilder;
import com.obs.services.model.CustomDomainCertificateConfig;

public class CustomDomainCertificateConfigXMLBuilder
extends ObsSimpleXMLBuilder {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    public String buildXML(CustomDomainCertificateConfig customDomainCertificateConfig) {
        this.checkCustomDomainCertificateConfig(customDomainCertificateConfig);
        this.startElement("CustomDomainConfiguration");
        this.startElement("Name");
        this.append(customDomainCertificateConfig.getName());
        this.endElement("Name");
        if (customDomainCertificateConfig.hasCertificateId()) {
            this.startElement("CertificateId");
            this.append(customDomainCertificateConfig.getCertificateId());
            this.endElement("CertificateId");
        }
        this.startElement("Certificate");
        this.append(customDomainCertificateConfig.getCertificate());
        this.endElement("Certificate");
        if (customDomainCertificateConfig.hasCertificateChain()) {
            this.startElement("CertificateChain");
            this.append(customDomainCertificateConfig.getCertificateChain());
            this.endElement("CertificateChain");
        }
        this.startElement("PrivateKey");
        this.append(customDomainCertificateConfig.getPrivateKey());
        this.endElement("PrivateKey");
        this.endElement("CustomDomainConfiguration");
        return this.getXmlBuilder().toString();
    }

    private void checkCustomDomainCertificateConfig(CustomDomainCertificateConfig customDomainCertificateConfig) {
        if (customDomainCertificateConfig == null) {
            String errorMessage = "CustomDomainConfiguration is null, failed to build request XML!";
            log.error(errorMessage);
            throw new ObsException(errorMessage);
        }
    }
}

