/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.model.ProgressListener;
import java.util.ArrayList;
import java.util.List;

public abstract class ProgressManager {
    private boolean endFlag = true;
    protected final long totalBytes;
    protected long startCheckpoint;
    protected long lastCheckpoint;
    protected final long intervalBytes;
    protected final ProgressListener progressListener;
    protected volatile List<BytesUnit> lastInstantaneousBytes = new ArrayList<BytesUnit>();

    public ProgressManager(long totalBytes, ProgressListener progressListener, long intervalBytes) {
        long now;
        this.totalBytes = totalBytes;
        this.progressListener = progressListener;
        this.startCheckpoint = now = System.currentTimeMillis();
        this.lastCheckpoint = now;
        this.intervalBytes = intervalBytes;
    }

    public void progressStart() {
        long now;
        this.startCheckpoint = now = System.currentTimeMillis();
        this.lastCheckpoint = now;
    }

    public final void progressChanged(int bytes) {
        if (this.progressListener == null || bytes <= 0) {
            return;
        }
        this.doProgressChanged(bytes);
    }

    @Deprecated
    protected List<BytesUnit> createCurrentInstantaneousBytes(long bytes, long now) {
        ArrayList<BytesUnit> currentInstantaneousBytes = new ArrayList<BytesUnit>();
        List<BytesUnit> temp = this.lastInstantaneousBytes;
        if (temp != null) {
            for (BytesUnit item : temp) {
                if (now - item.dateTime >= 1000L) continue;
                currentInstantaneousBytes.add(item);
            }
        }
        currentInstantaneousBytes.add(new BytesUnit(now, bytes));
        return currentInstantaneousBytes;
    }

    public abstract void progressEnd();

    protected abstract void doProgressChanged(int var1);

    public boolean isEndFlag() {
        return this.endFlag;
    }

    public void setEndFlag(boolean endFlag) {
        this.endFlag = endFlag;
    }

    static class BytesUnit {
        long dateTime;
        long bytes;

        BytesUnit(long dateTime, long bytes) {
            this.dateTime = dateTime;
            this.bytes = bytes;
        }
    }
}

