/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.xml;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.xml.ObsSimpleXMLBuilder;
import com.obs.services.model.bpa.BucketPublicAccessBlock;

public class BucketPublicAccessBlockXMLBuilder
extends ObsSimpleXMLBuilder {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    public String buildXML(BucketPublicAccessBlock bucketPublicAccessBlock) throws ObsException {
        this.checkBucketPublicAccessBlock(bucketPublicAccessBlock);
        this.startElement("PublicAccessBlockConfiguration");
        if (bucketPublicAccessBlock.getBlockPublicACLs() != null) {
            this.startElement("BlockPublicAcls");
            this.append(bucketPublicAccessBlock.getBlockPublicACLs() != false ? "true" : "false");
            this.endElement("BlockPublicAcls");
        }
        if (bucketPublicAccessBlock.getIgnorePublicACLs() != null) {
            this.startElement("IgnorePublicAcls");
            this.append(bucketPublicAccessBlock.getIgnorePublicACLs() != false ? "true" : "false");
            this.endElement("IgnorePublicAcls");
        }
        if (bucketPublicAccessBlock.getBlockPublicPolicy() != null) {
            this.startElement("BlockPublicPolicy");
            this.append(bucketPublicAccessBlock.getBlockPublicPolicy() != false ? "true" : "false");
            this.endElement("BlockPublicPolicy");
        }
        if (bucketPublicAccessBlock.getRestrictPublicBuckets() != null) {
            this.startElement("RestrictPublicBuckets");
            this.append(bucketPublicAccessBlock.getRestrictPublicBuckets() != false ? "true" : "false");
            this.endElement("RestrictPublicBuckets");
        }
        this.endElement("PublicAccessBlockConfiguration");
        return this.getXmlBuilder().toString();
    }

    protected void checkBucketPublicAccessBlock(BucketPublicAccessBlock bucketPublicAccessBlock) {
        if (bucketPublicAccessBlock == null) {
            String errorMessage = "bucketPublicAccessBlock is null, failed to build request XML!";
            log.error(errorMessage);
            throw new ObsException(errorMessage);
        }
        if (bucketPublicAccessBlock.getBlockPublicPolicy() == null && bucketPublicAccessBlock.getBlockPublicACLs() == null && bucketPublicAccessBlock.getRestrictPublicBuckets() == null && bucketPublicAccessBlock.getIgnorePublicACLs() == null) {
            String errorMessage = "bucketPublicAccessBlock's members are all null(BlockPublicPolicy, BlockPublicACLs, RestrictPublicBuckets, IgnorePublicACLs), failed to build request XML!";
            log.error(errorMessage);
            throw new ObsException(errorMessage);
        }
    }
}

