/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.xml;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.xml.ObsSimpleXMLBuilder;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.PartEtag;
import java.util.List;

public class CompleteMultipartUploadXMLBuilder
extends ObsSimpleXMLBuilder {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    public static void sortPartETags(List<PartEtag> partEtagList) {
        if (partEtagList == null) {
            log.error("partEtagList is null! sort canceled.");
            return;
        }
        partEtagList.sort((o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getPartNumber().compareTo(o2.getPartNumber());
        });
    }

    public String buildXML(CompleteMultipartUploadRequest request) {
        CompleteMultipartUploadXMLBuilder.sortPartETags(request.getPartEtag());
        this.startElement("CompleteMultipartUpload");
        if (request.getPartEtag() == null) {
            log.error("CompleteMultipartUploadRequest.getPartEtag() is null.");
        } else if (request.getPartEtag().isEmpty()) {
            log.error("CompleteMultipartUploadRequest.getPartEtag() isEmpty.");
        } else {
            for (int i = 0; i < request.getPartEtag().size(); ++i) {
                PartEtag etag = request.getPartEtag().get(i);
                if (etag == null) {
                    log.error("CompleteMultipartUploadRequest.getPartEtag().get(" + i + ") is null when buildXML for CompleteMultipartUpload!");
                    continue;
                }
                this.startElement("Part");
                this.startElement("PartNumber");
                Integer partNumber = etag.getPartNumber();
                this.append(partNumber == null ? "" : partNumber.toString());
                this.endElement("PartNumber");
                this.startElement("ETag");
                this.append(ServiceUtils.toValid(etag.getEtag()));
                this.endElement("ETag");
                this.endElement("Part");
            }
        }
        this.endElement("CompleteMultipartUpload");
        return this.getXmlBuilder().toString();
    }
}

