/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import java.util.Objects;

public class CustomDomainCertificateConfig {
    private String name;
    private String certificateId;
    private String certificate;
    private String certificateChain;
    private String privateKey;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCertificateId() {
        return this.certificateId;
    }

    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCertificateChain() {
        return this.certificateChain;
    }

    public void setCertificateChain(String certificateChain) {
        this.certificateChain = certificateChain;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public boolean hasCertificateChain() {
        return ServiceUtils.isValid(this.certificateChain);
    }

    public boolean hasCertificateId() {
        return ServiceUtils.isValid(this.certificateId);
    }

    public static void checkCertificateConfig(CustomDomainCertificateConfig config) throws IllegalArgumentException {
        if (Objects.nonNull(config)) {
            ServiceUtils.assertParameterNotNull(config.getName(), "Certificate name cannot be null");
            ServiceUtils.assertParameterNotNull(config.getCertificate(), "Certificate cannot be null");
            ServiceUtils.assertParameterNotNull(config.getPrivateKey(), "Private key cannot be null");
            ServiceUtils.checkParameterLength("Name", config.getName(), 3, 63);
            if (Objects.nonNull(config.getCertificateId())) {
                ServiceUtils.checkParameterLength("CertificateId", config.getCertificateId(), 16, 16);
            }
            ServiceUtils.checkParameterSize("Certificate", ServiceUtils.getSizeInKB(config.getCertificate()), 40L);
            if (Objects.nonNull(config.getCertificateChain())) {
                ServiceUtils.checkParameterSize("CertificateChain", ServiceUtils.getSizeInKB(config.getCertificateChain()), 40L);
            }
            ServiceUtils.checkParameterSize("PrivateKey", ServiceUtils.getSizeInKB(config.getPrivateKey()), 40L);
        }
    }
}

