/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.Callback;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.PutObjectBasicRequest;
import java.io.File;
import java.io.InputStream;

public class PutObjectRequest
extends PutObjectBasicRequest {
    protected File file;
    protected InputStream input;
    protected ObjectMetadata metadata;
    protected int expires = -1;
    protected long offset;
    private boolean autoClose = true;
    private ProgressListener progressListener;
    private long progressInterval = 102400L;
    private Callback callback;
    private boolean needCalculateCRC64 = false;

    public PutObjectRequest() {
    }

    public PutObjectRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public PutObjectRequest(PutObjectBasicRequest request) {
        if (request != null) {
            this.bucketName = request.getBucketName();
            this.objectKey = request.getObjectKey();
            this.acl = request.getAcl();
            this.extensionPermissionMap = request.getExtensionPermissionMap();
            this.sseCHeader = request.getSseCHeader();
            this.sseKmsHeader = request.getSseKmsHeader();
            this.successRedirectLocation = request.getSuccessRedirectLocation();
            this.setRequesterPays(request.isRequesterPays());
        }
    }

    public PutObjectRequest(String bucketName, String objectKey) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
    }

    public PutObjectRequest(String bucketName, String objectKey, File file) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.file = file;
    }

    public PutObjectRequest(String bucketName, String objectKey, InputStream input) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.input = input;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
        this.file = null;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMetadata metadata) {
        this.metadata = metadata;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.input = null;
    }

    public int getExpires() {
        return this.expires;
    }

    public void setExpires(int expires) {
        this.expires = expires;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public long getProgressInterval() {
        return this.progressInterval;
    }

    public void setProgressInterval(long progressInterval) {
        this.progressInterval = progressInterval;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public boolean isNeedCalculateCRC64() {
        return this.needCalculateCRC64;
    }

    public void setNeedCalculateCRC64(boolean needCalculateCRC64) {
        this.needCalculateCRC64 = needCalculateCRC64;
    }

    @Override
    public String toString() {
        return "PutObjectRequest [file=" + this.file + ", input=" + this.input + ", metadata=" + this.metadata + ", isEncodeHeaders=" + this.encodeHeaders + ", expires=" + this.expires + ", offset=" + this.offset + ", autoClose=" + this.autoClose + ", progressListener=" + this.progressListener + ", progressInterval=" + this.progressInterval + ", getBucketName()=" + this.getBucketName() + ", getObjectKey()=" + this.getObjectKey() + ", getSseKmsHeader()=" + this.getSseKmsHeader() + ", getSseCHeader()=" + this.getSseCHeader() + ", getAcl()=" + this.getAcl() + ", getSuccessRedirectLocation()=" + this.getSuccessRedirectLocation() + ", getAllGrantPermissions()=" + this.getAllGrantPermissions() + ", getExtensionPermissionMap()=" + this.getExtensionPermissionMap() + ", isRequesterPays()=" + this.isRequesterPays() + "]";
    }
}

