/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.datasource;

import com.mybatisflex.annotation.UseDataSource;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodClassKey;

public class DataSourceInterceptor
implements MethodInterceptor {
    private final Map<Object, String> dsCache = new ConcurrentHashMap<Object, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String dsKey = DataSourceKey.getByManual();
        if (StringUtil.isNotBlank((String)dsKey)) {
            return invocation.proceed();
        }
        dsKey = this.findDataSourceKey(invocation.getMethod(), invocation.getThis().getClass());
        if (StringUtil.isBlank((String)dsKey)) {
            return invocation.proceed();
        }
        String suspendKey = DataSourceKey.getByAnnotation();
        try {
            DataSourceKey.useWithAnnotation((String)dsKey);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (suspendKey != null) {
                DataSourceKey.useWithAnnotation((String)suspendKey);
            } else {
                DataSourceKey.clear();
            }
        }
    }

    private String findDataSourceKey(Method method, Class<?> targetClass) {
        MethodClassKey cacheKey = new MethodClassKey(method, targetClass);
        String dsKey = this.dsCache.get(cacheKey);
        if (dsKey == null) {
            dsKey = this.determineDataSourceKey(method, targetClass);
            this.dsCache.put(cacheKey, dsKey);
        }
        return dsKey;
    }

    private String determineDataSourceKey(Method method, Class<?> targetClass) {
        Class<?>[] interfaces;
        UseDataSource annotation = method.getAnnotation(UseDataSource.class);
        if (annotation != null) {
            return annotation.value();
        }
        annotation = targetClass.getAnnotation(UseDataSource.class);
        if (annotation != null) {
            return annotation.value();
        }
        for (Class<?> anInterface : interfaces = targetClass.getInterfaces()) {
            annotation = anInterface.getAnnotation(UseDataSource.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return "";
    }
}

