/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.autoconf;

import com.taobao.pandora.boot.autoconf.AutoConfigure;
import com.taobao.pandora.boot.autoconf.UrlTransformer;
import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.utils.FileUtils;
import com.taobao.pandora.boot.utils.UrlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class JarUrlTransformer
implements UrlTransformer {
    private File tempDir;
    private List<String> whiteList;

    public JarUrlTransformer(File tempDir) {
        this.tempDir = tempDir;
        String javaHome = System.getProperty("java.home");
        String jreSuffix = File.separator + "jre";
        if (javaHome.endsWith(jreSuffix)) {
            javaHome = javaHome.substring(0, javaHome.length() - jreSuffix.length());
        }
        this.whiteList = new ArrayList<String>();
        this.whiteList.add(javaHome);
        this.whiteList.add("tomcat-embed-");
        this.whiteList.add("servlet-api");
        this.whiteList.add("pandora");
    }

    @Override
    public URL map(URL url) {
        if (!this.filter(url)) {
            return url;
        }
        try {
            File srcFile = UrlUtils.toFile(url);
            File destFile = new File(this.tempDir, srcFile.getName());
            destFile.createNewFile();
            if (this.containsClassPathInManifest(url)) {
                this.updateManifestClassPath(srcFile, destFile);
            } else {
                FileUtils.copyFile(srcFile, destFile);
            }
            destFile.deleteOnExit();
            return destFile.toURI().toURL();
        }
        catch (Exception e) {
            AnsiLog.error((String)("fail to map url: " + url));
            e.printStackTrace();
            return url;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean filter(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsClassPathInManifest(URL url) {
        JarFile jarFile;
        block6: {
            boolean bl;
            block5: {
                jarFile = null;
                File file = UrlUtils.toFile(url);
                if (file != null && file.exists()) break block5;
                boolean bl2 = false;
                FileUtils.silentClose(jarFile);
                return bl2;
            }
            try {
                Attributes attributes;
                jarFile = new JarFile(UrlUtils.toFile(url));
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || (attributes = manifest.getMainAttributes()) == null || attributes.getValue("Class-Path") == null) break block6;
                bl = true;
            }
            catch (IOException e) {
                try {
                    AnsiLog.error((String)("[AutoConfig] process jar error! try to delete it and recompile, url: " + url));
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtils.silentClose(jarFile);
                    throw throwable;
                }
                FileUtils.silentClose(jarFile);
            }
            FileUtils.silentClose(jarFile);
            return bl;
        }
        FileUtils.silentClose(jarFile);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateManifestClassPath(File src, File dest) {
        JarFile jarFile = null;
        ZipOutputStream zos = null;
        try {
            jarFile = new JarFile(src);
            zos = new ZipOutputStream(new FileOutputStream(dest));
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entryIn = e.nextElement();
                if (!entryIn.getName().equals("META-INF/MANIFEST.MF")) {
                    int len;
                    zos.putNextEntry(entryIn);
                    InputStream is = jarFile.getInputStream(entryIn);
                    byte[] buf = new byte[0x100000];
                    while ((len = is.read(buf)) > 0) {
                        zos.write(buf, 0, len);
                    }
                } else {
                    Manifest manifest = jarFile.getManifest();
                    Attributes attributes = manifest.getMainAttributes();
                    ArrayList<URL> urlList = new ArrayList<URL>();
                    String classPathStr = attributes.getValue("Class-Path");
                    String[] split = classPathStr.split("\\s+");
                    if (split != null) {
                        for (String urlStr : split) {
                            if (!urlStr.startsWith("file:") && !urlStr.startsWith("jar:")) {
                                urlList.add(new File(urlStr).toURI().toURL());
                                continue;
                            }
                            urlList.add(new URL(urlStr));
                        }
                    }
                    if (!urlList.isEmpty()) {
                        AutoConfigure autoConfigure = new AutoConfigure();
                        URL[] urlsAfterAutoConfig = autoConfigure.config(urlList.toArray(new URL[0]));
                        StringBuilder newClassPath = new StringBuilder();
                        for (URL url : urlsAfterAutoConfig) {
                            newClassPath.append(url.toString()).append(' ');
                        }
                        attributes.putValue("Class-Path", newClassPath.toString());
                    }
                    zos.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                    manifest.write(zos);
                }
                zos.closeEntry();
            }
            zos.close();
        }
        catch (IOException e) {
            try {
                AnsiLog.error((String)("[AutoConfig] process jar error! try to delete it and recompile, file: " + src));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.silentClose(jarFile);
                FileUtils.silentClose(zos);
                throw throwable;
            }
            FileUtils.silentClose(jarFile);
            FileUtils.silentClose(zos);
        }
        FileUtils.silentClose(jarFile);
        FileUtils.silentClose(zos);
    }
}

