/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader.tools;

import com.taobao.pandora.boot.loader.tools.Layout;
import com.taobao.pandora.boot.loader.tools.LibraryScope;
import com.taobao.pandora.boot.loader.tools.RepackagingLayout;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Layouts {
    private Layouts() {
    }

    public static Layout forFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (file.getName().toLowerCase().endsWith(".jar")) {
            return new Jar();
        }
        if (file.getName().toLowerCase().endsWith(".war")) {
            return new War();
        }
        if (file.isDirectory() || file.getName().toLowerCase().endsWith(".zip")) {
            return new Expanded();
        }
        throw new IllegalStateException("Unable to deduce layout for '" + file + "'");
    }

    @Deprecated
    public static class Module
    implements Layout {
        private static final Set<LibraryScope> LIB_DESTINATION_SCOPES = new HashSet<LibraryScope>(Arrays.asList(LibraryScope.COMPILE, LibraryScope.RUNTIME, LibraryScope.CUSTOM));

        @Override
        public String getLauncherClassName() {
            return null;
        }

        @Override
        public String getLibraryDestination(String libraryName, LibraryScope scope) {
            if (LIB_DESTINATION_SCOPES.contains(scope)) {
                return "lib/";
            }
            return null;
        }

        @Override
        public String getClassesLocation() {
            return "";
        }

        @Override
        public boolean isExecutable() {
            return false;
        }
    }

    public static class War
    implements Layout {
        private static final Map<LibraryScope, String> SCOPE_DESTINATIONS;

        @Override
        public String getLauncherClassName() {
            return "com.taobao.pandora.boot.loader.WarLauncher";
        }

        @Override
        public String getLibraryDestination(String libraryName, LibraryScope scope) {
            return SCOPE_DESTINATIONS.get(scope);
        }

        @Override
        public String getClassesLocation() {
            return "WEB-INF/classes/";
        }

        @Override
        public boolean isExecutable() {
            return true;
        }

        static {
            HashMap<LibraryScope, String> map = new HashMap<LibraryScope, String>();
            map.put(LibraryScope.COMPILE, "WEB-INF/lib/");
            map.put(LibraryScope.CUSTOM, "WEB-INF/lib/");
            map.put(LibraryScope.RUNTIME, "WEB-INF/lib/");
            map.put(LibraryScope.PROVIDED, "WEB-INF/lib-provided/");
            SCOPE_DESTINATIONS = Collections.unmodifiableMap(map);
        }
    }

    public static class None
    extends Jar {
        @Override
        public String getLauncherClassName() {
            return null;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }
    }

    public static class Expanded
    extends Jar {
        @Override
        public String getLauncherClassName() {
            return "com.taobao.pandora.boot.loader.PropertiesLauncher";
        }
    }

    public static class Jar
    implements RepackagingLayout {
        @Override
        public String getLauncherClassName() {
            return "com.taobao.pandora.boot.loader.SarLauncher";
        }

        @Override
        public String getLibraryDestination(String libraryName, LibraryScope scope) {
            return "BOOT-INF/lib/";
        }

        @Override
        public String getClassesLocation() {
            return "";
        }

        @Override
        public String getRepackagedClassesLocation() {
            return "BOOT-INF/classes/";
        }

        @Override
        public boolean isExecutable() {
            return true;
        }
    }
}

