/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.maven.sar;

import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.loader.util.StringUtils;
import com.taobao.pandora.boot.maven.Exclude;
import com.taobao.pandora.boot.maven.ExcludeFilter;
import com.taobao.pandora.boot.maven.Include;
import com.taobao.pandora.boot.maven.RepackageMojo;
import com.taobao.pandora.boot.maven.sar.PandoraPluginArtifactsFilter;
import com.taobao.pandora.boot.maven.sar.PandoraWebHelper;
import com.taobao.pandora.boot.maven.sar.ScmSar;
import com.taobao.pandora.loader.archive.Archive;
import com.taobao.pandora.loader.util.ArchiveUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

public class PandoraMavenHelper {
    public static void checkSarVersion(Set<Artifact> artifacts, boolean allowExpiredSar, Log log) throws MojoExecutionException {
        String msg;
        String sarVersion = PandoraMavenHelper.findSarVersion(artifacts);
        if (StringUtils.isEmpty((String)sarVersion)) {
            return;
        }
        ScmSar scmSar = PandoraWebHelper.querySarInfo(sarVersion);
        if (scmSar == null || scmSar.getIsExpired() == null) {
            log.warn((CharSequence)("Can not query sar info from pandora-web server! sarVersion: " + sarVersion));
            return;
        }
        if (scmSar.getIsExpired().booleanValue()) {
            msg = "SAR " + sarVersion + ", please upgrade it. IS OUT OF DATE, visit http://gitlab.alibaba-inc.com/middleware-container/pandora-boot/wikis/changelog to find the recommended version.";
            log.warn((CharSequence)msg);
            AnsiLog.error((String)msg);
        }
        if (PandoraMavenHelper.apartExpiredDays(scmSar, log) < 15) {
            msg = "SAR " + sarVersion + " will be expired at " + scmSar.getGmtExpired() + ", please upgrade it. visit http://gitlab.alibaba-inc.com/middleware-container/pandora-boot/wikis/changelog to find the recommended version.";
            log.warn((CharSequence)msg);
            AnsiLog.error((String)msg);
        }
    }

    public static void checkPluginOutOfDate(RepackageMojo mojo, Set<Artifact> artifacts) {
        String pluginVersion = PandoraMavenHelper.findPandoraBootPluginVersion(mojo);
        String loaderVersion = PandoraMavenHelper.findPandoraBootLoaderVersion(artifacts);
        if (pluginVersion == null || loaderVersion == null) {
            return;
        }
        if (new DefaultArtifactVersion(pluginVersion).compareTo((ArtifactVersion)new DefaultArtifactVersion(loaderVersion)) < 0) {
            String messageTemplate = "pandora-boot-maven-plugin version: %s, pandora-boot-loader version: %s. Their version numbers do not match. Please check pom.xml to make sure pandora-boot-loader and pandora-boot-maven-plugin have the same version numbers";
            String msg = String.format(messageTemplate, pluginVersion, loaderVersion);
            AnsiLog.error((String)msg);
            throw new IllegalStateException(msg);
        }
    }

    public static List<ArtifactsFilter> sarExcludeFilter(MavenProject project, List<Include> plugins) {
        ArrayList<ArtifactsFilter> filters = new ArrayList<ArtifactsFilter>();
        filters.addAll(PandoraMavenHelper.pluginExcludeFilter(project, plugins));
        filters.add((ArtifactsFilter)PandoraMavenHelper.generateExcludeFilter("com.taobao.pandora", "taobao-hsf.sar-container"));
        filters.add((ArtifactsFilter)PandoraMavenHelper.generateExcludeFilter("com.taobao.pandora", "taobao-hsf.sar"));
        filters.add((ArtifactsFilter)PandoraMavenHelper.generateExcludeFilter("com.taobao.pandora", "taobao-hsf.sar-all"));
        return filters;
    }

    private static ExcludeFilter generateExcludeFilter(String groupId, String artifactId) {
        Exclude exclude = new Exclude();
        exclude.setGroupId(groupId);
        exclude.setArtifactId(artifactId);
        return new ExcludeFilter(exclude);
    }

    private static boolean shouldInclude(Artifact artifact, List<Include> plugins) {
        boolean found = false;
        for (Include include : plugins) {
            if (!include.getArtifactId().equals(artifact.getArtifactId()) || !include.getGroupId().equals(artifact.getGroupId())) continue;
            found = true;
            break;
        }
        return found;
    }

    private static List<ArtifactsFilter> pluginExcludeFilter(MavenProject project, List<Include> plugins) {
        ArrayList<ArtifactsFilter> filters = new ArrayList<ArtifactsFilter>();
        Set artifacts = project.getArtifacts();
        if (plugins != null) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getGroupId().equals("com.taobao.pandora.plugin") || PandoraMavenHelper.shouldInclude(artifact, plugins) || !PandoraMavenHelper.isPandoraPluginJar(artifact)) continue;
                filters.add((ArtifactsFilter)PandoraMavenHelper.generateExcludeFilter(artifact.getGroupId(), artifact.getArtifactId()));
            }
        } else {
            filters.add(new PandoraPluginArtifactsFilter());
        }
        return filters;
    }

    public static boolean isPandoraPluginJar(Artifact artifact) {
        File file;
        if (artifact.getGroupId().equals("com.taobao.pandora.plugin") && (file = artifact.getFile()) != null) {
            try {
                Archive archive = ArchiveUtils.createArchiveFromUrl((URL)file.toURI().toURL());
                if (archive.getResource("com/taobao/pandora/plugin.guide.properties") != null) {
                    return true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static int apartExpiredDays(ScmSar scmSar, Log log) {
        String gmtExpired = scmSar.getGmtExpired();
        if (StringUtils.isEmpty((String)gmtExpired)) {
            log.warn((CharSequence)("Can not get gmtExpired of sar! sar:" + scmSar));
            return Integer.MAX_VALUE;
        }
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date expired = dateFormatter.parse(gmtExpired);
            Date now = new Date();
            return (int)((expired.getTime() - now.getTime()) / 86400000L);
        }
        catch (ParseException e) {
            log.warn((CharSequence)("Can not parse expired string of sar! sar:" + scmSar), (Throwable)e);
            return Integer.MAX_VALUE;
        }
    }

    private static String findSarVersion(Set<Artifact> artifacts) {
        String version = "";
        for (Artifact artifact : artifacts) {
            if (artifact.getArtifactId().equals("taobao-hsf.sar")) {
                return artifact.getVersion();
            }
            if (!artifact.getArtifactId().startsWith("taobao-hsf.sar")) continue;
            version = artifact.getVersion();
        }
        return version;
    }

    private static String findPandoraBootLoaderVersion(Set<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!"com.taobao.pandora".equals(artifact.getGroupId()) || !"pandora-boot-loader".equals(artifact.getArtifactId())) continue;
            return artifact.getBaseVersion();
        }
        return null;
    }

    private static String findPandoraBootPluginVersion(RepackageMojo mojo) {
        Map map = mojo.getPluginContext();
        if (map == null) {
            return null;
        }
        PluginDescriptor pluginDescriptor = (PluginDescriptor)map.get("pluginDescriptor");
        if (pluginDescriptor == null) {
            return null;
        }
        return pluginDescriptor.getVersion();
    }
}

