/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot;

import com.taobao.pandora.boot.PandoraBootVersion;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class PandoraBootBanner {
    private static final String PANDORA_BOOT = " :: Pandora Boot :: ";
    private static final String LINE_SEPARATOR = String.format("%n", new Object[0]);
    private static String banner = null;

    public static void printBanner(PrintStream printStream) {
        printStream.println(PandoraBootBanner.getBanner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBanner() {
        if (banner != null) {
            return banner;
        }
        String logo = null;
        InputStream inputStream = null;
        BufferedInputStream bis = null;
        try {
            inputStream = PandoraBootBanner.class.getClassLoader().getResourceAsStream("META-INF/pandoraboot/banner.txt");
            if (inputStream != null) {
                bis = new BufferedInputStream(inputStream);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                int result = bis.read();
                while (result != -1) {
                    buf.write((byte)result);
                    result = bis.read();
                }
                logo = buf.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
        StringBuilder sb = new StringBuilder(512);
        if (logo != null) {
            sb.append(logo).append(LINE_SEPARATOR);
        }
        sb.append(PANDORA_BOOT);
        String version = PandoraBootVersion.getVersion();
        if (version != null) {
            sb.append(version);
        }
        sb.append(LINE_SEPARATOR);
        banner = sb.toString();
        return banner;
    }
}

