/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.rpc;

import com.weibo.api.motan.codec.AbstractCodec;
import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.rpc.DefaultRpcCodec;
import com.weibo.api.motan.protocol.rpc.RpcProtocolVersion;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.support.DefaultRpcHeartbeatFactory;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanDigestUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import com.weibo.api.motan.util.ReflectUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

@Deprecated
@SpiMeta(name="compressMotan")
public class CompressRpcCodec
extends AbstractCodec {
    private static final short MAGIC = -3856;
    private static final byte MASK = 7;
    private static ConcurrentHashMap<String, MethodInfo> SIGN_METHOD_MAP = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> METHOD_SIGN_MAP = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AttachmentInfo> SIGN_ATTACHMENT_MAP = new ConcurrentHashMap();
    private static ConcurrentHashSet<String> ACCEPT_ATTACHMENT_SIGN = new ConcurrentHashSet();
    private static final String SIGN_FLAG = "1";
    private static final String ATTACHMENT_SIGN = "_A";
    private static final String UN_ATTACHMENT_SIGN = "_UA";
    private static final String CLIENT_REQUESTID = "_RID";
    public static final String CODEC_VERSION_SWITCHER = "feature.motanrpc.codecversion.degrade";
    public static final String GROUP_CODEC_VERSION_SWITCHER = "feature.motanrpc.codecversion.groupdegrade.";
    private DefaultRpcCodec v1Codec = new DefaultRpcCodec();

    @Override
    public byte[] encode(Channel channel, Object message) throws IOException {
        if (this.needEncodeV1(message)) {
            return this.v1Codec.encode(channel, message);
        }
        return this.encodeV2(channel, message);
    }

    private boolean needEncodeV1(Object message) {
        if (MotanSwitcherUtil.isOpen(CODEC_VERSION_SWITCHER)) {
            return true;
        }
        if (message instanceof Request) {
            if (DefaultRpcHeartbeatFactory.isHeartbeatRequest(message)) {
                return true;
            }
            String group = MotanFrameworkUtil.getGroupFromRequest((Request)message);
            if (MotanSwitcherUtil.switcherIsOpenWithDefault(GROUP_CODEC_VERSION_SWITCHER + group, false)) {
                return true;
            }
        }
        return message instanceof Response && ((Response)message).getRpcProtocolVersion() == RpcProtocolVersion.VERSION_1.getVersion();
    }

    @Override
    public Object decode(Channel channel, String remoteIp, byte[] data) throws IOException {
        if (MotanSwitcherUtil.isOpen(CODEC_VERSION_SWITCHER)) {
            return this.v1Codec.decode(channel, remoteIp, data);
        }
        if (data.length <= 3) {
            throw new MotanFrameworkException("decode error: format problem", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        if (data[2] == RpcProtocolVersion.VERSION_1.getVersion()) {
            return this.v1Codec.decode(channel, remoteIp, data);
        }
        if (data[2] == RpcProtocolVersion.VERSION_1_Compress.getVersion()) {
            return this.decodeV2(channel, remoteIp, data);
        }
        throw new MotanFrameworkException("decode error: version error. version=" + data[2], MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
    }

    public byte[] encodeV2(Channel channel, Object message) throws IOException {
        try {
            if (message instanceof Request) {
                return this.encodeRequest(channel, (Request)message);
            }
            if (message instanceof Response) {
                return this.encodeResponse(channel, (Response)message);
            }
        }
        catch (Exception e) {
            if (ExceptionUtil.isMotanException(e)) {
                throw (RuntimeException)e;
            }
            throw new MotanFrameworkException("encode error: isResponse=" + (message instanceof Response), e, MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
        }
        throw new MotanFrameworkException("encode error: message type not support, " + message.getClass(), MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
    }

    public Object decodeV2(Channel channel, String remoteIp, byte[] data) throws IOException {
        if (data.length <= RpcProtocolVersion.VERSION_1_Compress.getHeaderLength()) {
            throw new MotanFrameworkException("decode error: format problem", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        short type = ByteUtil.bytes2short(data, 0);
        if (type != -3856) {
            throw new MotanFrameworkException("decode error: magic error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        int bodyLength = ByteUtil.bytes2int(data, 12);
        if (RpcProtocolVersion.VERSION_1_Compress.getHeaderLength() + bodyLength != data.length) {
            throw new MotanFrameworkException("decode error: content length error", MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        byte flag = data[3];
        byte dataType = (byte)(flag & 7);
        boolean isResponse = dataType != 0;
        byte[] body = new byte[bodyLength];
        System.arraycopy(data, RpcProtocolVersion.VERSION_1.getHeaderLength(), body, 0, bodyLength);
        long requestId = ByteUtil.bytes2long(data, 4);
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        try {
            if (isResponse) {
                return this.decodeResponse(body, dataType, requestId, data[2], serialization);
            }
            return this.decodeRequest(body, requestId, remoteIp, serialization);
        }
        catch (ClassNotFoundException e) {
            throw new MotanFrameworkException("decode " + (isResponse ? "response" : "request") + " error: class not found", e, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        catch (Exception e) {
            if (ExceptionUtil.isMotanException(e)) {
                throw (RuntimeException)e;
            }
            throw new MotanFrameworkException("decode error: isResponse=" + isResponse, e, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
    }

    private byte[] encodeRequest(Channel channel, Request request) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutput output = this.createOutput(outputStream);
        this.addMethodInfo(output, request);
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        if (request.getArguments() != null && request.getArguments().length > 0) {
            for (Object obj : request.getArguments()) {
                this.serialize(output, obj, serialization);
            }
        }
        if (request.getAttachments() == null || request.getAttachments().isEmpty()) {
            output.writeShort(0);
        } else {
            Map<String, String> attachments = this.copyMap(request.getAttachments());
            this.replaceAttachmentParamsBySign(channel, attachments);
            this.addAttachment(output, attachments);
        }
        output.flush();
        byte[] body = outputStream.toByteArray();
        byte flag = 0;
        output.close();
        Boolean usegz = channel.getUrl().getBooleanParameter(URLParamType.usegz.getName(), URLParamType.usegz.getBooleanValue());
        int minGzSize = channel.getUrl().getIntParameter(URLParamType.mingzSize.getName(), URLParamType.mingzSize.getIntValue());
        return this.encode(this.compress(body, usegz, minGzSize), flag, request.getRequestId());
    }

    private Map<String, String> copyMap(Map<String, String> attachments) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue());
        }
        return resultMap;
    }

    private void addMethodInfo(ObjectOutput output, Request request) throws IOException {
        String methodInfoStr = MotanFrameworkUtil.getServiceKey(request) + request.getMethodName() + request.getParamtersDesc();
        String methodSign = METHOD_SIGN_MAP.get(methodInfoStr);
        if (methodSign == null) {
            MethodInfo temp = new MethodInfo(MotanFrameworkUtil.getGroupFromRequest(request), request.getInterfaceName(), request.getMethodName(), request.getParamtersDesc(), MotanFrameworkUtil.getVersionFromRequest(request));
            try {
                methodSign = temp.getSign();
                METHOD_SIGN_MAP.putIfAbsent(methodInfoStr, methodSign);
                LoggerUtil.info("add method sign:" + methodSign + ", methodinfo:" + temp.toString());
            }
            catch (Exception e) {
                LoggerUtil.warn("gen method sign fail!" + e.getMessage());
            }
        }
        if (methodSign != null) {
            output.writeUTF(SIGN_FLAG);
            output.writeUTF(methodSign);
        } else {
            output.writeUTF(request.getInterfaceName());
            output.writeUTF(request.getMethodName());
            output.writeUTF(request.getParamtersDesc());
        }
    }

    private void replaceAttachmentParamsBySign(Channel channel, Map<String, String> attachments) {
        String clientRequestid;
        String sign;
        AttachmentInfo info = this.getAttachmentInfoMap(attachments);
        if (info != null && (sign = info.getAttachmentSign()) != null) {
            attachments.put(ATTACHMENT_SIGN, sign);
            if (ACCEPT_ATTACHMENT_SIGN.contains(sign)) {
                this.removeAttachmentInfoMap(attachments);
            }
        }
        if ((clientRequestid = attachments.get(URLParamType.requestIdFromClient.getName())) != null && !URLParamType.requestIdFromClient.getValue().equals(clientRequestid)) {
            attachments.put(CLIENT_REQUESTID, clientRequestid);
        }
        attachments.remove(URLParamType.requestIdFromClient.getName());
    }

    private void addAttachment(ObjectOutput output, Map<String, String> attachments) throws IOException {
        output.writeShort(attachments.size());
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            output.writeUTF(entry.getKey());
            output.writeUTF(entry.getValue());
        }
    }

    private byte[] encodeResponse(Channel channel, Response value) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutput output = this.createOutput(outputStream);
        Serialization serialization = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(channel.getUrl().getParameter(URLParamType.serialize.getName(), URLParamType.serialize.getValue()));
        byte flag = 0;
        output.writeLong(value.getProcessTime());
        if (value.getException() != null) {
            output.writeUTF(value.getException().getClass().getName());
            this.serialize(output, value.getException(), serialization);
            flag = 5;
        } else if (value.getValue() == null) {
            flag = 3;
        } else {
            output.writeUTF(value.getValue().getClass().getName());
            this.serialize(output, value.getValue(), serialization);
            Map<String, String> attachments = value.getAttachments();
            HashMap<String, String> responseAttachments = new HashMap<String, String>();
            if (attachments != null) {
                String signed = attachments.get(ATTACHMENT_SIGN);
                String unSigned = attachments.get(UN_ATTACHMENT_SIGN);
                if (StringUtils.isNotBlank((CharSequence)signed)) {
                    responseAttachments.put(ATTACHMENT_SIGN, signed);
                }
                if (StringUtils.isNotBlank((CharSequence)unSigned)) {
                    responseAttachments.put(UN_ATTACHMENT_SIGN, unSigned);
                }
            }
            if (!responseAttachments.isEmpty()) {
                this.addAttachment(output, responseAttachments);
            } else {
                output.writeShort(0);
            }
            flag = 7;
        }
        output.flush();
        byte[] body = outputStream.toByteArray();
        output.close();
        Boolean usegz = channel.getUrl().getBooleanParameter(URLParamType.usegz.getName(), URLParamType.usegz.getBooleanValue());
        int minGzSize = channel.getUrl().getIntParameter(URLParamType.mingzSize.getName(), URLParamType.mingzSize.getIntValue());
        return this.encode(this.compress(body, usegz, minGzSize), flag, value.getRequestId());
    }

    private byte[] encode(byte[] body, byte flag, long requestId) throws IOException {
        byte[] header = new byte[RpcProtocolVersion.VERSION_1_Compress.getHeaderLength()];
        int offset = 0;
        ByteUtil.short2bytes((short)-3856, header, offset);
        offset += 2;
        header[offset++] = RpcProtocolVersion.VERSION_1_Compress.getVersion();
        header[offset++] = flag;
        ByteUtil.long2bytes(requestId, header, offset);
        ByteUtil.int2bytes(body.length, header, offset += 8);
        byte[] data = new byte[header.length + body.length];
        System.arraycopy(header, 0, data, 0, header.length);
        System.arraycopy(body, 0, data, header.length, body.length);
        return data;
    }

    private Object decodeRequest(byte[] body, long requestId, String remoteIp, Serialization serialization) throws IOException, ClassNotFoundException {
        ObjectInput input = this.createInput(CompressRpcCodec.getInputStream(body));
        String interfaceName = null;
        String methodName = null;
        String paramtersDesc = null;
        String group = null;
        String version = null;
        String flag = input.readUTF();
        if (SIGN_FLAG.equals(flag)) {
            String sign = input.readUTF();
            MethodInfo mInfo = SIGN_METHOD_MAP.get(sign);
            if (mInfo == null) {
                throw new MotanFrameworkException("decode error: invalid method sign: " + sign, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
            }
            interfaceName = mInfo.getInterfaceName();
            methodName = mInfo.getMethodName();
            paramtersDesc = mInfo.getParamtersDesc();
            group = mInfo.getGroup();
            version = mInfo.getVersion();
        } else {
            interfaceName = flag;
            methodName = input.readUTF();
            paramtersDesc = input.readUTF();
        }
        DefaultRequest rpcRequest = new DefaultRequest();
        rpcRequest.setRequestId(requestId);
        rpcRequest.setInterfaceName(interfaceName);
        rpcRequest.setMethodName(methodName);
        rpcRequest.setParamtersDesc(paramtersDesc);
        rpcRequest.setArguments(this.decodeRequestParameter(input, paramtersDesc, serialization));
        rpcRequest.setAttachments(this.decodeRequestAttachments(input));
        rpcRequest.setRpcProtocolVersion(RpcProtocolVersion.VERSION_1_Compress.getVersion());
        input.close();
        Map<String, String> attachments = rpcRequest.getAttachments();
        this.putSignedAttachment(attachments, remoteIp);
        if (attachments.get(URLParamType.group.name()) == null) {
            attachments.put(URLParamType.group.name(), group);
            attachments.put(URLParamType.version.name(), version);
        }
        return rpcRequest;
    }

    private void putSignedAttachment(Map<String, String> attachments, String remoteIp) {
        if (attachments != null && !attachments.isEmpty()) {
            String sign;
            AttachmentInfo info = this.getAttachmentInfoMap(attachments);
            if (info != null) {
                sign = attachments.get(ATTACHMENT_SIGN);
                if (StringUtils.isNotBlank((CharSequence)sign)) {
                    SIGN_ATTACHMENT_MAP.put(remoteIp + sign, info);
                    LoggerUtil.info("update attachment sign:" + remoteIp + sign + ", info-group:" + info.getGroup());
                }
            } else {
                sign = attachments.get(ATTACHMENT_SIGN);
                if (StringUtils.isNotBlank((CharSequence)sign)) {
                    info = SIGN_ATTACHMENT_MAP.get(remoteIp + sign);
                    if (info != null) {
                        this.putAttachmentInfoMap(info, attachments);
                    } else {
                        attachments.put(UN_ATTACHMENT_SIGN, sign);
                        LoggerUtil.info("miss attachment sign:" + remoteIp + sign);
                    }
                    attachments.remove(ATTACHMENT_SIGN);
                } else {
                    LoggerUtil.warn("attachment sign is blank\uff0capplication info miss!");
                }
            }
            String clientRequestid = URLParamType.requestIdFromClient.getValue();
            if (attachments.containsKey(CLIENT_REQUESTID)) {
                clientRequestid = attachments.get(CLIENT_REQUESTID);
            }
            attachments.put(URLParamType.requestIdFromClient.getName(), clientRequestid);
        }
    }

    private Object[] decodeRequestParameter(ObjectInput input, String parameterDesc, Serialization serialization) throws IOException, ClassNotFoundException {
        if (parameterDesc == null || parameterDesc.equals("")) {
            return null;
        }
        Class<?>[] classTypes = ReflectUtil.forNames(parameterDesc);
        Object[] paramObjs = new Object[classTypes.length];
        for (int i = 0; i < classTypes.length; ++i) {
            paramObjs[i] = this.deserialize((byte[])input.readObject(), classTypes[i], serialization);
        }
        return paramObjs;
    }

    private Map<String, String> decodeRequestAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = input.readShort();
        if (size <= 0) {
            return null;
        }
        HashMap<String, String> attachments = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            attachments.put(input.readUTF(), input.readUTF());
        }
        return attachments;
    }

    private Object decodeResponse(byte[] body, byte dataType, long requestId, byte rpcProtocolVersion, Serialization serialization) throws IOException, ClassNotFoundException {
        ObjectInput input = this.createInput(CompressRpcCodec.getInputStream(body));
        long processTime = input.readLong();
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setProcessTime(processTime);
        if (dataType == 3) {
            return response;
        }
        String className = input.readUTF();
        Class<?> clz = ReflectUtil.forName(className);
        Object result = this.deserialize((byte[])input.readObject(), clz, serialization);
        if (dataType == 1) {
            response.setValue(result);
        } else if (dataType == 7) {
            response.setValue(result);
            Map<String, String> attachment = this.decodeRequestAttachments(input);
            this.checkAttachment(attachment);
        } else if (dataType == 5) {
            response.setException((Exception)result);
        } else {
            throw new MotanFrameworkException("decode error: response dataType not support " + dataType, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
        response.setRequestId(requestId);
        input.close();
        return response;
    }

    private void checkAttachment(Map<String, String> attachment) {
        if (attachment != null && !attachment.isEmpty()) {
            String notAcceptSign;
            String acceptSign = attachment.get(ATTACHMENT_SIGN);
            if (StringUtils.isNotBlank((CharSequence)acceptSign)) {
                ACCEPT_ATTACHMENT_SIGN.add(acceptSign);
            }
            if (StringUtils.isNotBlank((CharSequence)(notAcceptSign = attachment.get(UN_ATTACHMENT_SIGN)))) {
                ACCEPT_ATTACHMENT_SIGN.remove(notAcceptSign);
            }
        }
    }

    private AttachmentInfo getAttachmentInfoMap(Map<String, String> attachments) {
        AttachmentInfo result = null;
        if (attachments != null && attachments.containsKey(URLParamType.application.name())) {
            String group = attachments.get(URLParamType.group.name());
            String application = attachments.get(URLParamType.application.name());
            String module = attachments.get(URLParamType.module.name());
            String version = attachments.get(URLParamType.version.name());
            result = new AttachmentInfo(group, application, module, version);
        }
        return result;
    }

    private void putAttachmentInfoMap(AttachmentInfo attachmentInfo, Map<String, String> attachments) {
        if (attachments != null) {
            attachments.put(URLParamType.group.name(), attachmentInfo.getGroup());
            attachments.put(URLParamType.application.name(), attachmentInfo.getApplication());
            attachments.put(URLParamType.module.name(), attachmentInfo.getModule());
            attachments.put(URLParamType.version.name(), attachmentInfo.getVersion());
        }
    }

    private void removeAttachmentInfoMap(Map<String, String> attachments) {
        if (attachments != null) {
            attachments.remove(URLParamType.group.name());
            attachments.remove(URLParamType.module.name());
            attachments.remove(URLParamType.version.name());
        }
    }

    public static InputStream getInputStream(byte[] data) {
        if (CompressRpcCodec.isGzipData(data)) {
            try {
                return new GZIPInputStream(new ByteArrayInputStream(data));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ByteArrayInputStream(data);
    }

    private static boolean isGzipData(byte[] data) {
        int header;
        return data.length > 2 && 35615 == (header = data[0] & 0xFF | (data[1] & 0xFF) << 8);
    }

    public byte[] compress(byte[] org, boolean useGzip, int minGzSize) throws IOException {
        if (useGzip && org.length > minGzSize) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(outputStream);
            gos.write(org);
            gos.finish();
            gos.flush();
            gos.close();
            byte[] ret = outputStream.toByteArray();
            return ret;
        }
        return org;
    }

    public static void putMethodSign(Provider<?> provider, List<Method> methods) {
        String group = provider.getUrl().getGroup();
        String interfaceName = provider.getInterface().getName();
        String version = provider.getUrl().getVersion();
        for (Method method : methods) {
            MethodInfo temp = new MethodInfo(group, interfaceName, method.getName(), ReflectUtil.getMethodParamDesc(method), version);
            String sign = temp.getSign();
            MethodInfo priInfo = SIGN_METHOD_MAP.putIfAbsent(sign, temp);
            if (priInfo != null && !temp.equals(priInfo)) {
                throw new MotanFrameworkException("add method sign conflict! " + temp.toString() + " with " + priInfo.toString(), MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
            }
            LoggerUtil.info("add method sign:" + sign + ", methodinfo:" + temp.toString());
        }
    }

    public static void putMethodSign(String methodSign, MethodInfo methodInfo) {
        SIGN_METHOD_MAP.putIfAbsent(methodSign, methodInfo);
    }

    static {
        LoggerUtil.info("init compress codec");
        MotanSwitcherUtil.initSwitcher(CODEC_VERSION_SWITCHER, false);
    }

    static class AttachmentInfo {
        String group;
        String application;
        String module;
        String version;

        public AttachmentInfo(String group, String application, String module, String version) {
            this.group = group;
            this.application = application;
            this.module = module;
            this.version = version;
        }

        public String getAttachmentSign() {
            String signstr = this.group + this.application + this.module + this.version;
            String hashcodeStr = null;
            try {
                hashcodeStr = MotanDigestUtil.md5LowerCase(signstr).substring(8, 12);
            }
            catch (Exception e) {
                LoggerUtil.warn("getAttachmentSign fail!" + e.getMessage());
            }
            return hashcodeStr;
        }

        public String getGroup() {
            return this.group;
        }

        public String getApplication() {
            return this.application;
        }

        public String getModule() {
            return this.module;
        }

        public String getVersion() {
            return this.version;
        }
    }

    static class MethodInfo {
        String group;
        String interfaceName;
        String methodName;
        String paramtersDesc;
        String version;

        public MethodInfo(String group, String interfaceName, String methodName, String paramtersDesc, String version) {
            this.group = group;
            this.interfaceName = interfaceName;
            this.methodName = methodName;
            this.paramtersDesc = paramtersDesc;
            this.version = version;
        }

        public String getSign() {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(this.group).append(this.interfaceName).append(this.methodName).append(this.paramtersDesc).append(this.version);
                String surfix = MotanDigestUtil.md5LowerCase(sb.toString()).substring(8, 20);
                int endIndex = this.methodName.length() > 4 ? 4 : this.methodName.length();
                String prefix = this.methodName.substring(0, endIndex);
                return prefix + surfix;
            }
            catch (Exception e) {
                throw new MotanFrameworkException("gen method sign error! " + this.toString(), MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
            }
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public void setInterfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getParamtersDesc() {
            return this.paramtersDesc;
        }

        public void setParamtersDesc(String paramtersDesc) {
            this.paramtersDesc = paramtersDesc;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
            result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            result = 31 * result + (this.paramtersDesc == null ? 0 : this.paramtersDesc.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodInfo other = (MethodInfo)obj;
            if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
                return false;
            }
            if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            if (this.paramtersDesc == null ? other.paramtersDesc != null : !this.paramtersDesc.equals(other.paramtersDesc)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            return "MethodInfo [group=" + this.group + ", interfaceName=" + this.interfaceName + ", methodName=" + this.methodName + ", paramtersDesc=" + this.paramtersDesc + ", version=" + this.version + "]";
        }
    }
}

