/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2StreamActiveEvent;
import io.netty.handler.codec.http2.Http2StreamClosedEvent;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2StreamStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;

public final class Http2MultiplexCodec
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2MultiplexCodec.class);
    private final ChannelHandler streamHandler;
    private final EventLoopGroup streamGroup;
    private final List<Http2StreamChannel> channelsToFireChildReadComplete = new ArrayList<Http2StreamChannel>();
    private final boolean server;
    private ChannelHandlerContext ctx;
    private volatile Runnable flushTask;
    private final IntObjectMap<Http2StreamChannel> childChannels = new IntObjectHashMap();

    public Http2MultiplexCodec(boolean server, EventLoopGroup streamGroup, ChannelHandler streamHandler) {
        if (!streamHandler.getClass().isAnnotationPresent(ChannelHandler.Sharable.class)) {
            throw new IllegalArgumentException("streamHandler must be Sharable");
        }
        this.server = server;
        this.streamHandler = streamHandler;
        this.streamGroup = streamGroup;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!(cause instanceof Http2Exception.StreamException)) {
            ctx.fireExceptionCaught(cause);
            return;
        }
        Http2Exception.StreamException streamEx = (Http2Exception.StreamException)cause;
        try {
            Http2StreamChannel childChannel = (Http2StreamChannel)((Object)this.childChannels.get(streamEx.streamId()));
            if (childChannel != null) {
                childChannel.pipeline().fireExceptionCaught((Throwable)streamEx);
            } else {
                logger.warn(String.format("Exception caught for unknown HTTP/2 stream '%d'", streamEx.streamId()), (Throwable)streamEx);
            }
        }
        finally {
            this.onStreamClosed(streamEx.streamId());
        }
    }

    public void flush(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Http2Frame)) {
            ctx.fireChannelRead(msg);
            return;
        }
        if (msg instanceof Http2StreamFrame) {
            Http2StreamFrame frame = (Http2StreamFrame)msg;
            int streamId = frame.streamId();
            Http2StreamChannel childChannel = (Http2StreamChannel)((Object)this.childChannels.get(streamId));
            if (childChannel == null) {
                ReferenceCountUtil.release((Object)msg);
                throw new Http2Exception.StreamException(streamId, Http2Error.STREAM_CLOSED, String.format("Received %s frame for an unknown stream %d", frame.name(), streamId));
            }
            this.fireChildReadAndRegister(childChannel, frame);
        } else if (msg instanceof Http2GoAwayFrame) {
            Http2GoAwayFrame goAwayFrame = (Http2GoAwayFrame)msg;
            for (IntObjectMap.PrimitiveEntry entry : this.childChannels.entries()) {
                Http2StreamChannel childChannel = (Http2StreamChannel)((Object)entry.value());
                int streamId = entry.key();
                if (streamId <= goAwayFrame.lastStreamId() || !this.isLocalStream(streamId)) continue;
                childChannel.pipeline().fireUserEventTriggered((Object)goAwayFrame.retainedDuplicate());
            }
            goAwayFrame.release();
        } else {
            ReferenceCountUtil.release((Object)msg);
            throw new UnsupportedMessageTypeException(msg, new Class[0]);
        }
    }

    private void fireChildReadAndRegister(Http2StreamChannel childChannel, Http2StreamFrame frame) {
        childChannel.fireChildRead(frame);
        if (!childChannel.inStreamsToFireChildReadComplete) {
            this.channelsToFireChildReadComplete.add(childChannel);
            childChannel.inStreamsToFireChildReadComplete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        block6: {
            if (!(evt instanceof Http2StreamStateEvent)) {
                ctx.fireUserEventTriggered(evt);
                return;
            }
            try {
                int streamId = ((Http2StreamStateEvent)evt).streamId();
                if (evt instanceof Http2StreamActiveEvent) {
                    this.onStreamActive(streamId);
                    break block6;
                }
                if (evt instanceof Http2StreamClosedEvent) {
                    this.onStreamClosed(streamId);
                    break block6;
                }
                throw new UnsupportedMessageTypeException(evt, new Class[0]);
            }
            finally {
                ReferenceCountUtil.release((Object)evt);
            }
        }
    }

    private void onStreamActive(int streamId) {
        ChannelFuture future = this.createStreamChannel(this.ctx, streamId, this.streamHandler);
        Http2StreamChannel childChannel = (Http2StreamChannel)future.channel();
        Http2StreamChannel oldChannel = (Http2StreamChannel)((Object)this.childChannels.put(streamId, (Object)childChannel));
        assert (oldChannel == null);
    }

    private void onStreamClosed(int streamId) {
        final Http2StreamChannel childChannel = (Http2StreamChannel)((Object)this.childChannels.remove(streamId));
        if (childChannel != null) {
            EventLoop eventLoop = childChannel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.onStreamClosed0(childChannel);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        Http2MultiplexCodec.this.onStreamClosed0(childChannel);
                    }
                });
            }
        }
    }

    private void onStreamClosed0(Http2StreamChannel childChannel) {
        assert (childChannel.eventLoop().inEventLoop());
        childChannel.onStreamClosedFired = true;
        childChannel.fireChildRead(AbstractHttp2StreamChannel.CLOSE_MESSAGE);
    }

    void flushFromStreamChannel() {
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this.flush(this.ctx);
        } else {
            Runnable task = this.flushTask;
            if (task == null) {
                task = this.flushTask = new Runnable(){

                    @Override
                    public void run() {
                        Http2MultiplexCodec.this.flush(Http2MultiplexCodec.this.ctx);
                    }
                };
            }
            executor.execute(task);
        }
    }

    void writeFromStreamChannel(final Object msg, final boolean flush) {
        final ChannelPromise promise = this.ctx.newPromise();
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this.writeFromStreamChannel0(msg, flush, promise);
        } else {
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        Http2MultiplexCodec.this.writeFromStreamChannel0(msg, flush, promise);
                    }
                });
            }
            catch (Throwable cause) {
                promise.setFailure(cause);
            }
        }
    }

    private void writeFromStreamChannel0(Object msg, boolean flush, ChannelPromise promise) {
        try {
            this.write(this.ctx, msg, promise);
        }
        catch (Throwable cause) {
            promise.tryFailure(cause);
        }
        if (flush) {
            this.flush(this.ctx);
        }
    }

    private ChannelFuture createStreamChannel(ChannelHandlerContext ctx, int streamId, ChannelHandler handler) {
        EventLoopGroup group = this.streamGroup != null ? this.streamGroup : ctx.channel().eventLoop();
        Http2StreamChannel channel = new Http2StreamChannel(streamId);
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        ChannelFuture future = group.register((Channel)channel);
        if (future.cause() != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
        return future;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        for (int i = 0; i < this.channelsToFireChildReadComplete.size(); ++i) {
            Http2StreamChannel childChannel = this.channelsToFireChildReadComplete.get(i);
            childChannel.inStreamsToFireChildReadComplete = false;
            childChannel.fireChildReadComplete();
        }
        this.channelsToFireChildReadComplete.clear();
    }

    private boolean isLocalStream(int streamId) {
        boolean even = (streamId & 1) == 0;
        return streamId > 0 && this.server == even;
    }

    final class Http2StreamChannel
    extends AbstractHttp2StreamChannel {
        private final int streamId;
        boolean onStreamClosedFired;
        boolean inStreamsToFireChildReadComplete;

        Http2StreamChannel(int streamId) {
            super(Http2MultiplexCodec.this.ctx.channel());
            this.streamId = streamId;
        }

        @Override
        protected void doClose() throws Exception {
            if (!this.onStreamClosedFired) {
                DefaultHttp2ResetFrame resetFrame = new DefaultHttp2ResetFrame(Http2Error.CANCEL).setStreamId(this.streamId);
                Http2MultiplexCodec.this.writeFromStreamChannel(resetFrame, true);
            }
            super.doClose();
        }

        @Override
        protected void doWrite(Object msg) {
            if (!(msg instanceof Http2StreamFrame)) {
                ReferenceCountUtil.release((Object)msg);
                throw new IllegalArgumentException("Message must be an Http2StreamFrame: " + msg);
            }
            Http2StreamFrame frame = (Http2StreamFrame)msg;
            if (frame.streamId() != -1) {
                ReferenceCountUtil.release((Object)frame);
                throw new IllegalArgumentException("Stream must not be set on the frame");
            }
            frame.setStreamId(this.streamId);
            Http2MultiplexCodec.this.writeFromStreamChannel(msg, false);
        }

        @Override
        protected void doWriteComplete() {
            Http2MultiplexCodec.this.flushFromStreamChannel();
        }

        @Override
        protected EventExecutor preferredEventExecutor() {
            return Http2MultiplexCodec.this.ctx.executor();
        }

        @Override
        protected void bytesConsumed(int bytes) {
            Http2MultiplexCodec.this.ctx.write((Object)new DefaultHttp2WindowUpdateFrame(bytes).setStreamId(this.streamId));
        }
    }
}

