/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.cli.commands.QuarkusCommand;
import io.quarkus.cli.commands.QuarkusCommandException;
import io.quarkus.cli.commands.QuarkusCommandInvocation;
import io.quarkus.cli.commands.QuarkusCommandOutcome;
import io.quarkus.cli.commands.file.BuildFile;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.generators.ProjectGeneratorRegistry;
import io.quarkus.generators.SourceType;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;

public class CreateProjectCommandHandler
implements QuarkusCommand {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        ProjectWriter projectWriter = invocation.getProjectWriter();
        if (projectWriter == null) {
            throw new IllegalStateException("Project writer has not been provided");
        }
        if (!projectWriter.init()) {
            return QuarkusCommandOutcome.failure();
        }
        QuarkusPlatformDescriptor platformDescr = invocation.getPlatformDescriptor();
        invocation.setProperty("bom_groupId", platformDescr.getBomGroupId());
        invocation.setProperty("bom_artifactId", platformDescr.getBomArtifactId());
        invocation.setProperty("quarkus_version", platformDescr.getQuarkusVersion());
        invocation.setProperty("bom_version", platformDescr.getBomVersion());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(platformDescr);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> invocation.setProperty(k.toString().replace("-", "_"), v.toString())));
        try (BuildFile buildFile = invocation.getBuildFile();){
            invocation.setValue("build_file", buildFile);
            String className = invocation.getProperty("class_name");
            if (className != null) {
                className = invocation.getValue("source_type", SourceType.JAVA).stripExtensionFrom(className);
                int idx = className.lastIndexOf(46);
                if (idx >= 0) {
                    String pkgName = invocation.getProperty("package_name");
                    if (pkgName == null) {
                        invocation.setProperty("package_name", className.substring(0, idx));
                    }
                    className = className.substring(idx + 1);
                }
                invocation.setProperty("class_name", className);
            }
            ProjectGeneratorRegistry.get("basic-rest").generate(projectWriter, invocation);
            buildFile.completeFile(invocation.getProperty("project_groupId"), invocation.getProperty("project_artifactId"), invocation.getProperty("project_version"), platformDescr, quarkusProps);
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to create project", e);
        }
        return QuarkusCommandOutcome.success();
    }
}

