/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.loader.json;

import io.quarkus.platform.descriptor.ResourceInputStreamConsumer;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class DirectoryResourceLoader
implements ResourceLoader {
    private final Path dir;

    public DirectoryResourceLoader(Path dir) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalStateException("Failed to locate directory " + dir);
        }
        this.dir = dir;
    }

    @Override
    public <T> T loadResource(String name, ResourceInputStreamConsumer<T> consumer) throws IOException {
        Path resource = this.dir.resolve(name);
        if (!Files.exists(resource, new LinkOption[0])) {
            throw new IOException("Failed to locate " + resource);
        }
        if (Files.isDirectory(resource, new LinkOption[0])) {
            throw new IOException("Can't open a stream for path pointing to directory " + resource);
        }
        try (InputStream is = Files.newInputStream(resource, new OpenOption[0]);){
            Object object = consumer.consume(is);
            return (T)object;
        }
    }
}

