/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.interceptors;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.evaluation.Evaluator;
import io.seata.saga.engine.evaluation.EvaluatorFactory;
import io.seata.saga.engine.evaluation.EvaluatorFactoryManager;
import io.seata.saga.engine.evaluation.expression.ExpressionEvaluator;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.InterceptableStateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.handlers.ServiceTaskStateHandler;
import io.seata.saga.engine.pcext.handlers.SubStateMachineHandler;
import io.seata.saga.engine.pcext.utils.CompensationHolder;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.pcext.utils.ParameterUtils;
import io.seata.saga.engine.utils.ExceptionUtils;
import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.impl.ServiceTaskStateImpl;
import io.seata.saga.statelang.domain.impl.StateInstanceImpl;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@LoadLevel(name="ServiceTask", order=100)
public class ServiceTaskHandlerInterceptor
implements StateHandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTaskHandlerInterceptor.class);

    @Override
    public boolean match(Class<? extends InterceptableStateHandler> clazz) {
        return clazz != null && (ServiceTaskStateHandler.class.isAssignableFrom(clazz) || SubStateMachineHandler.class.isAssignableFrom(clazz));
    }

    @Override
    public void preProcess(ProcessContext context) throws EngineExecutionException {
        List<StateInstance> stateList;
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        if (EngineUtils.isTimeout(stateMachineInstance.getGmtUpdated(), stateMachineConfig.getTransOperationTimeout())) {
            String message = "Saga Transaction [stateMachineInstanceId:" + stateMachineInstance.getId() + "] has timed out, stop execution now.";
            LOGGER.error(message);
            EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(null, FrameworkErrorCode.StateMachineExecutionTimeout, message, stateMachineInstance, instruction.getStateName());
            EngineUtils.failStateMachine(context, exception);
            throw exception;
        }
        StateInstanceImpl stateInstance = new StateInstanceImpl();
        Map contextVariables = (Map)context.getVariable("context");
        ServiceTaskStateImpl state = (ServiceTaskStateImpl)instruction.getState(context);
        List<Object> serviceInputParams = null;
        if (contextVariables != null) {
            try {
                serviceInputParams = ParameterUtils.createInputParams(stateMachineConfig.getExpressionFactoryManager(), stateInstance, state, contextVariables);
            }
            catch (Exception e) {
                String message = "Task [" + state.getName() + "] input parameters assign failed, please check 'Input' expression:" + e.getMessage();
                EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(e, FrameworkErrorCode.VariablesAssignError, message, stateMachineInstance, state.getName());
                EngineUtils.failStateMachine(context, exception);
                throw exception;
            }
        }
        ((HierarchicalProcessContext)context).setVariableLocally("inputParams", serviceInputParams);
        stateInstance.setMachineInstanceId(stateMachineInstance.getId());
        stateInstance.setStateMachineInstance(stateMachineInstance);
        stateInstance.setName(state.getName());
        stateInstance.setGmtStarted(new Date());
        stateInstance.setStatus(ExecutionStatus.RU);
        stateInstance.setStateIdRetriedFor((String)context.getVariable(state.getName() + "_retried_state_instance_id"));
        if (StringUtils.hasLength((String)stateInstance.getBusinessKey())) {
            ((Map)context.getVariable("context")).put(state.getName() + "_business_key_", stateInstance.getBusinessKey());
        }
        stateInstance.setType(state.getType());
        stateInstance.setForUpdate(state.isForUpdate());
        stateInstance.setServiceName(state.getServiceName());
        stateInstance.setServiceMethod(state.getServiceMethod());
        stateInstance.setServiceType(state.getServiceType());
        Boolean isForCompensation = state.isForCompensation();
        if (isForCompensation != null && isForCompensation.booleanValue()) {
            CompensationHolder compensationHolder = CompensationHolder.getCurrent(context, true);
            StateInstance stateToBeCompensated = compensationHolder.getStatesNeedCompensation().get(state.getName());
            if (stateToBeCompensated != null) {
                stateToBeCompensated.setCompensationState(stateInstance);
                stateInstance.setStateIdCompensatedFor(stateToBeCompensated.getId());
            } else {
                LOGGER.error("Compensation State[{}] has no state to compensate, maybe this is a bug.", (Object)state.getName());
            }
            CompensationHolder.getCurrent(context, true).addForCompensationState(stateInstance.getName(), stateInstance);
        }
        if ("forward".equals(context.getVariable("_operation_name_")) && StringUtils.isEmpty((Object)stateInstance.getStateIdRetriedFor()) && !state.isForCompensation() && CollectionUtils.isNotEmpty(stateList = stateMachineInstance.getStateList())) {
            for (int i = stateList.size() - 1; i >= 0; --i) {
                StateInstance executedState = stateList.get(i);
                if (!stateInstance.getName().equals(executedState.getName())) continue;
                stateInstance.setStateIdRetriedFor(executedState.getId());
                executedState.setIgnoreStatus(true);
                break;
            }
        }
        stateInstance.setInputParams(serviceInputParams);
        if (stateMachineInstance.getStateMachine().isPersist() && state.isPersist() && stateMachineConfig.getStateLogStore() != null) {
            try {
                stateMachineConfig.getStateLogStore().recordStateStarted(stateInstance, context);
            }
            catch (Exception e) {
                String message = "Record state[" + state.getName() + "] started failed, stateMachineInstance[" + stateMachineInstance.getId() + "], Reason: " + e.getMessage();
                EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(e, FrameworkErrorCode.ExceptionCaught, message, stateMachineInstance, state.getName());
                EngineUtils.failStateMachine(context, exception);
                throw exception;
            }
        }
        if (StringUtils.isEmpty((Object)stateInstance.getId())) {
            stateInstance.setId(stateMachineConfig.getSeqGenerator().generate("STATE_INST"));
        }
        stateMachineInstance.putStateInstance(stateInstance.getId(), stateInstance);
        ((HierarchicalProcessContext)context).setVariableLocally("_current_state_instance_", stateInstance);
    }

    @Override
    public void postProcess(ProcessContext context, Exception exp) throws EngineExecutionException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        ServiceTaskStateImpl state = (ServiceTaskStateImpl)instruction.getState(context);
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateInstance stateInstance = (StateInstance)context.getVariable("_current_state_instance_");
        if (stateInstance == null || !stateMachineInstance.isRunning()) {
            LOGGER.warn("StateMachineInstance[id:" + stateMachineInstance.getId() + "] is end. stop running");
            return;
        }
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        if (exp == null) {
            exp = (Exception)context.getVariable("currentException");
        }
        stateInstance.setException(exp);
        this.decideExecutionStatus(context, stateInstance, state, exp);
        if (ExecutionStatus.SU.equals((Object)stateInstance.getStatus()) && exp != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Although an exception occurs, the execution status map to SU, and the exception is ignored when the execution status decision.");
            }
            context.removeVariable("currentException");
        }
        Map contextVariables = (Map)context.getVariable("context");
        Object serviceOutputParams = context.getVariable("outputParams");
        if (serviceOutputParams != null) {
            try {
                Map<String, Object> outputVariablesToContext = ParameterUtils.createOutputParams(stateMachineConfig.getExpressionFactoryManager(), state, serviceOutputParams);
                if (CollectionUtils.isNotEmpty(outputVariablesToContext)) {
                    contextVariables.putAll(outputVariablesToContext);
                }
            }
            catch (Exception e) {
                String message = "Task [" + state.getName() + "] output parameters assign failed, please check 'Output' expression:" + e.getMessage();
                EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(e, FrameworkErrorCode.VariablesAssignError, message, stateMachineInstance, stateInstance);
                if (stateMachineInstance.getStateMachine().isPersist() && state.isPersist() && stateMachineConfig.getStateLogStore() != null) {
                    stateMachineConfig.getStateLogStore().recordStateFinished(stateInstance, context);
                }
                EngineUtils.failStateMachine(context, exception);
                throw exception;
            }
        }
        context.removeVariable("outputParams");
        context.removeVariable("inputParams");
        stateInstance.setGmtEnd(new Date());
        if (stateMachineInstance.getStateMachine().isPersist() && state.isPersist() && stateMachineConfig.getStateLogStore() != null) {
            stateMachineConfig.getStateLogStore().recordStateFinished(stateInstance, context);
        }
        if (exp != null && context.getVariable("_is_exception_not_catch_") != null && ((Boolean)context.getVariable("_is_exception_not_catch_")).booleanValue()) {
            context.removeVariable("_is_exception_not_catch_");
            EngineUtils.failStateMachine(context, exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decideExecutionStatus(ProcessContext context, StateInstance stateInstance, ServiceTaskStateImpl state, Exception exp) {
        Map<String, String> statusMatchList = state.getStatus();
        if (CollectionUtils.isNotEmpty(statusMatchList)) {
            if (state.isAsync()) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Service[{}.{}] is execute asynchronously, null return value collected, so user defined Status Matching skipped. stateName: {}, branchId: {}", new Object[]{state.getServiceName(), state.getServiceMethod(), state.getName(), stateInstance.getId()});
                }
            } else {
                StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
                Map<Object, String> statusEvaluators = state.getStatusEvaluators();
                if (statusEvaluators == null) {
                    ServiceTaskStateImpl serviceTaskStateImpl = state;
                    synchronized (serviceTaskStateImpl) {
                        statusEvaluators = state.getStatusEvaluators();
                        if (statusEvaluators == null) {
                            statusEvaluators = new LinkedHashMap<Object, String>(statusMatchList.size());
                            for (Map.Entry<String, String> entry : statusMatchList.entrySet()) {
                                String string = entry.getKey();
                                String statusVal = entry.getValue();
                                Evaluator evaluator = this.createEvaluator(stateMachineConfig.getEvaluatorFactoryManager(), string);
                                if (evaluator == null) continue;
                                statusEvaluators.put(evaluator, statusVal);
                            }
                        }
                        state.setStatusEvaluators(statusEvaluators);
                    }
                }
                for (Object e : statusEvaluators.keySet()) {
                    Evaluator evaluator = (Evaluator)e;
                    String statusVal = statusEvaluators.get(evaluator);
                    if (!evaluator.evaluate(context.getVariables())) continue;
                    stateInstance.setStatus(ExecutionStatus.valueOf(statusVal));
                    break;
                }
                if (exp == null && (stateInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateInstance.getStatus()))) {
                    if (state.isForUpdate()) {
                        stateInstance.setStatus(ExecutionStatus.UN);
                    } else {
                        stateInstance.setStatus(ExecutionStatus.FA);
                    }
                    stateInstance.setGmtEnd(new Date());
                    StateMachineInstance stateMachineInstance = stateInstance.getStateMachineInstance();
                    if (stateMachineInstance.getStateMachine().isPersist() && state.isPersist() && stateMachineConfig.getStateLogStore() != null) {
                        stateMachineConfig.getStateLogStore().recordStateFinished(stateInstance, context);
                    }
                    EngineExecutionException engineExecutionException = new EngineExecutionException("State [" + state.getName() + "] execute finished, but cannot matching status, pls check its status manually", FrameworkErrorCode.NoMatchedStatus);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("State[{}] execute finish with status[{}]", (Object)state.getName(), (Object)stateInstance.getStatus());
                    }
                    EngineUtils.failStateMachine(context, engineExecutionException);
                    throw engineExecutionException;
                }
            }
        }
        if (stateInstance.getStatus() == null || ExecutionStatus.RU.equals((Object)stateInstance.getStatus())) {
            if (exp == null) {
                stateInstance.setStatus(ExecutionStatus.SU);
            } else if (state.isForUpdate() || state.isForCompensation()) {
                stateInstance.setStatus(ExecutionStatus.UN);
                ExceptionUtils.NetExceptionType t = ExceptionUtils.getNetExceptionType(exp);
                if (t != null) {
                    if (t.equals((Object)ExceptionUtils.NetExceptionType.CONNECT_EXCEPTION)) {
                        stateInstance.setStatus(ExecutionStatus.FA);
                    } else if (t.equals((Object)ExceptionUtils.NetExceptionType.READ_TIMEOUT_EXCEPTION)) {
                        stateInstance.setStatus(ExecutionStatus.UN);
                    }
                } else {
                    stateInstance.setStatus(ExecutionStatus.UN);
                }
            } else {
                stateInstance.setStatus(ExecutionStatus.FA);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("State[{}] finish with status[{}]", (Object)state.getName(), (Object)stateInstance.getStatus());
        }
    }

    private Evaluator createEvaluator(EvaluatorFactoryManager evaluatorFactoryManager, String expressionStr) {
        String expressionType = null;
        String expressionContent = null;
        Evaluator evaluator = null;
        if (StringUtils.hasLength((String)expressionStr)) {
            if (expressionStr.startsWith("$")) {
                int expTypeStart = expressionStr.indexOf("$");
                int expTypeEnd = expressionStr.indexOf("{", expTypeStart);
                if (expTypeStart >= 0 && expTypeEnd > expTypeStart) {
                    expressionType = expressionStr.substring(expTypeStart + 1, expTypeEnd);
                }
                int expEnd = expressionStr.lastIndexOf("}");
                if (expTypeEnd > 0 && expEnd > expTypeEnd) {
                    expressionContent = expressionStr.substring(expTypeEnd + 1, expEnd);
                }
            } else {
                expressionContent = expressionStr;
            }
            EvaluatorFactory evaluatorFactory = evaluatorFactoryManager.getEvaluatorFactory(expressionType);
            if (evaluatorFactory == null) {
                throw new IllegalArgumentException("Cannot get EvaluatorFactory by Type[" + expressionType + "]");
            }
            evaluator = evaluatorFactory.createEvaluator(expressionContent);
            if (evaluator instanceof ExpressionEvaluator) {
                ((ExpressionEvaluator)evaluator).setRootObjectName("outputParams");
            }
        }
        return evaluator;
    }
}

