/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.datasource.SeataDataSourceProxy;
import io.seata.rm.datasource.xa.Holdable;
import io.seata.rm.datasource.xa.Holder;
import java.io.PrintWriter;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class BaseDataSourceResource<T extends Holdable>
implements SeataDataSourceProxy,
Resource,
Holder<T> {
    protected DataSource dataSource;
    protected String resourceId;
    protected String resourceGroupId;
    protected BranchType branchType;
    protected String dbType;
    protected Driver driver;
    private ConcurrentHashMap<String, T> keeper = new ConcurrentHashMap();

    @Override
    public DataSource getTargetDataSource() {
        return this.dataSource;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public void setResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
    }

    @Override
    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            return null;
        }
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isInstance(this);
    }

    protected void dataSourceCheck() {
        if (this.dataSource == null) {
            throw new UnsupportedOperationException("dataSource CAN NOT be null");
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        this.dataSourceCheck();
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSourceCheck();
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSourceCheck();
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        this.dataSourceCheck();
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        this.dataSourceCheck();
        return this.dataSource.getParentLogger();
    }

    @Override
    public T hold(String key, T value) {
        if (value.isHeld()) {
            Holdable x = (Holdable)this.keeper.get(key);
            if (x != value) {
                throw new ShouldNeverHappenException("something wrong with keeper, keeping[" + x + "] but[" + value + "] is also kept with the same key[" + key + "]");
            }
            return value;
        }
        Holdable x = (Holdable)this.keeper.put(key, value);
        value.setHeld(true);
        return (T)x;
    }

    @Override
    public T release(String key, T value) {
        Holdable x = (Holdable)this.keeper.remove(key);
        if (x != value) {
            throw new ShouldNeverHappenException("something wrong with keeper, released[" + x + "] but[" + value + "] is wanted with key[" + key + "]");
        }
        value.setHeld(false);
        return (T)x;
    }

    @Override
    public T lookup(String key) {
        return (T)((Holdable)this.keeper.get(key));
    }
}

