/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.fence;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.integration.tx.api.fence.config.CommonFenceConfig;
import io.seata.integration.tx.api.fence.exception.CommonFenceException;
import io.seata.rm.fence.SpringFenceHandler;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringFenceConfig
extends CommonFenceConfig
implements InitializingBean {
    private final DataSource dataSource;
    private final PlatformTransactionManager transactionManager;

    public SpringFenceConfig(DataSource dataSource, PlatformTransactionManager transactionManager) {
        this.dataSource = dataSource;
        this.transactionManager = transactionManager;
    }

    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new CommonFenceException(FrameworkErrorCode.DateSourceNeedInjected);
        }
        SpringFenceHandler.setDataSource(this.dataSource);
        if (this.transactionManager == null) {
            throw new CommonFenceException(FrameworkErrorCode.TransactionManagerNeedInjected);
        }
        SpringFenceHandler.setTransactionTemplate(new TransactionTemplate(this.transactionManager));
    }
}

