/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class NotNullAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<NotNull> notNull = this.extractAnnotation(context);
        if (notNull.isPresent()) {
            context.getBuilder().required(Boolean.valueOf(notNull.isPresent()));
        }
    }

    private Optional<NotNull> extractAnnotation(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, NotNull.class).map(Optional::of).orElse(Validators.annotationFromField(context, NotNull.class));
    }
}

