/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;
import org.apache.cassandra.io.util.ChecksummedSequentialWriter;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.io.util.SequentialWriterOption;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.SyncUtil;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableWriter
extends SSTableWriter {
    private static final Logger logger = LoggerFactory.getLogger(BigTableWriter.class);
    private final ColumnIndex columnIndexWriter;
    private final IndexWriter iwriter;
    private final FileHandle.Builder dbuilder;
    protected final SequentialWriter dataFile;
    private DecoratedKey lastWrittenKey;
    private DataPosition dataMark;
    private long lastEarlyOpenLength = 0L;
    private final Optional<ChunkCache> chunkCache = Optional.ofNullable(ChunkCache.instance);
    private final SequentialWriterOption writerOption = SequentialWriterOption.newBuilder().trickleFsync(DatabaseDescriptor.getTrickleFsync()).trickleFsyncByteInterval(DatabaseDescriptor.getTrickleFsyncIntervalInKb() * 1024).build();

    public BigTableWriter(Descriptor descriptor, long keyCount, long repairedAt, CFMetaData metadata, MetadataCollector metadataCollector, SerializationHeader header, Collection<SSTableFlushObserver> observers, LifecycleTransaction txn) {
        super(descriptor, keyCount, repairedAt, metadata, metadataCollector, header, observers);
        txn.trackNew(this);
        this.dataFile = this.compression ? new CompressedSequentialWriter(new File(this.getFilename()), descriptor.filenameFor(Component.COMPRESSION_INFO), new File(descriptor.filenameFor(descriptor.digestComponent)), this.writerOption, metadata.params.compression, metadataCollector) : new ChecksummedSequentialWriter(new File(this.getFilename()), new File(descriptor.filenameFor(Component.CRC)), new File(descriptor.filenameFor(descriptor.digestComponent)), this.writerOption);
        this.dbuilder = new FileHandle.Builder(descriptor.filenameFor(Component.DATA)).compressed(this.compression).mmapped(DatabaseDescriptor.getDiskAccessMode() == Config.DiskAccessMode.mmap);
        this.chunkCache.ifPresent(this.dbuilder::withChunkCache);
        this.iwriter = new IndexWriter(keyCount);
        this.columnIndexWriter = new ColumnIndex(this.header, this.dataFile, descriptor.version, this.observers, this.getRowIndexEntrySerializer().indexInfoSerializer());
    }

    @Override
    public void mark() {
        this.dataMark = this.dataFile.mark();
        this.iwriter.mark();
    }

    @Override
    public void resetAndTruncate() {
        this.dataFile.resetAndTruncate(this.dataMark);
        this.iwriter.resetAndTruncate();
    }

    protected long beforeAppend(DecoratedKey decoratedKey) {
        assert (decoratedKey != null) : "Keys must not be null";
        if (this.lastWrittenKey != null && this.lastWrittenKey.compareTo(decoratedKey) >= 0) {
            throw new RuntimeException("Last written key " + this.lastWrittenKey + " >= current key " + decoratedKey + " writing into " + this.getFilename());
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.position();
    }

    private void afterAppend(DecoratedKey decoratedKey, long dataEnd, RowIndexEntry index, ByteBuffer indexInfo) throws IOException {
        this.metadataCollector.addKey(decoratedKey.getKey());
        this.last = this.lastWrittenKey = decoratedKey;
        if (this.first == null) {
            this.first = this.lastWrittenKey;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("wrote {} at {}", (Object)decoratedKey, (Object)dataEnd);
        }
        this.iwriter.append(decoratedKey, index, dataEnd, indexInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RowIndexEntry append(UnfilteredRowIterator iterator) {
        DecoratedKey key = iterator.partitionKey();
        if (key.getKey().remaining() > 65535) {
            logger.error("Key size {} exceeds maximum of {}, skipping row", (Object)key.getKey().remaining(), (Object)65535);
            return null;
        }
        if (iterator.isEmpty()) {
            return null;
        }
        long startPosition = this.beforeAppend(key);
        this.observers.forEach(o -> o.startPartition(key, this.iwriter.indexFile.position()));
        this.columnIndexWriter.reset();
        try (UnfilteredRowIterator collecting = Transformation.apply(iterator, new StatsCollector(this.metadataCollector));){
            this.columnIndexWriter.buildRowIndex(collecting);
            long indexFilePosition = (long)ByteBufferUtil.serializedSizeWithShortLength(key.getKey()) + this.iwriter.indexFile.position();
            RowIndexEntry<IndexInfo> entry = RowIndexEntry.create(startPosition, indexFilePosition, collecting.partitionLevelDeletion(), this.columnIndexWriter.headerLength, this.columnIndexWriter.columnIndexCount, this.columnIndexWriter.indexInfoSerializedSize(), this.columnIndexWriter.indexSamples(), this.columnIndexWriter.offsets(), this.getRowIndexEntrySerializer().indexInfoSerializer());
            long endPosition = this.dataFile.position();
            long rowSize = endPosition - startPosition;
            this.maybeLogLargePartitionWarning(key, rowSize);
            this.metadataCollector.addPartitionSizeInBytes(rowSize);
            this.afterAppend(key, endPosition, entry, this.columnIndexWriter.buffer());
            RowIndexEntry<IndexInfo> rowIndexEntry = entry;
            return rowIndexEntry;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.dataFile.getPath());
        }
    }

    private RowIndexEntry.IndexSerializer<IndexInfo> getRowIndexEntrySerializer() {
        return this.rowIndexEntrySerializer;
    }

    private void maybeLogLargePartitionWarning(DecoratedKey key, long rowSize) {
        if (rowSize > DatabaseDescriptor.getCompactionLargePartitionWarningThreshold()) {
            String keyString = this.metadata.getKeyValidator().getString(key.getKey());
            logger.warn("Writing large partition {}/{}:{} ({}) to sstable {}", new Object[]{this.metadata.ksName, this.metadata.cfName, keyString, FBUtilities.prettyPrintMemory(rowSize), this.getFilename()});
        }
    }

    @Override
    public SSTableReader openEarly() {
        IndexSummaryBuilder.ReadableBoundary boundary = this.iwriter.getMaxReadable();
        if (boundary == null) {
            return null;
        }
        StatsMetadata stats = this.statsMetadata();
        assert (boundary.indexLength > 0L && boundary.dataLength > 0L);
        IndexSummary indexSummary = this.iwriter.summary.build(this.metadata.partitioner, boundary);
        long indexFileLength = new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).length();
        int indexBufferSize = this.optimizationStrategy.bufferSize(indexFileLength / (long)indexSummary.size());
        FileHandle ifile = this.iwriter.builder.bufferSize(indexBufferSize).complete(boundary.indexLength);
        if (this.compression) {
            this.dbuilder.withCompressionMetadata(((CompressedSequentialWriter)this.dataFile).open(boundary.dataLength));
        }
        int dataBufferSize = this.optimizationStrategy.bufferSize(stats.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
        FileHandle dfile = this.dbuilder.bufferSize(dataBufferSize).complete(boundary.dataLength);
        this.invalidateCacheAtBoundary(dfile);
        SSTableReader sstable = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, ifile, dfile, indexSummary, this.iwriter.bf.sharedCopy(), this.maxDataAge, stats, SSTableReader.OpenReason.EARLY, this.header);
        sstable.first = BigTableWriter.getMinimalKey(this.first);
        sstable.last = BigTableWriter.getMinimalKey(boundary.lastKey);
        return sstable;
    }

    void invalidateCacheAtBoundary(FileHandle dfile) {
        this.chunkCache.ifPresent(cache -> {
            if (this.lastEarlyOpenLength != 0L && dfile.dataLength() > this.lastEarlyOpenLength) {
                cache.invalidatePosition(dfile, this.lastEarlyOpenLength);
            }
        });
        this.lastEarlyOpenLength = dfile.dataLength();
    }

    @Override
    public SSTableReader openFinalEarly() {
        this.dataFile.sync();
        this.iwriter.indexFile.sync();
        return this.openFinal(SSTableReader.OpenReason.EARLY);
    }

    private SSTableReader openFinal(SSTableReader.OpenReason openReason) {
        if (this.maxDataAge < 0L) {
            this.maxDataAge = System.currentTimeMillis();
        }
        StatsMetadata stats = this.statsMetadata();
        IndexSummary indexSummary = this.iwriter.summary.build(this.metadata.partitioner);
        long indexFileLength = new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).length();
        int dataBufferSize = this.optimizationStrategy.bufferSize(stats.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
        int indexBufferSize = this.optimizationStrategy.bufferSize(indexFileLength / (long)indexSummary.size());
        FileHandle ifile = this.iwriter.builder.bufferSize(indexBufferSize).complete();
        if (this.compression) {
            this.dbuilder.withCompressionMetadata(((CompressedSequentialWriter)this.dataFile).open(0L));
        }
        FileHandle dfile = this.dbuilder.bufferSize(dataBufferSize).complete();
        this.invalidateCacheAtBoundary(dfile);
        SSTableReader sstable = SSTableReader.internalOpen(this.descriptor, this.components, this.metadata, ifile, dfile, indexSummary, this.iwriter.bf.sharedCopy(), this.maxDataAge, stats, openReason, this.header);
        sstable.first = BigTableWriter.getMinimalKey(this.first);
        sstable.last = BigTableWriter.getMinimalKey(this.last);
        return sstable;
    }

    @Override
    protected SSTableWriter.TransactionalProxy txnProxy() {
        return new TransactionalProxy();
    }

    private void writeMetadata(Descriptor desc, Map<MetadataType, MetadataComponent> components) {
        File file = new File(desc.filenameFor(Component.STATS));
        try (SequentialWriter out = new SequentialWriter(file, this.writerOption);){
            desc.getMetadataSerializer().serialize(components, out, desc.version);
            out.finish();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, file.getPath());
        }
    }

    @Override
    public long getFilePointer() {
        return this.dataFile.position();
    }

    @Override
    public long getOnDiskFilePointer() {
        return this.dataFile.getOnDiskFilePointer();
    }

    @Override
    public long getEstimatedOnDiskBytesWritten() {
        return this.dataFile.getEstimatedOnDiskBytesWritten();
    }

    class IndexWriter
    extends Transactional.AbstractTransactional
    implements Transactional {
        private final SequentialWriter indexFile;
        public final FileHandle.Builder builder;
        public final IndexSummaryBuilder summary;
        public final IFilter bf;
        private DataPosition mark;

        IndexWriter(long keyCount) {
            this.indexFile = new SequentialWriter(new File(BigTableWriter.this.descriptor.filenameFor(Component.PRIMARY_INDEX)), BigTableWriter.this.writerOption);
            this.builder = new FileHandle.Builder(BigTableWriter.this.descriptor.filenameFor(Component.PRIMARY_INDEX)).mmapped(DatabaseDescriptor.getIndexAccessMode() == Config.DiskAccessMode.mmap);
            BigTableWriter.this.chunkCache.ifPresent(this.builder::withChunkCache);
            this.summary = new IndexSummaryBuilder(keyCount, BigTableWriter.this.metadata.params.minIndexInterval, 128);
            this.bf = FilterFactory.getFilter(keyCount, BigTableWriter.this.metadata.params.bloomFilterFpChance, true, BigTableWriter.this.descriptor.version.hasOldBfHashOrder());
            this.indexFile.setPostFlushListener(() -> this.summary.markIndexSynced(this.indexFile.getLastFlushOffset()));
            BigTableWriter.this.dataFile.setPostFlushListener(() -> this.summary.markDataSynced(BigTableWriter.this.dataFile.getLastFlushOffset()));
        }

        IndexSummaryBuilder.ReadableBoundary getMaxReadable() {
            return this.summary.getLastReadableBoundary();
        }

        public void append(DecoratedKey key, RowIndexEntry indexEntry, long dataEnd, ByteBuffer indexInfo) throws IOException {
            this.bf.add(key);
            long indexStart = this.indexFile.position();
            try {
                ByteBufferUtil.writeWithShortLength(key.getKey(), this.indexFile);
                BigTableWriter.this.rowIndexEntrySerializer.serialize(indexEntry, this.indexFile, indexInfo);
            }
            catch (IOException e) {
                throw new FSWriteError((Throwable)e, this.indexFile.getPath());
            }
            long indexEnd = this.indexFile.position();
            if (logger.isTraceEnabled()) {
                logger.trace("wrote index entry: {} at {}", (Object)indexEntry, (Object)indexStart);
            }
            this.summary.maybeAddEntry(key, indexStart, indexEnd, dataEnd);
        }

        void flushBf() {
            if (BigTableWriter.this.components.contains(Component.FILTER)) {
                String path = BigTableWriter.this.descriptor.filenameFor(Component.FILTER);
                try (FileOutputStream fos = new FileOutputStream(path);
                     BufferedDataOutputStreamPlus stream = new BufferedDataOutputStreamPlus(fos);){
                    FilterFactory.serialize(this.bf, stream);
                    ((OutputStream)stream).flush();
                    SyncUtil.sync(fos);
                }
                catch (IOException e) {
                    throw new FSWriteError((Throwable)e, path);
                }
            }
        }

        public void mark() {
            this.mark = this.indexFile.mark();
        }

        public void resetAndTruncate() {
            this.indexFile.resetAndTruncate(this.mark);
        }

        @Override
        protected void doPrepare() {
            this.flushBf();
            long position = this.indexFile.position();
            this.indexFile.prepareToCommit();
            FileUtils.truncate(this.indexFile.getPath(), position);
            this.summary.prepareToCommit();
            try (IndexSummary indexSummary = this.summary.build(BigTableWriter.this.getPartitioner());){
                SSTableReader.saveSummary(BigTableWriter.this.descriptor, BigTableWriter.this.first, BigTableWriter.this.last, indexSummary);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            return this.indexFile.commit(accumulate);
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            return this.indexFile.abort(accumulate);
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = this.summary.close(accumulate);
            accumulate = this.bf.close(accumulate);
            accumulate = this.builder.close(accumulate);
            return accumulate;
        }
    }

    class TransactionalProxy
    extends SSTableWriter.TransactionalProxy {
        TransactionalProxy() {
        }

        @Override
        protected void doPrepare() {
            BigTableWriter.this.iwriter.prepareToCommit();
            BigTableWriter.this.dataFile.prepareToCommit();
            BigTableWriter.this.writeMetadata(BigTableWriter.this.descriptor, BigTableWriter.this.finalizeMetadata());
            BigTableWriter.appendTOC(BigTableWriter.this.descriptor, BigTableWriter.this.components);
            if (this.openResult) {
                this.finalReader = BigTableWriter.this.openFinal(SSTableReader.OpenReason.NORMAL);
            }
        }

        @Override
        protected Throwable doCommit(Throwable accumulate) {
            accumulate = BigTableWriter.this.dataFile.commit(accumulate);
            accumulate = BigTableWriter.this.iwriter.commit(accumulate);
            return accumulate;
        }

        @Override
        protected Throwable doPostCleanup(Throwable accumulate) {
            accumulate = BigTableWriter.this.dbuilder.close(accumulate);
            return accumulate;
        }

        @Override
        protected Throwable doAbort(Throwable accumulate) {
            accumulate = BigTableWriter.this.iwriter.abort(accumulate);
            accumulate = BigTableWriter.this.dataFile.abort(accumulate);
            return accumulate;
        }
    }

    private static class StatsCollector
    extends Transformation {
        private final MetadataCollector collector;
        private int cellCount;

        StatsCollector(MetadataCollector collector) {
            this.collector = collector;
        }

        @Override
        public Row applyToStatic(Row row) {
            if (!row.isEmpty()) {
                this.cellCount += Rows.collectStats(row, this.collector);
            }
            return row;
        }

        @Override
        public Row applyToRow(Row row) {
            this.collector.updateClusteringValues(row.clustering());
            this.cellCount += Rows.collectStats(row, this.collector);
            return row;
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            this.collector.updateClusteringValues(marker.clustering());
            if (marker.isBoundary()) {
                RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
                this.collector.update(bm.endDeletionTime());
                this.collector.update(bm.startDeletionTime());
            } else {
                this.collector.update(((RangeTombstoneBoundMarker)marker).deletionTime());
            }
            return marker;
        }

        @Override
        public void onPartitionClose() {
            this.collector.addCellPerPartitionCount(this.cellCount);
        }

        @Override
        public DeletionTime applyToDeletion(DeletionTime deletionTime) {
            this.collector.update(deletionTime);
            return deletionTime;
        }
    }
}

