/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import org.apache.dubbo.common.utils.Assert;
import org.springframework.core.env.PropertyResolver;
import org.springframework.lang.Nullable;

class DelegatingPropertyResolver
implements PropertyResolver {
    private final PropertyResolver delegate;

    DelegatingPropertyResolver(PropertyResolver delegate) {
        Assert.notNull((Object)delegate, (String)"The delegate of PropertyResolver must not be null");
        this.delegate = delegate;
    }

    public boolean containsProperty(String key) {
        return this.delegate.containsProperty(key);
    }

    @Nullable
    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    @Nullable
    public <T> T getProperty(String key, Class<T> targetType) {
        return (T)this.delegate.getProperty(key, targetType);
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)this.delegate.getProperty(key, targetType, defaultValue);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.delegate.getRequiredProperty(key);
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return (T)this.delegate.getRequiredProperty(key, targetType);
    }

    public String resolvePlaceholders(String text) {
        return this.delegate.resolvePlaceholders(text);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.delegate.resolveRequiredPlaceholders(text);
    }
}

