/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import org.apache.maven.project.MavenProject;

final class ArtifactKey {
    private static final int HASH_PRIME = 31;
    private final String groupId;
    private final String artifactId;
    private final String version;

    ArtifactKey(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public ArtifactKey(MavenProject project) {
        this(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey that = (ArtifactKey)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

