/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.introspection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.introspection.ClassMap;
import org.apache.maven.shared.utils.introspection.IntrospectionException;
import org.apache.maven.shared.utils.introspection.MethodMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionValueExtractor {
    private static final Class<?>[] CLASS_ARGS = new Class[0];
    private static final Object[] OBJECT_ARGS = new Object[0];
    private static final Map<Class<?>, ClassMap> classMaps = new WeakHashMap();
    private static final Pattern INDEXED_PROPS = Pattern.compile("(\\w+)\\[(\\d+)\\]");
    private static final Pattern MAPPED_PROPS = Pattern.compile("(\\w+)\\((.+)\\)");

    private ReflectionValueExtractor() {
    }

    public static Object evaluate(@Nonnull String expression, @Nullable Object root) throws IntrospectionException {
        return ReflectionValueExtractor.evaluate(expression, root, true);
    }

    public static Object evaluate(@Nonnull String expression, @Nullable Object root, boolean trimRootToken) throws IntrospectionException {
        if (trimRootToken) {
            expression = expression.substring(expression.indexOf(46) + 1);
        }
        List<Object> value = root;
        StringTokenizer parser = new StringTokenizer(expression, ".");
        while (parser.hasMoreTokens()) {
            Method method;
            String methodName;
            String methodBase;
            if (value == null) {
                return null;
            }
            String token = parser.nextToken();
            ClassMap classMap = ReflectionValueExtractor.getClassMap(value.getClass());
            Object[] localParams = OBJECT_ARGS;
            Matcher matcher = INDEXED_PROPS.matcher(token);
            if (matcher.find()) {
                methodBase = StringUtils.capitalizeFirstLetter(matcher.group(1));
                methodName = "get" + methodBase;
                try {
                    method = classMap.findMethod(methodName, CLASS_ARGS);
                }
                catch (MethodMap.AmbiguousException e) {
                    throw new IntrospectionException(e);
                }
                try {
                    value = method.invoke((Object)value, OBJECT_ARGS);
                }
                catch (IllegalArgumentException e) {
                    throw new IntrospectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IntrospectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IntrospectionException(e);
                }
                classMap = ReflectionValueExtractor.getClassMap(value.getClass());
                if (classMap.getCachedClass().isArray()) {
                    value = Arrays.asList((Object[])value);
                    classMap = ReflectionValueExtractor.getClassMap(value.getClass());
                }
                if (value instanceof List) {
                    localParams = new Object[]{Integer.valueOf(matcher.group(2))};
                    try {
                        method = classMap.findMethod("get", localParams);
                    }
                    catch (MethodMap.AmbiguousException e) {
                        throw new IntrospectionException(e);
                    }
                }
                throw new IntrospectionException("The token '" + token + "' refers to a java.util.List or an array, but the value seems is an instance of '" + value.getClass() + "'.");
            }
            matcher = MAPPED_PROPS.matcher(token);
            if (matcher.find()) {
                methodBase = StringUtils.capitalizeFirstLetter(matcher.group(1));
                methodName = "get" + methodBase;
                try {
                    method = classMap.findMethod(methodName, CLASS_ARGS);
                }
                catch (MethodMap.AmbiguousException e) {
                    throw new IntrospectionException(e);
                }
                try {
                    value = method.invoke((Object)value, OBJECT_ARGS);
                }
                catch (IllegalArgumentException e) {
                    throw new IntrospectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IntrospectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IntrospectionException(e);
                }
                classMap = ReflectionValueExtractor.getClassMap(value.getClass());
                if (value instanceof Map) {
                    localParams = new Object[]{matcher.group(2)};
                    try {
                        method = classMap.findMethod("get", localParams);
                    }
                    catch (MethodMap.AmbiguousException e) {
                        throw new IntrospectionException(e);
                    }
                }
                throw new IntrospectionException("The token '" + token + "' refers to a java.util.Map, but the value seems is an instance of '" + value.getClass() + "'.");
            }
            methodBase = StringUtils.capitalizeFirstLetter(token);
            methodName = "get" + methodBase;
            try {
                method = classMap.findMethod(methodName, CLASS_ARGS);
            }
            catch (MethodMap.AmbiguousException e) {
                throw new IntrospectionException(e);
            }
            if (method == null) {
                methodName = "is" + methodBase;
                try {
                    method = classMap.findMethod(methodName, CLASS_ARGS);
                }
                catch (MethodMap.AmbiguousException e) {
                    throw new IntrospectionException(e);
                }
            }
            if (method == null) {
                return null;
            }
            try {
                value = method.invoke((Object)value, localParams);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IndexOutOfBoundsException) {
                    return null;
                }
                throw new IntrospectionException(e);
            }
            catch (IllegalArgumentException e) {
                throw new IntrospectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new IntrospectionException(e);
            }
        }
        return value;
    }

    private static ClassMap getClassMap(Class<?> clazz) {
        ClassMap classMap = classMaps.get(clazz);
        if (classMap == null) {
            classMap = new ClassMap(clazz);
            classMaps.put(clazz, classMap);
        }
        return classMap;
    }
}

