/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.surefire.ClasspathCache;
import org.apache.maven.plugin.surefire.ConfigurableProviderInfo;
import org.apache.maven.plugin.surefire.InPluginVMSurefireStarter;
import org.apache.maven.plugin.surefire.JdkAttributes;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.SurefireDependencyResolver;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.TestClassPath;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.booterclient.ClasspathForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkStarter;
import org.apache.maven.plugin.surefire.booterclient.JarManifestForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ModularClasspathForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.Platform;
import org.apache.maven.plugin.surefire.booterclient.ProviderDetector;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.util.DependencyScanner;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ModularClasspath;
import org.apache.maven.surefire.booter.ModularClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemUtils;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.shade.common.org.apache.commons.lang3.StringUtils;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestListResolver;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.apache.maven.surefire.util.RunOrder;
import org.apache.maven.toolchain.DefaultToolchain;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractSurefireMojo
extends AbstractMojo
implements SurefireExecutionParameters {
    private static final String FORK_ONCE = "once";
    private static final String FORK_ALWAYS = "always";
    private static final String FORK_NEVER = "never";
    private static final String FORK_PERTHREAD = "perthread";
    private static final Map<String, String> JAVA_9_MATCHER_OLD_NOTATION = Collections.singletonMap("version", "[1.9,)");
    private static final Map<String, String> JAVA_9_MATCHER = Collections.singletonMap("version", "[9,)");
    private static final Platform PLATFORM = new Platform();
    private final ProviderDetector providerDetector = new ProviderDetector();
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(property="skipTests", defaultValue="false")
    protected boolean skipTests;
    @Deprecated
    @Parameter(property="maven.test.skip.exec")
    protected boolean skipExec;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}")
    protected File basedir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testClassesDirectory;
    @Parameter(property="maven.test.dependency.excludes")
    private String[] classpathDependencyExcludes;
    @Parameter(defaultValue="")
    private String classpathDependencyScopeExclude;
    @Parameter(property="maven.test.additionalClasspath")
    private String[] additionalClasspathElements;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", required=true)
    private File testSourceDirectory;
    @Parameter
    private List<String> excludes;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Deprecated
    @Parameter
    private Properties systemProperties;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter
    private File systemPropertiesFile;
    @Parameter
    private Properties properties;
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Parameter(property="project.artifactMap", readonly=true, required=true)
    private Map<String, Artifact> projectArtifactMap;
    @Parameter(property="surefire.reportNameSuffix", defaultValue="")
    private String reportNameSuffix;
    @Parameter(property="maven.test.redirectTestOutputToFile", defaultValue="false")
    private boolean redirectTestOutputToFile;
    @Parameter(property="failIfNoTests")
    private Boolean failIfNoTests;
    @Parameter(property="forkMode", defaultValue="once")
    private String forkMode;
    @Parameter(property="tempDir", defaultValue="surefire")
    private String tempDir;
    @Parameter(property="jvm")
    private String jvm;
    @Parameter(property="argLine")
    private String argLine;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="basedir")
    private File workingDirectory;
    @Parameter(property="childDelegation", defaultValue="false")
    private boolean childDelegation;
    @Parameter(property="groups")
    private String groups;
    @Parameter(property="excludedGroups")
    private String excludedGroups;
    @Parameter(property="junitArtifactName", defaultValue="junit:junit")
    private String junitArtifactName;
    @Parameter(property="junitPlatformArtifactName", defaultValue="org.junit.platform:junit-platform-engine")
    private String junitPlatformArtifactName;
    @Parameter(property="testNGArtifactName", defaultValue="org.testng:testng")
    private String testNGArtifactName;
    @Parameter(property="threadCount")
    private int threadCount;
    @Parameter(property="forkCount", defaultValue="1")
    private String forkCount;
    @Parameter(property="reuseForks", defaultValue="true")
    private boolean reuseForks;
    @Parameter(property="perCoreThreadCount", defaultValue="true")
    private boolean perCoreThreadCount;
    @Parameter(property="useUnlimitedThreads", defaultValue="false")
    private boolean useUnlimitedThreads;
    @Parameter(property="parallel")
    private String parallel;
    @Parameter(property="parallelOptimized", defaultValue="true")
    private boolean parallelOptimized;
    @Parameter(property="threadCountSuites", defaultValue="0")
    private int threadCountSuites;
    @Parameter(property="threadCountClasses", defaultValue="0")
    private int threadCountClasses;
    @Parameter(property="threadCountMethods", defaultValue="0")
    private int threadCountMethods;
    @Parameter(property="trimStackTrace", defaultValue="true")
    private boolean trimStackTrace;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="disableXmlReport", defaultValue="false")
    private boolean disableXmlReport;
    @Parameter(property="enableAssertions", defaultValue="true")
    private boolean enableAssertions;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private Logger logger;
    @Parameter(property="objectFactory")
    private String objectFactory;
    @Parameter(defaultValue="${session.parallel}", readonly=true)
    private Boolean parallelMavenExecution;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File projectBuildDirectory;
    @Parameter(property="dependenciesToScan")
    private String[] dependenciesToScan;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private LocationManager locationManager;
    @Component
    private RepositorySystem repositorySystem;
    private Artifact surefireBooterArtifact;
    private Toolchain toolchain;
    private int effectiveForkCount = -1;
    private SurefireDependencyResolver dependencyResolver;
    private TestListResolver specificTests;
    private TestListResolver includedExcludedTests;
    private List<CommandLineOption> cli;
    private volatile PluginConsoleLogger consoleLogger;

    protected abstract String getPluginName();

    protected abstract int getRerunFailingTestsCount();

    @Override
    public abstract List<String> getIncludes();

    public abstract File getIncludesFile();

    @Override
    public abstract void setIncludes(List<String> var1);

    public abstract File getExcludesFile();

    protected abstract List<File> suiteXmlFiles();

    protected abstract boolean hasSuiteXmlFiles();

    public abstract File[] getSuiteXmlFiles();

    public abstract void setSuiteXmlFiles(File[] var1);

    public abstract String getRunOrder();

    public abstract void setRunOrder(String var1);

    protected abstract void handleSummary(RunResult var1, Exception var2) throws MojoExecutionException, MojoFailureException;

    protected abstract boolean isSkipExecution();

    protected abstract String[] getDefaultIncludes();

    protected abstract String getReportSchemaLocation();

    protected Artifact getMojoArtifact() {
        return this.pluginDescriptor.getPluginArtifact();
    }

    private String getDefaultExcludes() {
        return "**/*$*";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.cli = this.commandLineOptions();
        this.setupStuff();
        if (this.verifyParameters() && !this.hasExecutedBefore()) {
            DefaultScanResult scan = this.scanForTestClasses();
            if (!this.hasSuiteXmlFiles() && scan.isEmpty()) {
                if (this.getEffectiveFailIfNoTests()) {
                    throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
                }
                this.handleSummary(RunResult.noTestsRun(), null);
                return;
            }
            this.logReportsDirectory();
            this.executeAfterPreconditionsChecked(scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected final PluginConsoleLogger getConsoleLogger() {
        if (this.consoleLogger == null) {
            AbstractSurefireMojo abstractSurefireMojo = this;
            synchronized (abstractSurefireMojo) {
                if (this.consoleLogger == null) {
                    this.consoleLogger = new PluginConsoleLogger(this.logger);
                }
            }
        }
        return this.consoleLogger;
    }

    private void setupStuff() {
        this.createDependencyResolver();
        this.surefireBooterArtifact = this.getSurefireBooterArtifact();
        this.toolchain = this.getToolchain();
    }

    @Nonnull
    private DefaultScanResult scanForTestClasses() throws MojoFailureException {
        DefaultScanResult scan = this.scanDirectories();
        DefaultScanResult scanDeps = this.scanDependencies();
        return scan.append(scanDeps);
    }

    private DefaultScanResult scanDirectories() throws MojoFailureException {
        DirectoryScanner scanner = new DirectoryScanner(this.getTestClassesDirectory(), this.getIncludedAndExcludedTests());
        return scanner.scan();
    }

    List<Artifact> getProjectTestArtifacts() {
        return this.project.getTestArtifacts();
    }

    DefaultScanResult scanDependencies() throws MojoFailureException {
        if (this.getDependenciesToScan() == null) {
            return null;
        }
        try {
            DefaultScanResult result = null;
            List<Artifact> dependenciesToScan = DependencyScanner.filter(this.getProjectTestArtifacts(), Arrays.asList(this.getDependenciesToScan()));
            for (Artifact artifact : dependenciesToScan) {
                Object scanner;
                String type = artifact.getType();
                File out = artifact.getFile();
                if (out == null || !out.exists() || !"jar".equals(type) && !out.isDirectory() && !out.getName().endsWith(".jar")) continue;
                if (out.isFile()) {
                    scanner = new DependencyScanner(Collections.singletonList(out), this.getIncludedAndExcludedTests());
                    result = result == null ? ((DependencyScanner)scanner).scan() : result.append(((DependencyScanner)scanner).scan());
                    continue;
                }
                if (!out.isDirectory()) continue;
                scanner = new DirectoryScanner(out, this.getIncludedAndExcludedTests());
                result = result == null ? ((DirectoryScanner)scanner).scan() : result.append(((DirectoryScanner)scanner).scan());
            }
            return result;
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    boolean verifyParameters() throws MojoFailureException, MojoExecutionException {
        this.setProperties(new SurefireProperties(this.getProperties()));
        if (this.isSkipExecution()) {
            this.getConsoleLogger().info("Tests are skipped.");
            return false;
        }
        String jvmToUse = this.getJvm();
        if (this.toolchain != null) {
            this.getConsoleLogger().info("Toolchain in maven-" + this.getPluginName() + "-plugin: " + this.toolchain);
            if (jvmToUse != null) {
                this.getConsoleLogger().warning("Toolchains are ignored, 'jvm' parameter is set to " + jvmToUse);
            }
        }
        if (!(this.getTestClassesDirectory().exists() || this.getDependenciesToScan() != null && this.getDependenciesToScan().length != 0)) {
            if (Boolean.TRUE.equals(this.getFailIfNoTests())) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getConsoleLogger().info("No tests to run.");
        } else {
            this.convertDeprecatedForkMode();
            this.ensureWorkingDirectoryExists();
            this.ensureParallelRunningCompatibility();
            this.ensureThreadCountWithPerThread();
            this.warnIfUselessUseSystemClassLoaderParameter();
            this.warnIfDefunctGroupsCombinations();
            this.warnIfRerunClashes();
            this.warnIfWrongShutdownValue();
            this.warnIfNotApplicableSkipAfterFailureCount();
            this.warnIfIllegalTempDir();
        }
        return true;
    }

    private void executeAfterPreconditionsChecked(@Nonnull DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        List<ProviderInfo> providers = this.createProviders();
        RunResult current = RunResult.noTestsRun();
        Throwable firstForkException = null;
        for (ProviderInfo provider : providers) {
            try {
                current = current.aggregate(this.executeProvider(provider, scanResult));
            }
            catch (SurefireBooterForkException | SurefireExecutionException | TestSetFailedException e) {
                if (firstForkException != null) continue;
                firstForkException = e;
            }
        }
        if (firstForkException != null) {
            current = RunResult.failure((RunResult)current, firstForkException);
        }
        this.handleSummary(current, (Exception)firstForkException);
    }

    private void createDependencyResolver() {
        this.dependencyResolver = new SurefireDependencyResolver(this.getRepositorySystem(), this.getArtifactFactory(), this.getConsoleLogger(), this.getLocalRepository(), this.getRemoteRepositories(), this.getPluginName());
    }

    protected List<ProviderInfo> createProviders() throws MojoExecutionException {
        Artifact junitDepArtifact = this.getJunitDepArtifact();
        return new ProviderList(new DynamicProviderInfo(null), new TestNgProviderInfo(this.getTestNgArtifact()), new JUnitPlatformProviderInfo(this.getJunitPlatformArtifact()), new JUnitCoreProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit4ProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit3ProviderInfo()).resolve();
    }

    private SurefireProperties setupProperties() {
        SurefireProperties sysProps = null;
        try {
            sysProps = SurefireProperties.loadProperties(this.systemPropertiesFile);
        }
        catch (IOException e) {
            String msg = "The system property file '" + this.systemPropertiesFile.getAbsolutePath() + "' can't be read.";
            if (this.getConsoleLogger().isDebugEnabled()) {
                this.getConsoleLogger().debug(msg, e);
            }
            this.getConsoleLogger().warning(msg);
        }
        SurefireProperties result = SurefireProperties.calculateEffectiveProperties(this.getSystemProperties(), this.getSystemPropertyVariables(), this.getUserProperties(), sysProps);
        result.setProperty("basedir", this.getBasedir().getAbsolutePath());
        result.setProperty("user.dir", this.getWorkingDirectory().getAbsolutePath());
        result.setProperty("localRepository", this.getLocalRepository().getBasedir());
        if (this.isForking()) {
            for (Object o : result.propertiesThatCannotBeSetASystemProperties()) {
                if (this.getArgLine() != null && this.getArgLine().contains("-D" + o + "=")) continue;
                this.getConsoleLogger().warning(o + " cannot be set as system property, use <argLine>-D" + o + "=...</argLine> instead");
            }
            for (Object systemPropertyMatchingArgLine : this.systemPropertiesMatchingArgLine(result)) {
                this.getConsoleLogger().warning("The system property " + systemPropertyMatchingArgLine + " is configured twice! The property appears in <argLine/> and any of <systemPropertyVariables/>, <systemProperties/> or user property.");
            }
        }
        if (this.getConsoleLogger().isDebugEnabled()) {
            this.showToLog(result, this.getConsoleLogger());
        }
        return result;
    }

    private Set<Object> systemPropertiesMatchingArgLine(SurefireProperties result) {
        HashSet<Object> intersection = new HashSet<Object>();
        if (org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils.isNotBlank(this.getArgLine())) {
            for (Object systemProperty : result.getStringKeySet()) {
                if (!this.getArgLine().contains("-D" + systemProperty + "=")) continue;
                intersection.add(systemProperty);
            }
            Set<Object> ignored = result.propertiesThatCannotBeSetASystemProperties();
            intersection.removeAll(ignored);
        }
        return intersection;
    }

    private void showToLog(SurefireProperties props, ConsoleLogger log) {
        for (Object key : props.getStringKeySet()) {
            String value = props.getProperty((String)key);
            log.debug("Setting system property [" + key + "]=[" + value + "]");
        }
    }

    @Nonnull
    private RunResult executeProvider(@Nonnull ProviderInfo provider, @Nonnull DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException, SurefireExecutionException, SurefireBooterForkException, TestSetFailedException {
        SurefireProperties effectiveProperties = this.setupProperties();
        ClassLoaderConfiguration classLoaderConfiguration = this.getClassLoaderConfiguration();
        provider.addProviderProperties();
        RunOrderParameters runOrderParameters = new RunOrderParameters(this.getRunOrder(), this.getStatisticsFile(this.getConfigChecksum()));
        if (this.isNotForking()) {
            AbstractSurefireMojo.createCopyAndReplaceForkNumPlaceholder(effectiveProperties, 1).copyToSystemProperties();
            InPluginVMSurefireStarter surefireStarter = this.createInprocessStarter(provider, classLoaderConfiguration, runOrderParameters, scanResult);
            return surefireStarter.runSuitesInProcess(scanResult);
        }
        ForkConfiguration forkConfiguration = this.getForkConfiguration();
        if (this.getConsoleLogger().isDebugEnabled()) {
            this.showMap(this.getEnvironmentVariables(), "environment variable");
        }
        Properties originalSystemProperties = (Properties)System.getProperties().clone();
        ForkStarter forkStarter = null;
        try {
            forkStarter = this.createForkStarter(provider, forkConfiguration, classLoaderConfiguration, runOrderParameters, this.getConsoleLogger(), scanResult);
            RunResult runResult = forkStarter.run(effectiveProperties, scanResult);
            return runResult;
        }
        catch (SurefireBooterForkException e) {
            forkStarter.killOrphanForks();
            throw e;
        }
        finally {
            System.setProperties(originalSystemProperties);
            this.cleanupForkConfiguration(forkConfiguration);
        }
    }

    public static SurefireProperties createCopyAndReplaceForkNumPlaceholder(SurefireProperties effectiveSystemProperties, int threadNumber) {
        SurefireProperties filteredProperties = new SurefireProperties(effectiveSystemProperties);
        for (Map.Entry<Object, Object> entry : effectiveSystemProperties.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String value = (String)entry.getValue();
            filteredProperties.put(entry.getKey(), SurefireHelper.replaceThreadNumberPlaceholders(value, threadNumber));
        }
        return filteredProperties;
    }

    protected void cleanupForkConfiguration(ForkConfiguration forkConfiguration) {
        if (!this.getConsoleLogger().isDebugEnabled() && forkConfiguration != null) {
            File tempDirectory = forkConfiguration.getTempDirectory();
            try {
                FileUtils.deleteDirectory(tempDirectory);
            }
            catch (IOException e) {
                this.getConsoleLogger().warning("Could not delete temp directory " + tempDirectory + " because " + e.getMessage());
            }
        }
    }

    protected void logReportsDirectory() {
        this.logDebugOrCliShowErrors(org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils.capitalizeFirstLetter(this.getPluginName()) + " report directory: " + this.getReportsDirectory());
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public void setRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.getToolchainManager() != null) {
            tc = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession());
        }
        return tc;
    }

    private boolean existsModuleDescriptor() {
        return this.getModuleDescriptor().isFile();
    }

    private File getModuleDescriptor() {
        return new File(this.getClassesDirectory(), "module-info.class");
    }

    private void convertTestNGParameters() throws MojoExecutionException {
        Artifact testNgArtifact;
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        this.convertGroupParameters();
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        if (this.getObjectFactory() != null) {
            this.getProperties().setProperty("objectfactory", this.getObjectFactory());
        }
        if (this.getTestClassesDirectory() != null) {
            this.getProperties().setProperty("testng.test.classpath", this.getTestClassesDirectory().getAbsolutePath());
        }
        if ((testNgArtifact = this.getTestNgArtifact()) != null) {
            DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(testNgArtifact.getVersion());
            this.getProperties().setProperty("testng.configurator", AbstractSurefireMojo.getConfiguratorName((ArtifactVersion)defaultArtifactVersion, this.getConsoleLogger()));
        }
    }

    private static String getConfiguratorName(ArtifactVersion version, PluginConsoleLogger log) throws MojoExecutionException {
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,5.2)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG4751Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.2,5.3)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG52Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.3,5.10)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNGMapConfigurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.10,5.13)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG510Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.13,5.14.1)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG513Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.14.1,5.14.3)");
            if (range.containsVersion(version)) {
                log.warning("The 'reporter' or 'listener' may not work properly in TestNG 5.14.1 and 5.14.2.");
                return "org.apache.maven.surefire.testng.conf.TestNG5141Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[5.14.3,6.0)");
            if (range.containsVersion(version)) {
                if (version.equals(new DefaultArtifactVersion("[5.14.3,5.14.5]"))) {
                    throw new MojoExecutionException("TestNG 5.14.3-5.14.5 is not supported. System dependency org.testng:guice missed path.");
                }
                return "org.apache.maven.surefire.testng.conf.TestNG5143Configurator";
            }
            range = VersionRange.createFromVersionSpec((String)"[6.0,)");
            if (range.containsVersion(version)) {
                return "org.apache.maven.surefire.testng.conf.TestNG60Configurator";
            }
            throw new MojoExecutionException("Unknown TestNG version " + version);
        }
        catch (InvalidVersionSpecificationException invsex) {
            throw new MojoExecutionException("Bug in plugin. Please report it with the attached stacktrace", (Exception)((Object)invsex));
        }
    }

    private void convertGroupParameters() {
        if (this.getExcludedGroups() != null) {
            this.getProperties().setProperty("excludegroups", this.getExcludedGroups());
        }
        if (this.getGroups() != null) {
            this.getProperties().setProperty("groups", this.getGroups());
        }
    }

    protected boolean isAnyConcurrencySelected() {
        return this.getParallel() != null && !this.getParallel().trim().isEmpty();
    }

    protected boolean isAnyGroupsSelected() {
        return this.getGroups() != null || this.getExcludedGroups() != null;
    }

    private void convertJunitCoreParameters() throws MojoExecutionException {
        String usedParallel;
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountSuites(), "suites");
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountClasses(), "classes");
        AbstractSurefireMojo.checkThreadCountEntity(this.getThreadCountMethods(), "methods");
        String string = usedParallel = this.getParallel() != null ? this.getParallel() : "none";
        if (!"none".equals(usedParallel)) {
            this.checkNonForkedThreads(this.parallel);
        }
        this.getProperties().setProperty("parallel", usedParallel);
        this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        this.getProperties().setProperty("perCoreThreadCount", Boolean.toString(this.getPerCoreThreadCount()));
        this.getProperties().setProperty("useUnlimitedThreads", Boolean.toString(this.getUseUnlimitedThreads()));
        this.getProperties().setProperty("threadcountsuites", Integer.toString(this.getThreadCountSuites()));
        this.getProperties().setProperty("threadcountclasses", Integer.toString(this.getThreadCountClasses()));
        this.getProperties().setProperty("threadcountmethods", Integer.toString(this.getThreadCountMethods()));
        this.getProperties().setProperty("paralleltimeout", Double.toString(this.getParallelTestsTimeoutInSeconds()));
        this.getProperties().setProperty("paralleltimeoutforced", Double.toString(this.getParallelTestsTimeoutForcedInSeconds()));
        this.getProperties().setProperty("paralleloptimization", Boolean.toString(this.isParallelOptimized()));
        String message = "parallel='" + usedParallel + '\'' + ", perCoreThreadCount=" + this.getPerCoreThreadCount() + ", threadCount=" + this.getThreadCount() + ", useUnlimitedThreads=" + this.getUseUnlimitedThreads() + ", threadCountSuites=" + this.getThreadCountSuites() + ", threadCountClasses=" + this.getThreadCountClasses() + ", threadCountMethods=" + this.getThreadCountMethods() + ", parallelOptimized=" + this.isParallelOptimized();
        this.logDebugOrCliShowErrors(message);
    }

    private void checkNonForkedThreads(String parallel) throws MojoExecutionException {
        if ("suites".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountSuites() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountSuites > 0 or useUnlimitedThreads=true for parallel='suites'");
            }
            this.setThreadCountClasses(0);
            this.setThreadCountMethods(0);
        } else if ("classes".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountClasses() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountClasses > 0 or useUnlimitedThreads=true for parallel='classes'");
            }
            this.setThreadCountSuites(0);
            this.setThreadCountMethods(0);
        } else if ("methods".equals(parallel)) {
            if (!this.getUseUnlimitedThreads() && !(this.getThreadCount() > 0 ^ this.getThreadCountMethods() > 0)) {
                throw new MojoExecutionException("Use threadCount or threadCountMethods > 0 or useUnlimitedThreads=true for parallel='methods'");
            }
            this.setThreadCountSuites(0);
            this.setThreadCountClasses(0);
        } else if ("suitesAndClasses".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCount() == 0 && this.getThreadCountMethods() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCount() > this.getThreadCountSuites() && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountClasses > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCountClasses > 0) or (threadCount > 0 and threadCountSuites > 0 and threadCount > threadCountSuites) for parallel='suitesAndClasses' or 'both'");
            }
            this.setThreadCountMethods(0);
        } else if ("suitesAndMethods".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCount() == 0 && this.getThreadCountClasses() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCountClasses() == 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCount() > this.getThreadCountSuites() && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountSuites > 0 and threadCount > threadCountSuites) for parallel='suitesAndMethods'");
            }
            this.setThreadCountClasses(0);
        } else if ("both".equals(parallel) || "classesAndMethods".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCount() == 0 && this.getThreadCountSuites() == 0 || this.getThreadCount() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 && this.getThreadCountSuites() == 0 || this.getThreadCount() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCount() > this.getThreadCountClasses() && this.getThreadCountSuites() == 0 && this.getThreadCountMethods() == 0)) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountClasses > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountClasses > 0 and threadCountMethods > 0), or (threadCount > 0 and threadCountClasses > 0 and threadCount > threadCountClasses) for parallel='both' or parallel='classesAndMethods'");
            }
            this.setThreadCountSuites(0);
        } else if ("all".equals(parallel)) {
            if (!(this.getUseUnlimitedThreads() || this.onlyThreadCount() || this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() > 0 || this.getThreadCount() > 0 && this.getThreadCountSuites() > 0 && this.getThreadCountClasses() > 0 && this.getThreadCountMethods() == 0 && this.getThreadCount() > this.getThreadCountSuites() + this.getThreadCountClasses())) {
                throw new MojoExecutionException("Use useUnlimitedThreads=true, or only threadCount > 0, or (threadCountSuites > 0 and threadCountClasses > 0 and threadCountMethods > 0), or every thread-count is specified, or (threadCount > 0 and threadCountSuites > 0 and threadCountClasses > 0 and threadCount > threadCountSuites + threadCountClasses) for parallel='all'");
            }
        } else {
            throw new MojoExecutionException("Illegal parallel='" + parallel + "'");
        }
    }

    private boolean onlyThreadCount() {
        return this.getThreadCount() > 0 && this.getThreadCountSuites() == 0 && this.getThreadCountClasses() == 0 && this.getThreadCountMethods() == 0;
    }

    private static void checkThreadCountEntity(int count, String entity) throws MojoExecutionException {
        if (count < 0) {
            throw new MojoExecutionException("parallel maven execution does not allow negative thread-count" + entity);
        }
    }

    private boolean isJunit47Compatible(Artifact artifact) {
        return SurefireDependencyResolver.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) {
        return SurefireDependencyResolver.isWithinVersionSpec(artifact, "[4.0,)");
    }

    private static boolean isForkModeNever(String forkMode) {
        return FORK_NEVER.equals(forkMode);
    }

    protected boolean isForking() {
        return 0 < this.getEffectiveForkCount();
    }

    String getEffectiveForkMode() {
        String forkMode1 = this.getForkMode();
        if (this.toolchain != null && AbstractSurefireMojo.isForkModeNever(forkMode1)) {
            return FORK_ONCE;
        }
        return AbstractSurefireMojo.getEffectiveForkMode(forkMode1);
    }

    private List<RunOrder> getRunOrders() {
        String runOrderString = this.getRunOrder();
        RunOrder[] runOrder = runOrderString == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti((String)runOrderString);
        return Arrays.asList(runOrder);
    }

    private boolean requiresRunHistory() {
        List<RunOrder> runOrders = this.getRunOrders();
        return runOrders.contains(RunOrder.BALANCED) || runOrders.contains(RunOrder.FAILEDFIRST);
    }

    private boolean getEffectiveFailIfNoTests() {
        if (this.isSpecificTestSpecified()) {
            if (this.getFailIfNoSpecifiedTests() != null) {
                return this.getFailIfNoSpecifiedTests();
            }
            if (this.getFailIfNoTests() != null) {
                return this.getFailIfNoTests();
            }
            return true;
        }
        return this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
    }

    private ProviderConfiguration createProviderConfiguration(RunOrderParameters runOrderParameters) throws MojoExecutionException, MojoFailureException {
        boolean actualFailIfNoTests;
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(this.getReportsDirectory(), this.isTrimStackTrace());
        Artifact testNgArtifact = this.getTestNgArtifact();
        boolean isTestNg = testNgArtifact != null;
        TestArtifactInfo testNg = isTestNg ? new TestArtifactInfo(testNgArtifact.getVersion(), testNgArtifact.getClassifier()) : null;
        TestRequest testSuiteDefinition = new TestRequest(this.suiteXmlFiles(), this.getTestSourceDirectory(), this.getSpecificTests(), this.getRerunFailingTestsCount());
        DirectoryScannerParameters directoryScannerParameters = null;
        if (this.hasSuiteXmlFiles() && !this.isSpecificTestSpecified()) {
            boolean bl = actualFailIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            if (!isTestNg) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
        } else {
            if (this.isSpecificTestSpecified()) {
                actualFailIfNoTests = this.getEffectiveFailIfNoTests();
                this.setFailIfNoTests(actualFailIfNoTests);
            } else {
                actualFailIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            }
            List<String> actualIncludes = this.getIncludeList();
            List<String> actualExcludes = this.getExcludeList();
            List specificTests = Collections.emptyList();
            directoryScannerParameters = new DirectoryScannerParameters(this.getTestClassesDirectory(), actualIncludes, actualExcludes, specificTests, actualFailIfNoTests, this.getRunOrder());
        }
        Map<String, String> providerProperties = AbstractSurefireMojo.toStringProperties(this.getProperties());
        return new ProviderConfiguration(directoryScannerParameters, runOrderParameters, actualFailIfNoTests, reporterConfiguration, testNg, testSuiteDefinition, providerProperties, null, false, this.cli, this.getSkipAfterFailureCount(), Shutdown.parameterOf((String)this.getShutdown()), Integer.valueOf(this.getForkedProcessExitTimeoutInSeconds()));
    }

    private static Map<String, String> toStringProperties(Properties properties) {
        ConcurrentHashMap<String, String> h = new ConcurrentHashMap<String, String>(properties.size());
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            Object v = properties.get(k);
            if (k.getClass() != String.class || v.getClass() != String.class) continue;
            h.put((String)k, (String)v);
        }
        return h;
    }

    public File getStatisticsFile(String configurationHash) {
        return new File(this.getBasedir(), ".surefire-" + configurationHash);
    }

    private StartupConfiguration createStartupConfiguration(@Nonnull ProviderInfo provider, boolean isInprocess, @Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull DefaultScanResult scanResult) throws MojoExecutionException {
        try {
            File moduleDescriptor = this.getModuleDescriptor();
            Set<Artifact> providerArtifacts = provider.getProviderClasspath();
            String providerName = provider.getProviderName();
            if (moduleDescriptor.exists() && !isInprocess) {
                return this.newStartupConfigWithModularPath(classLoaderConfiguration, providerArtifacts, providerName, moduleDescriptor, scanResult);
            }
            return this.newStartupConfigWithClasspath(classLoaderConfiguration, providerArtifacts, providerName);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private StartupConfiguration newStartupConfigWithClasspath(@Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull Set<Artifact> providerArtifacts, @Nonnull String providerName) {
        TestClassPath testClasspathWrapper = this.generateTestClasspath();
        Classpath testClasspath = testClasspathWrapper.toClasspath();
        testClasspathWrapper.avoidArtifactDuplicates(providerArtifacts);
        Classpath providerClasspath = ClasspathCache.getCachedClassPath(providerName);
        if (providerClasspath == null) {
            providerClasspath = ClasspathCache.setCachedClasspath(providerName, providerArtifacts);
        }
        this.getConsoleLogger().debug(testClasspath.getLogMessage("test classpath:"));
        this.getConsoleLogger().debug(providerClasspath.getLogMessage("provider classpath:"));
        this.getConsoleLogger().debug(testClasspath.getCompactLogMessage("test(compact) classpath:"));
        this.getConsoleLogger().debug(providerClasspath.getCompactLogMessage("provider(compact) classpath:"));
        Artifact[] additionalInProcArtifacts = new Artifact[]{this.getCommonArtifact(), this.getApiArtifact(), this.getLoggerApiArtifact()};
        Set<Artifact> inProcArtifacts = AbstractSurefireMojo.retainInProcArtifactsUnique(providerArtifacts, additionalInProcArtifacts);
        Classpath inProcClasspath = AbstractSurefireMojo.createInProcClasspath(providerClasspath, inProcArtifacts);
        this.getConsoleLogger().debug(inProcClasspath.getLogMessage("in-process classpath:"));
        this.getConsoleLogger().debug(inProcClasspath.getCompactLogMessage("in-process(compact) classpath:"));
        ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(testClasspath, providerClasspath, inProcClasspath, this.effectiveIsEnableAssertions(), this.isChildDelegation());
        return new StartupConfiguration(providerName, (AbstractPathConfiguration)classpathConfiguration, classLoaderConfiguration, this.isForking(), false);
    }

    private static Set<Artifact> retainInProcArtifactsUnique(Set<Artifact> providerArtifacts, Artifact ... inPluginArtifacts) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact inPluginArtifact : inPluginArtifacts) {
            boolean contains = false;
            for (Artifact providerArtifact : providerArtifacts) {
                if (!providerArtifact.getGroupId().equals(inPluginArtifact.getGroupId()) || !providerArtifact.getArtifactId().equals(inPluginArtifact.getArtifactId())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            result.add(inPluginArtifact);
        }
        return result;
    }

    private static Classpath createInProcClasspath(Classpath providerClasspath, Set<Artifact> newArtifacts) {
        Classpath inprocClasspath = providerClasspath.clone();
        for (Artifact newArtifact : newArtifacts) {
            inprocClasspath = inprocClasspath.addClassPathElementUrl(newArtifact.getFile().getAbsolutePath());
        }
        return inprocClasspath;
    }

    private LocationManager getLocationManager() {
        return this.locationManager;
    }

    private StartupConfiguration newStartupConfigWithModularPath(@Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull Set<Artifact> providerArtifacts, @Nonnull String providerName, @Nonnull File moduleDescriptor, @Nonnull DefaultScanResult scanResult) throws IOException {
        TestClassPath testClasspathWrapper = this.generateTestClasspath();
        Classpath testClasspath = testClasspathWrapper.toClasspath();
        testClasspathWrapper.avoidArtifactDuplicates(providerArtifacts);
        Classpath providerClasspath = ClasspathCache.getCachedClassPath(providerName);
        if (providerClasspath == null) {
            providerClasspath = ClasspathCache.setCachedClasspath(providerName, providerArtifacts);
        }
        ResolvePathsRequest req = ResolvePathsRequest.ofStrings((Collection)testClasspath.getClassPath()).setMainModuleDescriptor((Object)moduleDescriptor.getAbsolutePath());
        ResolvePathsResult result = this.getLocationManager().resolvePaths(req);
        testClasspath = new Classpath(result.getClasspathElements());
        Classpath testModulepath = new Classpath(result.getModulepathElements().keySet());
        TreeSet<String> packages = new TreeSet<String>();
        for (String className : scanResult.getClasses()) {
            packages.add(StringUtils.substringBeforeLast(className, "."));
        }
        ModularClasspath modularClasspath = new ModularClasspath(moduleDescriptor, testModulepath.getClassPath(), packages, this.getTestClassesDirectory());
        ModularClasspathConfiguration classpathConfiguration = new ModularClasspathConfiguration(modularClasspath, testClasspath, providerClasspath, this.effectiveIsEnableAssertions(), this.isChildDelegation());
        this.getConsoleLogger().debug(testClasspath.getLogMessage("test classpath:"));
        this.getConsoleLogger().debug(testModulepath.getLogMessage("test modulepath:"));
        this.getConsoleLogger().debug(providerClasspath.getLogMessage("provider classpath:"));
        this.getConsoleLogger().debug(testClasspath.getCompactLogMessage("test(compact) classpath:"));
        this.getConsoleLogger().debug(testModulepath.getCompactLogMessage("test(compact) modulepath:"));
        this.getConsoleLogger().debug(providerClasspath.getCompactLogMessage("provider(compact) classpath:"));
        return new StartupConfiguration(providerName, (AbstractPathConfiguration)classpathConfiguration, classLoaderConfiguration, this.isForking(), false);
    }

    private Artifact getCommonArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:maven-surefire-common");
    }

    private Artifact getApiArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-api");
    }

    private Artifact getLoggerApiArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-logger-api");
    }

    private Artifact getBooterArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
    }

    private Artifact getShadefireArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-shadefire");
    }

    private StartupReportConfiguration getStartupReportConfiguration(String configChecksum, boolean isForkMode) {
        return new StartupReportConfiguration(this.isUseFile(), this.isPrintSummary(), this.getReportFormat(), this.isRedirectTestOutputToFile(), this.isDisableXmlReport(), this.getReportsDirectory(), this.isTrimStackTrace(), this.getReportNameSuffix(), this.getStatisticsFile(configChecksum), this.requiresRunHistory(), this.getRerunFailingTestsCount(), this.getReportSchemaLocation(), this.getEncoding(), isForkMode);
    }

    private boolean isSpecificTestSpecified() {
        return org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils.isNotBlank(this.getTest());
    }

    @Nonnull
    private List<String> readListFromFile(@Nonnull File file) {
        this.getConsoleLogger().debug("Reading list from: " + file);
        if (!file.exists()) {
            throw new RuntimeException("Failed to load list from file: " + file);
        }
        try {
            List<String> list = FileUtils.loadFile(file);
            if (this.getConsoleLogger().isDebugEnabled()) {
                this.getConsoleLogger().debug("List contents:");
                for (String entry : list) {
                    this.getConsoleLogger().debug("  " + entry);
                }
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load list from file: " + file, e);
        }
    }

    private void maybeAppendList(List<String> base, List<String> list) {
        if (list != null) {
            base.addAll(list);
        }
    }

    @Nonnull
    private List<String> getExcludeList() throws MojoFailureException {
        List<String> actualExcludes = null;
        if (this.isSpecificTestSpecified()) {
            actualExcludes = Collections.emptyList();
        } else {
            if (this.getExcludesFile() != null) {
                actualExcludes = this.readListFromFile(this.getExcludesFile());
            }
            if (actualExcludes == null) {
                actualExcludes = this.getExcludes();
            } else {
                this.maybeAppendList(actualExcludes, this.getExcludes());
            }
            this.checkMethodFilterInIncludesExcludes(actualExcludes);
            if (actualExcludes == null || actualExcludes.isEmpty()) {
                actualExcludes = Collections.singletonList(this.getDefaultExcludes());
            }
        }
        return this.filterNulls(actualExcludes);
    }

    private List<String> getIncludeList() throws MojoFailureException {
        List<String> includes = null;
        if (this.isSpecificTestSpecified()) {
            includes = new ArrayList<String>();
            Collections.addAll(includes, org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils.split(this.getTest(), ","));
        } else {
            if (this.getIncludesFile() != null) {
                includes = this.readListFromFile(this.getIncludesFile());
            }
            if (includes == null) {
                includes = this.getIncludes();
            } else {
                this.maybeAppendList(includes, this.getIncludes());
            }
            this.checkMethodFilterInIncludesExcludes(includes);
            if (includes == null || includes.isEmpty()) {
                includes = Arrays.asList(this.getDefaultIncludes());
            }
        }
        return this.filterNulls(includes);
    }

    private void checkMethodFilterInIncludesExcludes(Iterable<String> patterns) throws MojoFailureException {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (pattern == null || !pattern.contains("#")) continue;
                throw new MojoFailureException("Method filter prohibited in includes|excludes|includesFile|excludesFile parameter: " + pattern);
            }
        }
    }

    private TestListResolver getIncludedAndExcludedTests() throws MojoFailureException {
        if (this.includedExcludedTests == null) {
            this.includedExcludedTests = new TestListResolver(this.getIncludeList(), this.getExcludeList());
        }
        return this.includedExcludedTests;
    }

    public TestListResolver getSpecificTests() {
        if (this.specificTests == null) {
            this.specificTests = new TestListResolver(this.getTest());
        }
        return this.specificTests;
    }

    @Nonnull
    private List<String> filterNulls(@Nonnull List<String> toFilter) {
        ArrayList<String> result = new ArrayList<String>(toFilter.size());
        for (String item : toFilter) {
            if (item == null || (item = item.trim()).isEmpty()) continue;
            result.add(item);
        }
        return result;
    }

    private Artifact getTestNgArtifact() throws MojoExecutionException {
        Artifact artifact = this.getProjectArtifactMap().get(this.getTestNGArtifactName());
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactName = projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId();
        if (artifact != null) {
            VersionRange range = this.createVersionRange();
            if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
                throw new MojoExecutionException("TestNG support requires version 4.7 or above. You have declared version " + artifact.getVersion());
            }
        } else if (projectArtifactName.equals(this.getTestNGArtifactName())) {
            artifact = projectArtifact;
        }
        return artifact;
    }

    private VersionRange createVersionRange() {
        try {
            return VersionRange.createFromVersionSpec((String)"[4.7,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private Artifact getJunitArtifact() {
        Artifact artifact = this.getProjectArtifactMap().get(this.getJunitArtifactName());
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactName = projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId();
        if (artifact == null && projectArtifactName.equals(this.getJunitArtifactName())) {
            artifact = projectArtifact;
        }
        return artifact;
    }

    private Artifact getJunitDepArtifact() {
        return this.getProjectArtifactMap().get("junit:junit-dep");
    }

    private Artifact getJunitPlatformArtifact() {
        Artifact artifact = this.getProjectArtifactMap().get(this.getJunitPlatformArtifactName());
        Artifact projectArtifact = this.project.getArtifact();
        String projectArtifactName = projectArtifact.getGroupId() + ":" + projectArtifact.getArtifactId();
        if (artifact == null && projectArtifactName.equals(this.getJunitPlatformArtifactName())) {
            artifact = projectArtifact;
        }
        return artifact;
    }

    private ForkStarter createForkStarter(@Nonnull ProviderInfo provider, @Nonnull ForkConfiguration forkConfiguration, @Nonnull ClassLoaderConfiguration classLoaderConfiguration, @Nonnull RunOrderParameters runOrderParameters, @Nonnull ConsoleLogger log, @Nonnull DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, false, classLoaderConfiguration, scanResult);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum, true);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new ForkStarter(providerConfiguration, startupConfiguration, forkConfiguration, this.getForkedProcessTimeoutInSeconds(), startupReportConfiguration, log);
    }

    private InPluginVMSurefireStarter createInprocessStarter(@Nonnull ProviderInfo provider, @Nonnull ClassLoaderConfiguration classLoaderConfig, @Nonnull RunOrderParameters runOrderParameters, @Nonnull DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, true, classLoaderConfig, scanResult);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum, false);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new InPluginVMSurefireStarter(startupConfiguration, providerConfiguration, startupReportConfiguration, this.getConsoleLogger());
    }

    @Nonnull
    private ForkConfiguration getForkConfiguration() throws MojoFailureException {
        File tmpDir = this.getSurefireTempDir();
        Artifact shadeFire = this.getShadefireArtifact();
        Classpath bootClasspath = this.getArtifactClasspath(shadeFire != null ? shadeFire : this.surefireBooterArtifact);
        Platform platform = PLATFORM.withJdkExecAttributesForTests(this.getEffectiveJvm());
        if (platform.getJdkExecAttributesForTests().isJava9AtLeast() && this.existsModuleDescriptor()) {
            return new ModularClasspathForkConfiguration(bootClasspath, tmpDir, this.getEffectiveDebugForkedProcess(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getProject().getModel().getProperties(), this.getArgLine(), this.getEnvironmentVariables(), this.getConsoleLogger().isDebugEnabled(), this.getEffectiveForkCount(), this.reuseForks, platform, this.getConsoleLogger());
        }
        if (this.getClassLoaderConfiguration().isManifestOnlyJarRequestedAndUsable()) {
            return new JarManifestForkConfiguration(bootClasspath, tmpDir, this.getEffectiveDebugForkedProcess(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getProject().getModel().getProperties(), this.getArgLine(), this.getEnvironmentVariables(), this.getConsoleLogger().isDebugEnabled(), this.getEffectiveForkCount(), this.reuseForks, platform, this.getConsoleLogger());
        }
        return new ClasspathForkConfiguration(bootClasspath, tmpDir, this.getEffectiveDebugForkedProcess(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getProject().getModel().getProperties(), this.getArgLine(), this.getEnvironmentVariables(), this.getConsoleLogger().isDebugEnabled(), this.getEffectiveForkCount(), this.reuseForks, platform, this.getConsoleLogger());
    }

    private void convertDeprecatedForkMode() {
        String effectiveForkMode = this.getEffectiveForkMode();
        if (FORK_PERTHREAD.equals(effectiveForkMode)) {
            this.forkCount = String.valueOf(this.threadCount);
        } else if (FORK_NEVER.equals(effectiveForkMode)) {
            this.forkCount = "0";
        } else if (FORK_ALWAYS.equals(effectiveForkMode)) {
            this.forkCount = "1";
            this.reuseForks = false;
        }
        if (!FORK_ONCE.equals(this.getForkMode())) {
            this.getConsoleLogger().warning("The parameter forkMode is deprecated since version 2.14. Use forkCount and reuseForks instead.");
        }
    }

    protected int getEffectiveForkCount() {
        if (this.effectiveForkCount < 0) {
            try {
                this.effectiveForkCount = this.convertWithCoreCount(this.forkCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.effectiveForkCount < 0) {
                throw new IllegalArgumentException("Fork count " + this.forkCount.trim() + " is not a legal value.");
            }
        }
        return this.effectiveForkCount;
    }

    protected int convertWithCoreCount(String count) {
        String trimmed = count.trim();
        if (trimmed.endsWith("C")) {
            double multiplier = Double.parseDouble(trimmed.substring(0, trimmed.length() - 1));
            double calculated = multiplier * (double)Runtime.getRuntime().availableProcessors();
            return calculated > 0.0 ? Math.max((int)calculated, 1) : 0;
        }
        return Integer.parseInt(trimmed);
    }

    private String getEffectiveDebugForkedProcess() {
        String debugForkedProcess = this.getDebugForkedProcess();
        if ("true".equals(debugForkedProcess)) {
            return "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
        }
        return debugForkedProcess;
    }

    private JdkAttributes getEffectiveJvm() throws MojoFailureException {
        String jvmToUse;
        if (org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils.isNotEmpty(this.jvm)) {
            File pathToJava = new File(this.jvm).getAbsoluteFile();
            if (!SystemUtils.endsWithJavaPath((String)pathToJava.getPath())) {
                throw new MojoFailureException("Given path does not end with java executor \"" + pathToJava.getPath() + "\".");
            }
            if (!(pathToJava.isFile() || "java".equals(pathToJava.getName()) && pathToJava.getParentFile().isDirectory())) {
                throw new MojoFailureException("Given path to java executor does not exist \"" + pathToJava.getPath() + "\".");
            }
            File jdkHome = SystemUtils.toJdkHomeFromJvmExec((String)pathToJava.getPath());
            BigDecimal version = jdkHome == null ? null : SystemUtils.toJdkVersionFromReleaseFile((File)jdkHome);
            boolean javaVersion9 = version == null ? SystemUtils.isJava9AtLeast((String)pathToJava.getPath()) : SystemUtils.isJava9AtLeast((BigDecimal)version);
            return new JdkAttributes(pathToJava.getPath(), javaVersion9);
        }
        if (this.toolchain != null && org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils.isNotEmpty(jvmToUse = this.toolchain.findTool("java"))) {
            boolean javaVersion9 = false;
            if (this.toolchain instanceof DefaultToolchain) {
                DefaultToolchain defaultToolchain = (DefaultToolchain)this.toolchain;
                boolean bl = javaVersion9 = defaultToolchain.matchesRequirements(JAVA_9_MATCHER) || defaultToolchain.matchesRequirements(JAVA_9_MATCHER_OLD_NOTATION);
            }
            if (!javaVersion9) {
                javaVersion9 = SystemUtils.isJava9AtLeast((String)jvmToUse);
            }
            return new JdkAttributes(jvmToUse, javaVersion9);
        }
        jvmToUse = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        this.getConsoleLogger().debug("Using JVM: " + jvmToUse + " with Java version " + SystemUtils.JAVA_SPECIFICATION_VERSION.toPlainString());
        return new JdkAttributes(jvmToUse, SystemUtils.isBuiltInJava9AtLeast());
    }

    private Artifact getSurefireBooterArtifact() {
        Artifact artifact = this.getBooterArtifact();
        if (artifact == null) {
            throw new RuntimeException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        return artifact;
    }

    File getSurefireTempDir() {
        return org.apache.maven.surefire.shade.common.org.apache.commons.lang3.SystemUtils.IS_OS_WINDOWS ? this.createSurefireBootDirectoryInTemp() : this.createSurefireBootDirectoryInBuild();
    }

    private String getConfigChecksum() {
        ChecksumCalculator checksum = new ChecksumCalculator();
        checksum.add(this.getPluginName());
        checksum.add(this.isSkipTests());
        checksum.add(this.isSkipExec());
        checksum.add(this.isSkip());
        checksum.add(this.getTestClassesDirectory());
        checksum.add(this.getClassesDirectory());
        checksum.add(this.getClasspathDependencyExcludes());
        checksum.add(this.getClasspathDependencyScopeExclude());
        checksum.add(this.getAdditionalClasspathElements());
        checksum.add(this.getReportsDirectory());
        checksum.add(this.getProjectBuildDirectory());
        checksum.add(this.getTestSourceDirectory());
        checksum.add(this.getTest());
        checksum.add(this.getIncludes());
        checksum.add(this.getSkipAfterFailureCount());
        checksum.add(this.getShutdown());
        checksum.add(this.getExcludes());
        checksum.add(this.getLocalRepository());
        checksum.add(this.getSystemProperties());
        checksum.add(this.getSystemPropertyVariables());
        checksum.add(this.getSystemPropertiesFile());
        checksum.add(this.getProperties());
        checksum.add(this.isPrintSummary());
        checksum.add(this.getReportFormat());
        checksum.add(this.getReportNameSuffix());
        checksum.add(this.isUseFile());
        checksum.add(this.isRedirectTestOutputToFile());
        checksum.add(this.getForkMode());
        checksum.add(this.getForkCount());
        checksum.add(this.isReuseForks());
        checksum.add(this.getJvm());
        checksum.add(this.getArgLine());
        checksum.add(this.getDebugForkedProcess());
        checksum.add(this.getForkedProcessTimeoutInSeconds());
        checksum.add(this.getParallelTestsTimeoutInSeconds());
        checksum.add(this.getParallelTestsTimeoutForcedInSeconds());
        checksum.add(this.getEnvironmentVariables());
        checksum.add(this.getWorkingDirectory());
        checksum.add(this.isChildDelegation());
        checksum.add(this.getGroups());
        checksum.add(this.getExcludedGroups());
        checksum.add(this.getSuiteXmlFiles());
        checksum.add(this.getJunitArtifact());
        checksum.add(this.getTestNGArtifactName());
        checksum.add(this.getThreadCount());
        checksum.add(this.getThreadCountSuites());
        checksum.add(this.getThreadCountClasses());
        checksum.add(this.getThreadCountMethods());
        checksum.add(this.getPerCoreThreadCount());
        checksum.add(this.getUseUnlimitedThreads());
        checksum.add(this.getParallel());
        checksum.add(this.isParallelOptimized());
        checksum.add(this.isTrimStackTrace());
        checksum.add(this.getRemoteRepositories());
        checksum.add(this.isDisableXmlReport());
        checksum.add(this.isUseSystemClassLoader());
        checksum.add(this.isUseManifestOnlyJar());
        checksum.add(this.getEncoding());
        checksum.add(this.isEnableAssertions());
        checksum.add(this.getObjectFactory());
        checksum.add(this.getFailIfNoTests());
        checksum.add(this.getRunOrder());
        checksum.add(this.getDependenciesToScan());
        checksum.add(this.getForkedProcessExitTimeoutInSeconds());
        checksum.add(this.getRerunFailingTestsCount());
        checksum.add(this.getTempDir());
        this.addPluginSpecificChecksumItems(checksum);
        return checksum.getSha1();
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
    }

    protected boolean hasExecutedBefore() {
        String configChecksum = this.getConfigChecksum();
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(configChecksum)) {
            this.getConsoleLogger().info("Skipping execution of surefire because it has already been run for this configuration");
            return true;
        }
        pluginContext.put(configChecksum, configChecksum);
        return false;
    }

    @Nonnull
    protected ClassLoaderConfiguration getClassLoaderConfiguration() {
        return this.isForking() ? new ClassLoaderConfiguration(this.isUseSystemClassLoader(), this.isUseManifestOnlyJar()) : new ClassLoaderConfiguration(false, false);
    }

    private TestClassPath generateTestClasspath() {
        Set<Artifact> classpathArtifacts = this.getProject().getArtifacts();
        if (this.getClasspathDependencyScopeExclude() != null && !this.getClasspathDependencyScopeExclude().isEmpty()) {
            ScopeArtifactFilter dependencyFilter = new ScopeArtifactFilter(this.getClasspathDependencyScopeExclude());
            classpathArtifacts = AbstractSurefireMojo.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        if (this.getClasspathDependencyExcludes() != null) {
            List<String> excludedDependencies = Arrays.asList(this.getClasspathDependencyExcludes());
            PatternIncludesArtifactFilter dependencyFilter = new PatternIncludesArtifactFilter(excludedDependencies);
            classpathArtifacts = AbstractSurefireMojo.filterArtifacts(classpathArtifacts, dependencyFilter);
        }
        return new TestClassPath(classpathArtifacts, this.getClassesDirectory(), this.getTestClassesDirectory(), this.getAdditionalClasspathElements(), this.logger);
    }

    private static Set<Artifact> filterArtifacts(Set<Artifact> artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void showMap(Map<?, ?> map, String setting) {
        for (Object o : map.keySet()) {
            String key = (String)o;
            String value = (String)map.get(key);
            this.getConsoleLogger().debug("Setting " + setting + " [" + key + "]=[" + value + "]");
        }
    }

    private Classpath getArtifactClasspath(Artifact surefireArtifact) {
        Classpath existing = ClasspathCache.getCachedClassPath(surefireArtifact.getArtifactId());
        if (existing == null) {
            ArrayList<String> items = new ArrayList<String>();
            for (Artifact artifact : this.dependencyResolver.resolveArtifact(surefireArtifact).getArtifacts()) {
                this.getConsoleLogger().debug("Adding to " + this.getPluginName() + " booter test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope());
                items.add(artifact.getFile().getAbsolutePath());
            }
            existing = new Classpath(items);
            ClasspathCache.setCachedClasspath(surefireArtifact.getArtifactId(), existing);
        }
        return existing;
    }

    private Properties getUserProperties() {
        return this.getSession().getUserProperties();
    }

    private void ensureWorkingDirectoryExists() throws MojoFailureException {
        if (this.getWorkingDirectory() == null) {
            throw new MojoFailureException("workingDirectory cannot be null");
        }
        if (this.isForking()) {
            return;
        }
        if (!this.getWorkingDirectory().exists() && !this.getWorkingDirectory().mkdirs()) {
            throw new MojoFailureException("Cannot create workingDirectory " + this.getWorkingDirectory());
        }
        if (!this.getWorkingDirectory().isDirectory()) {
            throw new MojoFailureException("workingDirectory " + this.getWorkingDirectory() + " exists and is not a directory");
        }
    }

    private void ensureParallelRunningCompatibility() throws MojoFailureException {
        if (this.isMavenParallel() && this.isNotForking()) {
            throw new MojoFailureException("parallel maven execution is not compatible with surefire forkCount 0");
        }
    }

    private void ensureThreadCountWithPerThread() throws MojoFailureException {
        if (FORK_PERTHREAD.equals(this.getEffectiveForkMode()) && this.getThreadCount() < 1) {
            throw new MojoFailureException("Fork mode perthread requires a thread count");
        }
    }

    private void warnIfUselessUseSystemClassLoaderParameter() {
        if (this.isUseSystemClassLoader() && this.isNotForking()) {
            this.getConsoleLogger().warning("useSystemClassloader setting has no effect when not forking");
        }
    }

    private boolean isNotForking() {
        return !this.isForking();
    }

    private List<CommandLineOption> commandLineOptions() {
        return SurefireHelper.commandLineOptions(this.getSession(), this.getConsoleLogger());
    }

    private void warnIfDefunctGroupsCombinations() throws MojoFailureException, MojoExecutionException {
        if (this.isAnyGroupsSelected() && this.getTestNgArtifact() == null) {
            boolean junit5PlatformCompatible;
            Artifact junitArtifact = this.getJunitArtifact();
            boolean junit47Compatible = this.isJunit47Compatible(junitArtifact);
            boolean bl = junit5PlatformCompatible = this.getJunitPlatformArtifact() != null;
            if (!junit47Compatible && !junit5PlatformCompatible) {
                if (junitArtifact != null) {
                    throw new MojoFailureException("groups/excludedGroups are specified but JUnit version on classpath is too old to support groups. Check your dependency:tree to see if your project is picking up an old junit version");
                }
                throw new MojoFailureException("groups/excludedGroups require TestNG, JUnit48+ or JUnit 5 on project test classpath");
            }
        }
    }

    private void warnIfRerunClashes() throws MojoFailureException {
        if (this.getRerunFailingTestsCount() < 0) {
            throw new MojoFailureException("Parameter \"rerunFailingTestsCount\" should not be negative.");
        }
        if (this.getSkipAfterFailureCount() < 0) {
            throw new MojoFailureException("Parameter \"skipAfterFailureCount\" should not be negative.");
        }
    }

    private void warnIfWrongShutdownValue() throws MojoFailureException {
        if (!Shutdown.isKnown((String)this.getShutdown())) {
            throw new MojoFailureException("Parameter \"shutdown\" should have values " + Shutdown.listParameters());
        }
    }

    private void warnIfNotApplicableSkipAfterFailureCount() throws MojoFailureException {
        int skipAfterFailureCount = this.getSkipAfterFailureCount();
        if (skipAfterFailureCount < 0) {
            throw new MojoFailureException("Parameter \"skipAfterFailureCount\" should not be negative.");
        }
        if (skipAfterFailureCount > 0) {
            try {
                Artifact testng = this.getTestNgArtifact();
                if (testng != null) {
                    VersionRange range = VersionRange.createFromVersionSpec((String)"[5.10,)");
                    if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(testng.getVersion()))) {
                        throw new MojoFailureException("Parameter \"skipAfterFailureCount\" expects TestNG Version 5.10 or higher. java.lang.NoClassDefFoundError: org/testng/IInvokedMethodListener");
                    }
                } else {
                    VersionRange range;
                    Artifact junit = this.getJunitArtifact();
                    if (junit != null && !(range = VersionRange.createFromVersionSpec((String)"[4.0,)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(junit.getVersion()))) {
                        throw new MojoFailureException("Parameter \"skipAfterFailureCount\" expects JUnit Version 4.0 or higher. java.lang.NoSuchMethodError: org.junit.runner.notification.RunNotifier.pleaseStop()V");
                    }
                }
            }
            catch (MojoExecutionException e) {
                throw new MojoFailureException(e.getLocalizedMessage());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void warnIfIllegalTempDir() throws MojoFailureException {
        if (org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils.isEmpty(this.getTempDir())) {
            throw new MojoFailureException("Parameter 'tempDir' should not be blank string.");
        }
    }

    File createSurefireBootDirectoryInBuild() {
        File tmp = new File(this.getProjectBuildDirectory(), this.getTempDir());
        tmp.mkdirs();
        return tmp;
    }

    File createSurefireBootDirectoryInTemp() {
        try {
            return Files.createTempDirectory(this.getTempDir(), new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            return this.createSurefireBootDirectoryInBuild();
        }
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getSystemPropertyVariables() {
        return this.systemPropertyVariables;
    }

    public void setSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
        this.systemPropertyVariables = systemPropertyVariables;
    }

    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    private Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public void setPluginArtifactMap(Map<String, Artifact> pluginArtifactMap) {
        this.pluginArtifactMap = pluginArtifactMap;
    }

    public Map<String, Artifact> getProjectArtifactMap() {
        return this.projectArtifactMap;
    }

    public void setProjectArtifactMap(Map<String, Artifact> projectArtifactMap) {
        this.projectArtifactMap = projectArtifactMap;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public void setReportNameSuffix(String reportNameSuffix) {
        this.reportNameSuffix = reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public String getForkMode() {
        return this.forkMode;
    }

    public void setForkMode(String forkMode) {
        this.forkMode = forkMode;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getArgLine() {
        return this.argLine;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isChildDelegation() {
        return this.childDelegation;
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(String excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public String getJunitArtifactName() {
        return this.junitArtifactName;
    }

    public void setJunitArtifactName(String junitArtifactName) {
        this.junitArtifactName = junitArtifactName;
    }

    public String getJunitPlatformArtifactName() {
        return this.junitPlatformArtifactName;
    }

    public void setJunitPlatformArtifactName(String junitPlatformArtifactName) {
        this.junitPlatformArtifactName = junitPlatformArtifactName;
    }

    public String getTestNGArtifactName() {
        return this.testNGArtifactName;
    }

    public void setTestNGArtifactName(String testNGArtifactName) {
        this.testNGArtifactName = testNGArtifactName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean getPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public void setPerCoreThreadCount(boolean perCoreThreadCount) {
        this.perCoreThreadCount = perCoreThreadCount;
    }

    public boolean getUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public void setUseUnlimitedThreads(boolean useUnlimitedThreads) {
        this.useUnlimitedThreads = useUnlimitedThreads;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public boolean isParallelOptimized() {
        return this.parallelOptimized;
    }

    public void setParallelOptimized(boolean parallelOptimized) {
        this.parallelOptimized = parallelOptimized;
    }

    public int getThreadCountSuites() {
        return this.threadCountSuites;
    }

    public void setThreadCountSuites(int threadCountSuites) {
        this.threadCountSuites = threadCountSuites;
    }

    public int getThreadCountClasses() {
        return this.threadCountClasses;
    }

    public void setThreadCountClasses(int threadCountClasses) {
        this.threadCountClasses = threadCountClasses;
    }

    public int getThreadCountMethods() {
        return this.threadCountMethods;
    }

    public void setThreadCountMethods(int threadCountMethods) {
        this.threadCountMethods = threadCountMethods;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public void setTrimStackTrace(boolean trimStackTrace) {
        this.trimStackTrace = trimStackTrace;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public void setDisableXmlReport(boolean disableXmlReport) {
        this.disableXmlReport = disableXmlReport;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public boolean effectiveIsEnableAssertions() {
        List<String> args;
        if (this.getArgLine() != null && ((args = Arrays.asList(this.getArgLine().split(" "))).contains("-da") || args.contains("-disableassertions"))) {
            return false;
        }
        return this.isEnableAssertions();
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public void setToolchainManager(ToolchainManager toolchainManager) {
        this.toolchainManager = toolchainManager;
    }

    public boolean isMavenParallel() {
        return this.parallelMavenExecution != null && this.parallelMavenExecution != false;
    }

    public String[] getDependenciesToScan() {
        return this.dependenciesToScan;
    }

    public void setDependenciesToScan(String[] dependenciesToScan) {
        this.dependenciesToScan = dependenciesToScan;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    @Override
    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public String getForkCount() {
        return this.forkCount;
    }

    public boolean isReuseForks() {
        return this.reuseForks;
    }

    public String[] getAdditionalClasspathElements() {
        return this.additionalClasspathElements;
    }

    public void setAdditionalClasspathElements(String[] additionalClasspathElements) {
        this.additionalClasspathElements = additionalClasspathElements;
    }

    public String[] getClasspathDependencyExcludes() {
        return this.classpathDependencyExcludes;
    }

    public void setClasspathDependencyExcludes(String[] classpathDependencyExcludes) {
        this.classpathDependencyExcludes = classpathDependencyExcludes;
    }

    public String getClasspathDependencyScopeExclude() {
        return this.classpathDependencyScopeExclude;
    }

    public void setClasspathDependencyScopeExclude(String classpathDependencyScopeExclude) {
        this.classpathDependencyScopeExclude = classpathDependencyScopeExclude;
    }

    public File getProjectBuildDirectory() {
        return this.projectBuildDirectory;
    }

    public void setProjectBuildDirectory(File projectBuildDirectory) {
        this.projectBuildDirectory = projectBuildDirectory;
    }

    protected void logDebugOrCliShowErrors(String s) {
        SurefireHelper.logDebugOrCliShowErrors(s, this.getConsoleLogger(), this.cli);
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    private static String getEffectiveForkMode(String forkMode) {
        if ("pertest".equalsIgnoreCase(forkMode)) {
            return FORK_ALWAYS;
        }
        if ("none".equalsIgnoreCase(forkMode)) {
            return FORK_NEVER;
        }
        if (forkMode.equals(FORK_NEVER) || forkMode.equals(FORK_ONCE) || forkMode.equals(FORK_ALWAYS) || forkMode.equals(FORK_PERTHREAD)) {
            return forkMode;
        }
        throw new IllegalArgumentException("Fork mode " + forkMode + " is not a legal value");
    }

    final class ProviderList {
        private final ProviderInfo[] wellKnownProviders;
        private final ConfigurableProviderInfo dynamicProvider;

        ProviderList(ConfigurableProviderInfo dynamicProviderInfo, ProviderInfo ... wellKnownProviders) {
            this.wellKnownProviders = wellKnownProviders;
            this.dynamicProvider = dynamicProviderInfo;
        }

        @Nonnull
        List<ProviderInfo> resolve() {
            ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
            Set<String> manuallyConfiguredProviders = this.getManuallyConfiguredProviders();
            for (String name : manuallyConfiguredProviders) {
                ProviderInfo wellKnown = this.findByName(name);
                ProviderInfo providerToAdd = wellKnown != null ? wellKnown : this.dynamicProvider.instantiate(name);
                AbstractSurefireMojo.this.logDebugOrCliShowErrors("Using configured provider " + providerToAdd.getProviderName());
                providersToRun.add(providerToAdd);
            }
            return manuallyConfiguredProviders.isEmpty() ? this.autoDetectOneProvider() : providersToRun;
        }

        @Nonnull
        private List<ProviderInfo> autoDetectOneProvider() {
            ArrayList<ProviderInfo> providersToRun = new ArrayList<ProviderInfo>();
            for (ProviderInfo wellKnownProvider : this.wellKnownProviders) {
                if (!wellKnownProvider.isApplicable()) continue;
                providersToRun.add(wellKnownProvider);
                return providersToRun;
            }
            return providersToRun;
        }

        private Set<String> getManuallyConfiguredProviders() {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return AbstractSurefireMojo.this.providerDetector.lookupServiceNames(SurefireProvider.class, cl);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ProviderInfo findByName(String providerClassName) {
            for (ProviderInfo wellKnownProvider : this.wellKnownProviders) {
                if (!wellKnownProvider.getProviderName().equals(providerClassName)) continue;
                return wellKnownProvider;
            }
            return null;
        }
    }

    final class DynamicProviderInfo
    implements ConfigurableProviderInfo {
        final String providerName;

        DynamicProviderInfo(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public ProviderInfo instantiate(String providerName) {
            return new DynamicProviderInfo(providerName);
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() {
            return AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(AbstractSurefireMojo.this.getPluginArtifactMap(), AbstractSurefireMojo.this.getMojoArtifact(), AbstractSurefireMojo.this.getCommonArtifact(), AbstractSurefireMojo.this.getApiArtifact(), AbstractSurefireMojo.this.getLoggerApiArtifact());
        }
    }

    final class JUnitCoreProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnitCoreProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
        }

        private boolean is47CompatibleJunitDep() {
            return this.junitDepArtifact != null && AbstractSurefireMojo.this.isJunit47Compatible(this.junitDepArtifact);
        }

        @Override
        public boolean isApplicable() {
            boolean isJunitArtifact47 = AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact) && AbstractSurefireMojo.this.isJunit47Compatible(this.junitArtifact);
            boolean isAny47ProvidersForces = AbstractSurefireMojo.this.isAnyConcurrencySelected() || AbstractSurefireMojo.this.isAnyGroupsSelected();
            return isAny47ProvidersForces && (isJunitArtifact47 || this.is47CompatibleJunitDep());
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertGroupParameters();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() {
            String version = AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion();
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit47", version);
        }
    }

    final class JUnitPlatformProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;

        JUnitPlatformProviderInfo(Artifact junitArtifact) {
            this.junitArtifact = junitArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junitplatform.JUnitPlatformProvider";
        }

        @Override
        public boolean isApplicable() {
            return this.junitArtifact != null;
        }

        @Override
        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertGroupParameters();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() {
            String version = AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion();
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit-platform", version);
        }
    }

    final class JUnit4ProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnit4ProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junit4.JUnit4Provider";
        }

        @Override
        public boolean isApplicable() {
            return this.junitDepArtifact != null || AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact);
        }

        @Override
        public void addProviderProperties() {
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() {
            String version = AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion();
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit4", version);
        }
    }

    final class JUnit3ProviderInfo
    implements ProviderInfo {
        JUnit3ProviderInfo() {
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.junit.JUnit3Provider";
        }

        @Override
        public boolean isApplicable() {
            return true;
        }

        @Override
        public void addProviderProperties() {
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() {
            String version = AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion();
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit3", version);
        }
    }

    final class TestNgProviderInfo
    implements ProviderInfo {
        private final Artifact testNgArtifact;

        TestNgProviderInfo(Artifact testNgArtifact) {
            this.testNgArtifact = testNgArtifact;
        }

        @Override
        @Nonnull
        public String getProviderName() {
            return "org.apache.maven.surefire.testng.TestNGProvider";
        }

        @Override
        public boolean isApplicable() {
            return this.testNgArtifact != null;
        }

        @Override
        public void addProviderProperties() throws MojoExecutionException {
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        @Override
        @Nonnull
        public Set<Artifact> getProviderClasspath() {
            Artifact surefireArtifact = AbstractSurefireMojo.this.getBooterArtifact();
            String version = surefireArtifact.getBaseVersion();
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-testng", version);
        }
    }
}

