/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessExitErrorListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessPropertyEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessReportEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStackTraceEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStandardOutErrEventListener;
import org.apache.maven.plugin.surefire.booterclient.output.ForkedProcessStringEventListener;
import org.apache.maven.surefire.api.booter.ForkedProcessEventType;
import org.apache.maven.surefire.api.event.AbstractConsoleEvent;
import org.apache.maven.surefire.api.event.AbstractStandardStreamEvent;
import org.apache.maven.surefire.api.event.AbstractTestControlEvent;
import org.apache.maven.surefire.api.event.ConsoleErrorEvent;
import org.apache.maven.surefire.api.event.Event;
import org.apache.maven.surefire.api.event.JvmExitErrorEvent;
import org.apache.maven.surefire.api.event.SystemPropertyEvent;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;

public final class ForkedProcessEventNotifier {
    private volatile ForkedProcessPropertyEventListener propertyEventListener;
    private volatile ForkedProcessStackTraceEventListener consoleErrorEventListener;
    private volatile ForkedProcessExitErrorListener exitErrorEventListener;
    private final ConcurrentMap<ForkedProcessEventType, ForkedProcessReportEventListener<?>> reportEventListeners = new ConcurrentHashMap();
    private final ConcurrentMap<ForkedProcessEventType, ForkedProcessStandardOutErrEventListener> stdOutErrEventListeners = new ConcurrentHashMap<ForkedProcessEventType, ForkedProcessStandardOutErrEventListener>();
    private final ConcurrentMap<ForkedProcessEventType, ForkedProcessStringEventListener> consoleEventListeners = new ConcurrentHashMap<ForkedProcessEventType, ForkedProcessStringEventListener>();
    private final ConcurrentMap<ForkedProcessEventType, ForkedProcessEventListener> controlEventListeners = new ConcurrentHashMap<ForkedProcessEventType, ForkedProcessEventListener>();

    public void setSystemPropertiesListener(ForkedProcessPropertyEventListener listener) {
        this.propertyEventListener = Objects.requireNonNull(listener);
    }

    public <T extends ReportEntry> void setTestSetStartingListener(ForkedProcessReportEventListener<T> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TESTSET_STARTING, Objects.requireNonNull(listener));
    }

    public void setTestSetCompletedListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TESTSET_COMPLETED, Objects.requireNonNull(listener));
    }

    public void setTestStartingListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TEST_STARTING, Objects.requireNonNull(listener));
    }

    public void setTestSucceededListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TEST_SUCCEEDED, Objects.requireNonNull(listener));
    }

    public void setTestFailedListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TEST_FAILED, Objects.requireNonNull(listener));
    }

    public void setTestSkippedListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TEST_SKIPPED, Objects.requireNonNull(listener));
    }

    public void setTestErrorListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TEST_ERROR, Objects.requireNonNull(listener));
    }

    public void setTestAssumptionFailureListener(ForkedProcessReportEventListener<?> listener) {
        this.reportEventListeners.put(ForkedProcessEventType.BOOTERCODE_TEST_ASSUMPTIONFAILURE, Objects.requireNonNull(listener));
    }

    public void setStdOutListener(ForkedProcessStandardOutErrEventListener listener) {
        this.stdOutErrEventListeners.put(ForkedProcessEventType.BOOTERCODE_STDOUT, Objects.requireNonNull(listener));
        this.stdOutErrEventListeners.put(ForkedProcessEventType.BOOTERCODE_STDOUT_NEW_LINE, Objects.requireNonNull(listener));
    }

    public void setStdErrListener(ForkedProcessStandardOutErrEventListener listener) {
        this.stdOutErrEventListeners.put(ForkedProcessEventType.BOOTERCODE_STDERR, Objects.requireNonNull(listener));
        this.stdOutErrEventListeners.put(ForkedProcessEventType.BOOTERCODE_STDERR_NEW_LINE, Objects.requireNonNull(listener));
    }

    public void setConsoleInfoListener(ForkedProcessStringEventListener listener) {
        this.consoleEventListeners.put(ForkedProcessEventType.BOOTERCODE_CONSOLE_INFO, Objects.requireNonNull(listener));
    }

    public void setConsoleErrorListener(ForkedProcessStackTraceEventListener listener) {
        this.consoleErrorEventListener = Objects.requireNonNull(listener);
    }

    public void setConsoleDebugListener(ForkedProcessStringEventListener listener) {
        this.consoleEventListeners.put(ForkedProcessEventType.BOOTERCODE_CONSOLE_DEBUG, Objects.requireNonNull(listener));
    }

    public void setConsoleWarningListener(ForkedProcessStringEventListener listener) {
        this.consoleEventListeners.put(ForkedProcessEventType.BOOTERCODE_CONSOLE_WARNING, Objects.requireNonNull(listener));
    }

    public void setByeListener(ForkedProcessEventListener listener) {
        this.controlEventListeners.put(ForkedProcessEventType.BOOTERCODE_BYE, Objects.requireNonNull(listener));
    }

    public void setStopOnNextTestListener(ForkedProcessEventListener listener) {
        this.controlEventListeners.put(ForkedProcessEventType.BOOTERCODE_STOP_ON_NEXT_TEST, Objects.requireNonNull(listener));
    }

    public void setAcquireNextTestListener(ForkedProcessEventListener listener) {
        this.controlEventListeners.put(ForkedProcessEventType.BOOTERCODE_NEXT_TEST, Objects.requireNonNull(listener));
    }

    public void setExitErrorEventListener(ForkedProcessExitErrorListener listener) {
        this.exitErrorEventListener = Objects.requireNonNull(listener);
    }

    public void notifyEvent(Event event) {
        ForkedProcessEventType eventType = event.getEventType();
        if (event.isControlCategory()) {
            ForkedProcessEventListener listener = (ForkedProcessEventListener)this.controlEventListeners.get(eventType);
            if (listener != null) {
                listener.handle();
            }
        } else if (event.isConsoleErrorCategory()) {
            if (this.consoleErrorEventListener != null) {
                this.consoleErrorEventListener.handle(((ConsoleErrorEvent)event).getStackTraceWriter());
            }
        } else if (event.isConsoleCategory()) {
            ForkedProcessStringEventListener listener = (ForkedProcessStringEventListener)this.consoleEventListeners.get(eventType);
            if (listener != null) {
                listener.handle(((AbstractConsoleEvent)event).getMessage());
            }
        } else if (event.isStandardStreamCategory()) {
            boolean newLine = eventType == ForkedProcessEventType.BOOTERCODE_STDOUT_NEW_LINE || eventType == ForkedProcessEventType.BOOTERCODE_STDERR_NEW_LINE;
            AbstractStandardStreamEvent standardStreamEvent = (AbstractStandardStreamEvent)event;
            ForkedProcessStandardOutErrEventListener listener = (ForkedProcessStandardOutErrEventListener)this.stdOutErrEventListeners.get(eventType);
            if (listener != null) {
                listener.handle(standardStreamEvent.getMessage(), newLine, standardStreamEvent.getRunMode(), standardStreamEvent.getTestRunId());
            }
        } else if (event.isSysPropCategory()) {
            SystemPropertyEvent systemPropertyEvent = (SystemPropertyEvent)event;
            RunMode runMode = systemPropertyEvent.getRunMode();
            Long testRunId = systemPropertyEvent.getTestRunId();
            String key = systemPropertyEvent.getKey();
            String value = systemPropertyEvent.getValue();
            if (this.propertyEventListener != null) {
                this.propertyEventListener.handle(key, value, runMode, testRunId);
            }
        } else if (event.isTestCategory()) {
            ForkedProcessReportEventListener listener = (ForkedProcessReportEventListener)this.reportEventListeners.get(eventType);
            AbstractTestControlEvent testControlEvent = (AbstractTestControlEvent)event;
            ReportEntry reportEntry = testControlEvent.getReportEntry();
            if (listener != null) {
                listener.handle(reportEntry);
            }
        } else if (event.isJvmExitError()) {
            JvmExitErrorEvent jvmExitErrorEvent = (JvmExitErrorEvent)event;
            if (this.exitErrorEventListener != null) {
                this.exitErrorEventListener.handle(jvmExitErrorEvent.getStackTraceWriter());
            }
        } else {
            throw new IllegalArgumentException("Unknown event type " + eventType);
        }
    }
}

