/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shared.utils.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.apache.maven.surefire.shared.utils.Os;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.shared.utils.io.DirectoryScanner;
import org.apache.maven.surefire.shared.utils.io.IOUtil;
import org.apache.maven.surefire.shared.utils.io.Java7Support;

public class FileUtils {
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private static final int ONE_GB = 0x40000000;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    private static final String FS = System.getProperty("file.separator");
    private static final String[] INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME = new String[]{":", "*", "?", "\"", "<", ">", "|"};

    protected FileUtils() {
    }

    @Nonnull
    public static String[] getDefaultExcludes() {
        return DirectoryScanner.DEFAULTEXCLUDES;
    }

    @Nonnull
    public static List<String> getDefaultExcludesAsList() {
        return Arrays.asList(FileUtils.getDefaultExcludes());
    }

    @Nonnull
    public static String getDefaultExcludesAsString() {
        return StringUtils.join(DirectoryScanner.DEFAULTEXCLUDES, ",");
    }

    @Nonnull
    public static String dirname(@Nonnull String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    @Nonnull
    public static String filename(@Nonnull String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(i + 1) : filename;
    }

    @Nonnull
    public static String extension(@Nonnull String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }

    public static boolean fileExists(@Nonnull String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    @Nonnull
    public static String fileRead(@Nonnull String file) throws IOException {
        return FileUtils.fileRead(file, null);
    }

    @Nonnull
    private static String fileRead(@Nonnull String file, @Nullable String encoding) throws IOException {
        return FileUtils.fileRead(new File(file), encoding);
    }

    @Nonnull
    public static String fileRead(@Nonnull File file) throws IOException {
        return FileUtils.fileRead(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String fileRead(@Nonnull File file, @Nullable String encoding) throws IOException {
        StringBuilder buf = new StringBuilder();
        InputStreamReader reader = null;
        try {
            int count;
            reader = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(file), encoding) : new InputStreamReader(new FileInputStream(file));
            char[] b = new char[512];
            while ((count = reader.read(b)) >= 0) {
                buf.append(b, 0, count);
            }
            ((Reader)reader).close();
            reader = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close(reader);
        return buf.toString();
    }

    @Nonnull
    public static String[] fileReadArray(@Nonnull File file) throws IOException {
        List<String> lines = FileUtils.loadFile(file);
        return lines.toArray(new String[lines.size()]);
    }

    public static void fileAppend(@Nonnull String fileName, @Nonnull String data) throws IOException {
        FileUtils.fileAppend(fileName, null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileAppend(@Nonnull String fileName, @Nullable String encoding, @Nonnull String data) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName, true);
            if (encoding != null) {
                out.write(data.getBytes(encoding));
            } else {
                out.write(data.getBytes());
            }
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(out);
    }

    public static void fileWrite(@Nonnull String fileName, @Nonnull String data) throws IOException {
        FileUtils.fileWrite(fileName, null, data);
    }

    public static void fileWrite(@Nonnull String fileName, @Nullable String encoding, @Nonnull String data) throws IOException {
        File file = new File(fileName);
        FileUtils.fileWrite(file, encoding, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileWrite(@Nonnull File file, @Nullable String encoding, @Nonnull String data) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding) : new OutputStreamWriter(new FileOutputStream(file));
            writer.write(data);
            ((Writer)writer).close();
            writer = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close(writer);
    }

    public static void fileWriteArray(@Nonnull File file, String ... data) throws IOException {
        FileUtils.fileWriteArray(file, null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileWriteArray(@Nonnull File file, @Nullable String encoding, String ... data) throws IOException {
        OutputStreamWriter writer = null;
        try {
            writer = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding) : new OutputStreamWriter(new FileOutputStream(file));
            for (int i = 0; data != null && i < data.length; ++i) {
                writer.write(data[i]);
                if (i >= data.length) continue;
                writer.write("\n");
            }
            ((Writer)writer).close();
            writer = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close(writer);
    }

    public static void fileDelete(@Nonnull String fileName) {
        File file = new File(fileName);
        FileUtils.deleteLegacyStyle(file);
    }

    public static String[] getFilesFromExtension(@Nonnull String directory, String ... extensions) {
        List<String> files = new ArrayList<String>();
        File currentDir = new File(directory);
        String[] unknownFiles = currentDir.list();
        if (unknownFiles == null) {
            return new String[0];
        }
        for (String unknownFile : unknownFiles) {
            String currentFileName = directory + System.getProperty("file.separator") + unknownFile;
            File currentFile = new File(currentFileName);
            if (currentFile.isDirectory()) {
                if (currentFile.getName().equals("CVS")) continue;
                String[] fetchFiles = FileUtils.getFilesFromExtension(currentFileName, extensions);
                files = FileUtils.blendFilesToList(files, fetchFiles);
                continue;
            }
            String add = currentFile.getAbsolutePath();
            if (!FileUtils.isValidFile(add, extensions)) continue;
            files.add(add);
        }
        String[] foundFiles = new String[files.size()];
        files.toArray(foundFiles);
        return foundFiles;
    }

    @Nonnull
    private static List<String> blendFilesToList(@Nonnull List<String> v, String ... files) {
        Collections.addAll(v, files);
        return v;
    }

    private static boolean isValidFile(@Nonnull String file, String ... extensions) {
        String extension = FileUtils.extension(file);
        for (String extension1 : extensions) {
            if (!extension1.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static void mkdir(@Nonnull String dir) {
        File file = new File(dir);
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file)) {
            throw new IllegalArgumentException("The file (" + dir + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(@Nonnull File file1, @Nonnull File file2) throws IOException {
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            return false;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        boolean equals = false;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            equals = IOUtil.contentEquals(input1, input2);
            ((InputStream)input1).close();
            input1 = null;
            ((InputStream)input2).close();
            input2 = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(input1);
            IOUtil.close(input2);
            throw throwable;
        }
        IOUtil.close(input1);
        IOUtil.close(input2);
        return equals;
    }

    @Nullable
    public static File toFile(@Nullable URL url) {
        if (url == null || !url.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = -1;
        while ((pos = filename.indexOf(37, pos + 1)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = filename.substring(0, pos) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    @Nonnull
    public static URL[] toURLs(File ... files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return urls;
    }

    @Nonnull
    public static String removeExtension(@Nonnull String filename) {
        String ext = FileUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    @Nonnull
    public static String getExtension(@Nonnull String filename) {
        return FileUtils.extension(filename);
    }

    public static void copyFileToDirectory(@Nonnull File source, @Nonnull File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    private static void copyFileToDirectoryIfModified(@Nonnull File source, @Nonnull File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFileIfModified(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFile(@Nonnull File source, @Nonnull File destination) throws IOException {
        if (!source.exists()) {
            String message = "File " + source + " does not exist";
            throw new IOException(message);
        }
        if (Java7Support.isAtLeastJava7() && Java7Support.isSymLink(source)) {
            File target = Java7Support.readSymbolicLink(source);
            Java7Support.createSymbolicLink(destination, target);
            return;
        }
        if (source.getCanonicalPath().equals(destination.getCanonicalPath())) {
            return;
        }
        FileUtils.mkdirsFor(destination);
        FileUtils.doCopyFile(source, destination);
        if (source.length() != destination.length()) {
            String message = "Failed to copy full contents from " + source + " to " + destination;
            throw new IOException(message);
        }
    }

    private static void mkdirsFor(@Nonnull File destination) {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(@Nonnull File source, @Nonnull File destination) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            long count;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(destination);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > 0x1E00000L ? 0x1E00000L : size - pos;
            }
            output.close();
            output = null;
            fos.close();
            fos = null;
            input.close();
            input = null;
            fis.close();
            fis = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(output);
            IOUtil.close(fos);
            IOUtil.close(input);
            IOUtil.close(fis);
            throw throwable;
        }
        IOUtil.close(output);
        IOUtil.close(fos);
        IOUtil.close(input);
        IOUtil.close(fis);
    }

    private static boolean copyFileIfModified(@Nonnull File source, @Nonnull File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile(source, destination);
            return true;
        }
        return false;
    }

    public static void copyURLToFile(@Nonnull URL source, @Nonnull File destination) throws IOException {
        FileUtils.copyStreamToFile(source.openStream(), destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamToFile(@Nonnull @WillClose InputStream source, @Nonnull File destination) throws IOException {
        InputStream in = source;
        FileOutputStream out = null;
        try {
            if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            if (destination.exists() && !destination.canWrite()) {
                String message = "Unable to open file " + destination + " for writing.";
                throw new IOException(message);
            }
            out = new FileOutputStream(destination);
            IOUtil.copy(in, (OutputStream)out);
            ((OutputStream)out).close();
            out = null;
            in.close();
            in = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close(out);
        IOUtil.close(in);
    }

    @Nonnull
    public static String normalize(@Nonnull String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    @Nonnull
    public static File resolveFile(File baseFile, @Nonnull String filename) {
        String filenm = filename;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator) || Os.isFamily("windows") && filenm.indexOf(":") > 0) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuilder sb = new StringBuilder();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        for (int i = start; i < chars.length; ++i) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (doubleSeparator) continue;
            sb.append(chars[i]);
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return file;
    }

    public static void forceDelete(@Nonnull String file) throws IOException {
        FileUtils.forceDelete(new File(file));
    }

    public static void forceDelete(@Nonnull File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.getCanonicalFile().exists();
            if (!FileUtils.deleteFile(file) && filePresent) {
                String message = "File " + file + " unable to be deleted.";
                throw new IOException(message);
            }
        }
    }

    public static void delete(@Nonnull File file) throws IOException {
        if (Java7Support.isAtLeastJava7()) {
            Java7Support.delete(file);
        } else if (!file.delete()) {
            throw new IOException("Could not delete " + file.getName());
        }
    }

    public static boolean deleteLegacyStyle(@Nonnull File file) {
        if (Java7Support.isAtLeastJava7()) {
            try {
                Java7Support.delete(file);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return file.delete();
    }

    private static boolean deleteFile(@Nonnull File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("File " + file + " isn't a file.");
        }
        if (!FileUtils.deleteLegacyStyle(file)) {
            if (Os.isFamily("windows")) {
                file = file.getCanonicalFile();
            }
            try {
                Thread.sleep(10L);
                return FileUtils.deleteLegacyStyle(file);
            }
            catch (InterruptedException ex) {
                return FileUtils.deleteLegacyStyle(file);
            }
        }
        return true;
    }

    public static void forceMkdir(@Nonnull File file) throws IOException {
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file)) {
            throw new IllegalArgumentException("The file (" + file.getAbsolutePath() + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (file.exists()) {
            if (file.isFile()) {
                String message = "File " + file + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(message);
            }
        } else if (!file.mkdirs()) {
            String message = "Unable to create directory " + file;
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(@Nonnull String directory) throws IOException {
        FileUtils.deleteDirectory(new File(directory));
    }

    public static void deleteDirectory(@Nonnull File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (FileUtils.deleteLegacyStyle(directory)) {
            return;
        }
        FileUtils.cleanDirectory(directory);
        if (!FileUtils.deleteLegacyStyle(directory)) {
            String message = "Directory " + directory + " unable to be deleted.";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(@Nonnull File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                FileUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static long sizeOfDirectory(@Nonnull String directory) {
        return FileUtils.sizeOfDirectory(new File(directory));
    }

    public static long sizeOfDirectory(@Nonnull File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Problems reading directory");
        }
        for (File file : files) {
            if (file.isDirectory()) {
                size += FileUtils.sizeOfDirectory(file);
                continue;
            }
            size += file.length();
        }
        return size;
    }

    @Nonnull
    public static List<File> getFiles(@Nonnull File directory, @Nullable String includes, @Nullable String excludes) throws IOException {
        return FileUtils.getFiles(directory, includes, excludes, true);
    }

    @Nonnull
    public static List<File> getFiles(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir) throws IOException {
        List<String> fileNames = FileUtils.getFileNames(directory, includes, excludes, includeBasedir);
        ArrayList<File> files = new ArrayList<File>();
        for (String filename : fileNames) {
            files.add(new File(filename));
        }
        return files;
    }

    @Nonnull
    public static List<String> getFileNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getFileNames(directory, includes, excludes, includeBasedir, true);
    }

    @Nonnull
    private static List<String> getFileNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, true, false);
    }

    @Nonnull
    public static List<String> getDirectoryNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir) throws IOException {
        return FileUtils.getDirectoryNames(directory, includes, excludes, includeBasedir, true);
    }

    @Nonnull
    public static List<String> getDirectoryNames(@Nonnull File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir, boolean isCaseSensitive) throws IOException {
        return FileUtils.getFileAndDirectoryNames(directory, includes, excludes, includeBasedir, isCaseSensitive, false, true);
    }

    @Nonnull
    public static List<String> getFileAndDirectoryNames(File directory, @Nullable String includes, @Nullable String excludes, boolean includeBasedir, boolean isCaseSensitive, boolean getFiles, boolean getDirectories) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        if (includes != null) {
            scanner.setIncludes(StringUtils.split(includes, ","));
        }
        if (excludes != null) {
            scanner.setExcludes(StringUtils.split(excludes, ","));
        }
        scanner.setCaseSensitive(isCaseSensitive);
        scanner.scan();
        ArrayList<String> list = new ArrayList<String>();
        if (getFiles) {
            String[] files;
            for (String file : files = scanner.getIncludedFiles()) {
                if (includeBasedir) {
                    list.add(directory + FS + file);
                    continue;
                }
                list.add(file);
            }
        }
        if (getDirectories) {
            String[] directories = scanner.getIncludedDirectories();
            for (String directory1 : directories) {
                if (includeBasedir) {
                    list.add(directory + FS + directory1);
                    continue;
                }
                list.add(directory1);
            }
        }
        return list;
    }

    public static void copyDirectory(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory) throws IOException {
        FileUtils.copyDirectory(sourceDirectory, destinationDirectory, "**", null);
    }

    public static void copyDirectory(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory, @Nullable String includes, @Nullable String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        List<File> files = FileUtils.getFiles(sourceDirectory, includes, excludes);
        for (File file : files) {
            FileUtils.copyFileToDirectory(file, destinationDirectory);
        }
    }

    public static void copyDirectoryStructure(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory) throws IOException {
        FileUtils.copyDirectoryStructure(sourceDirectory, destinationDirectory, destinationDirectory, false);
    }

    private static void copyDirectoryStructure(@Nonnull File sourceDirectory, @Nonnull File destinationDirectory, File rootDestinationDirectory, boolean onlyModifiedFiles) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        File[] files = sourceDirectory.listFiles();
        if (files == null) {
            return;
        }
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (File file : files) {
            if (file.equals(rootDestinationDirectory)) continue;
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                destination = destination.getParentFile();
                if (onlyModifiedFiles) {
                    FileUtils.copyFileToDirectoryIfModified(file, destination);
                    continue;
                }
                FileUtils.copyFileToDirectory(file, destination);
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                FileUtils.copyDirectoryStructure(file, destination, rootDestinationDirectory, onlyModifiedFiles);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
    }

    public static void rename(@Nonnull File from, @Nonnull File to) throws IOException {
        if (to.exists() && !FileUtils.deleteLegacyStyle(to)) {
            throw new IOException("Failed to delete " + to + " while trying to rename " + from);
        }
        File parent = to.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directory " + parent + " while trying to rename " + from);
        }
        if (!from.renameTo(to)) {
            FileUtils.copyFile(from, to);
            if (!FileUtils.deleteLegacyStyle(from)) {
                throw new IOException("Failed to delete " + from + " while trying to rename it.");
            }
        }
    }

    public static File createTempFile(@Nonnull String prefix, @Nonnull String suffix, @Nullable File parentDir) {
        File result;
        String parent = System.getProperty("java.io.tmpdir");
        if (parentDir != null) {
            parent = parentDir.getPath();
        }
        DecimalFormat fmt = new DecimalFormat("#####");
        SecureRandom secureRandom = new SecureRandom();
        long secureInitializer = secureRandom.nextLong();
        Random rand = new Random(secureInitializer + Runtime.getRuntime().freeMemory());
        while ((result = new File(parent, prefix + fmt.format(FileUtils.positiveRandom(rand)) + suffix)).exists()) {
        }
        return result;
    }

    private static int positiveRandom(Random rand) {
        int a = rand.nextInt();
        while (a == Integer.MIN_VALUE) {
            a = rand.nextInt();
        }
        return Math.abs(a);
    }

    public static void copyFile(@Nonnull File from, @Nonnull File to, @Nullable String encoding, FilterWrapper ... wrappers) throws IOException {
        FileUtils.copyFile(from, to, encoding, wrappers, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@Nonnull File from, @Nonnull File to, @Nullable String encoding, @Nullable FilterWrapper[] wrappers, boolean overwrite) throws IOException {
        block7: {
            block6: {
                if (wrappers == null || wrappers.length <= 0) break block6;
                Reader fileReader = null;
                OutputStreamWriter fileWriter = null;
                try {
                    if (encoding == null || encoding.length() < 1) {
                        fileReader = new BufferedReader(new FileReader(from));
                        fileWriter = new FileWriter(to);
                    } else {
                        fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(from), encoding));
                        fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(to), encoding);
                    }
                    for (FilterWrapper wrapper : wrappers) {
                        fileReader = wrapper.getReader(fileReader);
                    }
                    IOUtil.copy(fileReader, (Writer)fileWriter);
                    ((Writer)fileWriter).close();
                    fileWriter = null;
                    fileReader.close();
                    fileReader = null;
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileReader);
                    IOUtil.close(fileWriter);
                    throw throwable;
                }
                IOUtil.close(fileReader);
                IOUtil.close(fileWriter);
                break block7;
            }
            if (to.lastModified() < from.lastModified() || overwrite) {
                FileUtils.copyFile(from, to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<String> loadFile(@Nonnull File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        if (file.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#") && line.length() != 0) {
                        lines.add(line);
                    }
                    line = reader.readLine();
                }
                reader.close();
                reader = null;
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close(reader);
        }
        return lines;
    }

    private static boolean isValidWindowsFileName(@Nonnull File f) {
        if (Os.isFamily("windows")) {
            if (StringUtils.indexOfAny(f.getName(), INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME) != -1) {
                return false;
            }
            if (f.getParentFile() != null) {
                return FileUtils.isValidWindowsFileName(f.getParentFile());
            }
        }
        return true;
    }

    public static boolean isSymbolicLink(@Nonnull File file) throws IOException {
        if (Java7Support.isAtLeastJava7()) {
            return Java7Support.isSymLink(file);
        }
        return FileUtils.isSymbolicLinkLegacy(file);
    }

    public static boolean isSymbolicLinkForSure(@Nonnull File file) throws IOException {
        return Java7Support.isAtLeastJava7() && Java7Support.isSymLink(file);
    }

    static boolean isSymbolicLinkLegacy(@Nonnull File file) throws IOException {
        File canonical = new File(file.getCanonicalPath());
        return !file.getAbsolutePath().equals(canonical.getPath());
    }

    public static abstract class FilterWrapper {
        public abstract Reader getReader(Reader var1);
    }
}

