/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.manager;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.infra.util.directory.ClasspathResourceDirectoryReader;

public final class SystemSchemaManager {
    private static final Map<String, Map<String, Collection<String>>> DATABASE_TYPE_SCHEMA_TABLE_MAP;
    private static final Map<String, Map<String, Collection<String>>> DATABASE_TYPE_SCHEMA_RESOURCE_MAP;
    private static final String COMMON = "common";

    public static boolean isSystemTable(String schema, String tableName) {
        for (Map.Entry<String, Map<String, Collection<String>>> entry : DATABASE_TYPE_SCHEMA_TABLE_MAP.entrySet()) {
            if (!Optional.ofNullable(entry.getValue().get(schema)).map(tables -> tables.contains(tableName)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystemTable(String databaseType, String schema, String tableName) {
        Map schemaTableMap = DATABASE_TYPE_SCHEMA_TABLE_MAP.getOrDefault(databaseType, Collections.emptyMap());
        Map commonTableMap = DATABASE_TYPE_SCHEMA_TABLE_MAP.getOrDefault(COMMON, Collections.emptyMap());
        if (null == schema) {
            return schemaTableMap.values().stream().anyMatch(each -> each.contains(tableName)) || commonTableMap.values().stream().anyMatch(each -> each.contains(tableName));
        }
        return ((Collection)schemaTableMap.getOrDefault(schema, Collections.emptyList())).contains(tableName) || ((Collection)commonTableMap.getOrDefault(schema, Collections.emptyList())).contains(tableName);
    }

    public static boolean isSystemTable(String databaseType, String schema, Collection<String> tableNames) {
        Collection databaseTypeTables = Optional.ofNullable(DATABASE_TYPE_SCHEMA_TABLE_MAP.get(databaseType)).map(schemas -> (Collection)schemas.get(schema)).orElse(Collections.emptyList());
        Collection commonTables = Optional.ofNullable(DATABASE_TYPE_SCHEMA_TABLE_MAP.get(COMMON)).map(schemas -> (Collection)schemas.get(schema)).orElse(Collections.emptyList());
        for (String each : tableNames) {
            if (databaseTypeTables.contains(each) || commonTables.contains(each)) continue;
            return false;
        }
        return true;
    }

    public static Collection<String> getTables(String databaseType, String schema) {
        LinkedList<String> result = new LinkedList<String>();
        Optional.ofNullable(DATABASE_TYPE_SCHEMA_TABLE_MAP.get(databaseType)).map(schemas -> (Collection)schemas.get(schema)).ifPresent(result::addAll);
        Optional.ofNullable(DATABASE_TYPE_SCHEMA_TABLE_MAP.get(COMMON)).map(schemas -> (Collection)schemas.get(schema)).ifPresent(result::addAll);
        return result;
    }

    public static Collection<InputStream> getAllInputStreams(String databaseType, String schema) {
        LinkedList<InputStream> result = new LinkedList<InputStream>();
        result.addAll(SystemSchemaManager.getInputStreams(databaseType, schema));
        result.addAll(SystemSchemaManager.getInputStreams(COMMON, schema));
        return result;
    }

    private static Collection<InputStream> getInputStreams(String databaseType, String schema) {
        if (!DATABASE_TYPE_SCHEMA_RESOURCE_MAP.containsKey(databaseType) || !DATABASE_TYPE_SCHEMA_RESOURCE_MAP.get(databaseType).containsKey(schema)) {
            return Collections.emptyList();
        }
        LinkedList<InputStream> result = new LinkedList<InputStream>();
        for (String each : DATABASE_TYPE_SCHEMA_RESOURCE_MAP.get(databaseType).get(schema)) {
            result.add(SystemSchemaManager.class.getClassLoader().getResourceAsStream(each));
        }
        return result;
    }

    @Generated
    private SystemSchemaManager() {
    }

    static {
        List resourceNames;
        try (Stream resourceNameStream = ClasspathResourceDirectoryReader.read((String)"schema");){
            resourceNames = resourceNameStream.filter(each -> each.endsWith(".yaml")).collect(Collectors.toList());
        }
        DATABASE_TYPE_SCHEMA_TABLE_MAP = (Map)resourceNames.stream().map(resourceName -> resourceName.split("/")).filter(each -> ((String[])each).length == 4).collect(Collectors.groupingBy(path -> path[1], CaseInsensitiveMap::new, Collectors.groupingBy(path -> path[2], CaseInsensitiveMap::new, Collectors.mapping(path -> StringUtils.removeEnd((String)path[3], (String)".yaml"), Collectors.toCollection(CaseInsensitiveSet::new)))));
        DATABASE_TYPE_SCHEMA_RESOURCE_MAP = (Map)resourceNames.stream().map(resourceName -> resourceName.split("/")).filter(each -> ((String[])each).length == 4).collect(Collectors.groupingBy(path -> path[1], CaseInsensitiveMap::new, Collectors.groupingBy(path -> path[2], CaseInsensitiveMap::new, Collectors.mapping(path -> String.join((CharSequence)"/", path), Collectors.toCollection(CaseInsensitiveSet::new)))));
    }
}

