/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.sqlfederation.executor.utils.EnumeratorUtils;

public final class MemoryRowEnumerator
implements Enumerator<Object> {
    private final Collection<ShardingSphereRowData> rows;
    private final Map<Integer, Class<?>> columnTypes;
    private Iterator<ShardingSphereRowData> iterator;
    private Object current;

    public MemoryRowEnumerator(Collection<ShardingSphereRowData> rows, Collection<ShardingSphereColumn> columns, DatabaseType databaseType) {
        this.rows = rows;
        this.columnTypes = EnumeratorUtils.createColumnTypes(new ArrayList<ShardingSphereColumn>(columns), databaseType);
        this.iterator = rows.iterator();
    }

    public Object current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = EnumeratorUtils.convertToTargetType(this.columnTypes, this.iterator.next().getRows().toArray());
            return true;
        }
        this.current = null;
        this.iterator = this.rows.iterator();
        return false;
    }

    public void reset() {
    }

    public void close() {
        this.iterator = this.rows.iterator();
        this.current = null;
    }
}

