/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.DeleteLicenseRequest;
import org.elasticsearch.license.DeleteLicenseRequestBuilder;
import org.elasticsearch.license.DeleteLicenseResponse;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseRequest;
import org.elasticsearch.license.GetLicenseRequestBuilder;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.license.License;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.license.PutLicenseRequestBuilder;
import org.elasticsearch.license.PutLicenseResponse;

public class LicensingClient {
    private final ElasticsearchClient client;

    public LicensingClient(ElasticsearchClient client) {
        this.client = client;
    }

    public PutLicenseRequestBuilder preparePutLicense(License license) {
        return new PutLicenseRequestBuilder(this.client).setLicense(license);
    }

    public void putLicense(PutLicenseRequest request, ActionListener<PutLicenseResponse> listener) {
        this.client.execute((Action)PutLicenseAction.INSTANCE, (ActionRequest)request, listener);
    }

    public GetLicenseRequestBuilder prepareGetLicense() {
        return new GetLicenseRequestBuilder(this.client);
    }

    public void getLicense(GetLicenseRequest request, ActionListener<GetLicenseResponse> listener) {
        this.client.execute((Action)GetLicenseAction.INSTANCE, (ActionRequest)request, listener);
    }

    public DeleteLicenseRequestBuilder prepareDeleteLicense() {
        return new DeleteLicenseRequestBuilder(this.client);
    }

    public void deleteLicense(DeleteLicenseRequest request, ActionListener<DeleteLicenseResponse> listener) {
        this.client.execute((Action)DeleteLicenseAction.INSTANCE, (ActionRequest)request, listener);
    }
}

