/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.Licensing;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.action.TransportXPackInfoAction;
import org.elasticsearch.xpack.action.TransportXPackUsageAction;
import org.elasticsearch.xpack.action.XPackInfoAction;
import org.elasticsearch.xpack.action.XPackUsageAction;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.common.http.HttpSettings;
import org.elasticsearch.xpack.common.http.auth.HttpAuthFactory;
import org.elasticsearch.xpack.common.http.auth.HttpAuthRegistry;
import org.elasticsearch.xpack.common.http.auth.basic.BasicAuthFactory;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.extensions.XPackExtension;
import org.elasticsearch.xpack.extensions.XPackExtensionsService;
import org.elasticsearch.xpack.graph.Graph;
import org.elasticsearch.xpack.graph.GraphFeatureSet;
import org.elasticsearch.xpack.monitoring.Monitoring;
import org.elasticsearch.xpack.monitoring.MonitoringFeatureSet;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.notification.email.Account;
import org.elasticsearch.xpack.notification.email.EmailService;
import org.elasticsearch.xpack.notification.email.attachment.DataAttachmentParser;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentsParser;
import org.elasticsearch.xpack.notification.email.attachment.HttpEmailAttachementParser;
import org.elasticsearch.xpack.notification.email.attachment.ReportingAttachmentParser;
import org.elasticsearch.xpack.notification.email.support.BodyPartSource;
import org.elasticsearch.xpack.notification.hipchat.HipChatService;
import org.elasticsearch.xpack.notification.jira.JiraService;
import org.elasticsearch.xpack.notification.pagerduty.PagerDutyService;
import org.elasticsearch.xpack.notification.slack.SlackService;
import org.elasticsearch.xpack.rest.action.RestXPackInfoAction;
import org.elasticsearch.xpack.rest.action.RestXPackUsageAction;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.SecurityFeatureSet;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.ssl.SSLConfigurationReloader;
import org.elasticsearch.xpack.ssl.SSLService;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.support.clock.SystemClock;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.WatcherFeatureSet;

public class XPackPlugin
extends Plugin
implements ScriptPlugin,
ActionPlugin,
IngestPlugin,
NetworkPlugin {
    public static final String NAME = "x-pack";
    public static final String SECURITY = "security";
    public static final String MONITORING = "monitoring";
    public static final String WATCHER = "watcher";
    public static final String GRAPH = "graph";
    private static final String SETTINGS_NAME = "xpack";
    protected final Settings settings;
    private final Environment env;
    protected boolean transportClientMode;
    protected final XPackExtensionsService extensionsService;
    protected XPackLicenseState licenseState;
    protected SSLService sslService;
    protected Licensing licensing;
    protected Security security;
    protected Monitoring monitoring;
    protected Watcher watcher;
    protected Graph graph;

    public XPackPlugin(Settings settings) throws IOException {
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode(settings);
        this.env = this.transportClientMode ? null : new Environment(settings);
        this.licenseState = new XPackLicenseState();
        this.sslService = new SSLService(settings, this.env);
        this.licensing = new Licensing(settings);
        this.security = new Security(settings, this.env, this.licenseState, this.sslService);
        this.monitoring = new Monitoring(settings, this.licenseState);
        this.watcher = new Watcher(settings);
        this.graph = new Graph(settings);
        this.extensionsService = !this.transportClientMode ? new XPackExtensionsService(settings, XPackPlugin.resolveXPackExtensionsFile(this.env), this.getExtensions()) : null;
    }

    public Collection<Class<? extends XPackExtension>> getExtensions() {
        return Collections.emptyList();
    }

    protected Clock getClock() {
        return SystemClock.INSTANCE;
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(b -> b.bind(Clock.class).toInstance((Object)this.getClock()));
        modules.addAll(this.security.nodeModules());
        modules.addAll(this.watcher.nodeModules());
        modules.addAll(this.monitoring.nodeModules());
        modules.addAll(this.graph.createGuiceModules());
        if (this.transportClientMode) {
            modules.add(b -> b.bind(XPackLicenseState.class).toProvider(Providers.of(null)));
        }
        return modules;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add((Object)this.sslService);
        InternalClient internalClient = new InternalClient(this.settings, threadPool, client, this.security.getCryptoService());
        components.add((Object)internalClient);
        LicenseService licenseService = new LicenseService(this.settings, clusterService, this.getClock(), this.env, resourceWatcherService, this.licenseState);
        components.add(licenseService);
        components.add(this.licenseState);
        try {
            components.addAll(this.security.createComponents(internalClient, threadPool, clusterService, resourceWatcherService, this.extensionsService.getExtensions()));
        }
        catch (Exception e) {
            throw new Error("security initialization failed", e);
        }
        components.addAll(this.monitoring.createComponents(internalClient, threadPool, clusterService, licenseService, this.sslService));
        HashMap<String, HttpAuthFactory> httpAuthFactories = new HashMap<String, HttpAuthFactory>();
        httpAuthFactories.put("basic", new BasicAuthFactory(this.security.getCryptoService()));
        HttpAuthRegistry httpAuthRegistry = new HttpAuthRegistry(httpAuthFactories);
        HttpRequestTemplate.Parser httpTemplateParser = new HttpRequestTemplate.Parser(httpAuthRegistry);
        components.add(httpTemplateParser);
        HttpClient httpClient = new HttpClient(this.settings, httpAuthRegistry, this.sslService);
        components.add((Object)httpClient);
        Collection<Object> notificationComponents = this.createNotificationComponents(clusterService.getClusterSettings(), httpClient, httpTemplateParser, scriptService, httpAuthRegistry);
        components.addAll(notificationComponents);
        components.addAll(this.watcher.createComponents(this.getClock(), scriptService, internalClient, this.licenseState, httpClient, xContentRegistry, components));
        new SSLConfigurationReloader(this.settings, this.env, this.sslService, resourceWatcherService);
        return components;
    }

    private Collection<Object> createNotificationComponents(ClusterSettings clusterSettings, HttpClient httpClient, HttpRequestTemplate.Parser httpTemplateParser, ScriptService scriptService, HttpAuthRegistry httpAuthRegistry) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add((Object)new EmailService(this.settings, this.security.getCryptoService(), clusterSettings));
        components.add((Object)new HipChatService(this.settings, httpClient, clusterSettings));
        components.add((Object)new JiraService(this.settings, httpClient, clusterSettings));
        components.add((Object)new SlackService(this.settings, httpClient, clusterSettings));
        components.add((Object)new PagerDutyService(this.settings, httpClient, clusterSettings));
        TextTemplateEngine textTemplateEngine = new TextTemplateEngine(this.settings, scriptService);
        components.add((Object)textTemplateEngine);
        HashMap<String, EmailAttachmentParser> parsers = new HashMap<String, EmailAttachmentParser>();
        parsers.put("http", new HttpEmailAttachementParser(httpClient, httpTemplateParser, textTemplateEngine));
        parsers.put("data", new DataAttachmentParser());
        parsers.put("reporting", new ReportingAttachmentParser(this.settings, httpClient, textTemplateEngine, httpAuthRegistry));
        components.add(new EmailAttachmentsParser(parsers));
        return components;
    }

    public Settings additionalSettings() {
        Settings.Builder builder = Settings.builder();
        builder.put(this.security.additionalSettings());
        builder.put(this.watcher.additionalSettings());
        return builder.build();
    }

    public Collection<String> getRestHeaders() {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        HashSet<String> headers = new HashSet<String>();
        headers.add("Authorization");
        if (((Boolean)AuthenticationService.RUN_AS_ENABLED.get(this.settings)).booleanValue()) {
            headers.add("es-security-runas-user");
        }
        headers.addAll(this.extensionsService.getExtensions().stream().flatMap(e -> e.getRestHeaders().stream()).collect(Collectors.toList()));
        return headers;
    }

    public ScriptContext.Plugin getCustomScriptContexts() {
        return this.watcher.getCustomScriptContexts();
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(Security.getSettings(this.transportClientMode, this.extensionsService));
        settings.addAll(MonitoringSettings.getSettings());
        settings.addAll(this.watcher.getSettings());
        settings.addAll(this.licensing.getSettings());
        settings.addAll(XPackSettings.getAllSettings());
        settings.add(Setting.simpleString((String)"index.xpack.version", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope}));
        settings.add(SlackService.SLACK_ACCOUNT_SETTING);
        settings.add(EmailService.EMAIL_ACCOUNT_SETTING);
        settings.add(HipChatService.HIPCHAT_ACCOUNT_SETTING);
        settings.add(JiraService.JIRA_ACCOUNT_SETTING);
        settings.add(PagerDutyService.PAGERDUTY_ACCOUNT_SETTING);
        settings.add(ReportingAttachmentParser.RETRIES_SETTING);
        settings.add(ReportingAttachmentParser.INTERVAL_SETTING);
        settings.addAll(HttpSettings.getSettings());
        return settings;
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("xpack.notification.email.account.*.smtp.password");
        filters.add("xpack.notification.jira.account.*.password");
        filters.add("xpack.notification.slack.account.*.url");
        filters.add("xpack.notification.pagerduty.account.*.url");
        filters.add("xpack.notification.pagerduty.service_api_key");
        filters.add("xpack.notification.pagerduty.account.*.service_api_key");
        filters.add("xpack.notification.hipchat.account.*.auth_token");
        filters.addAll(this.security.getSettingsFilter());
        filters.addAll(MonitoringSettings.getSettingsFilter());
        if (!this.transportClientMode) {
            for (XPackExtension extension : this.extensionsService.getExtensions()) {
                filters.addAll(extension.getSettingsFilter());
            }
        }
        return filters;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return this.watcher.getExecutorBuilders(settings);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        actions.add(new ActionPlugin.ActionHandler((GenericAction)XPackInfoAction.INSTANCE, TransportXPackInfoAction.class, new Class[0]));
        actions.add(new ActionPlugin.ActionHandler((GenericAction)XPackUsageAction.INSTANCE, TransportXPackUsageAction.class, new Class[0]));
        actions.addAll(this.licensing.getActions());
        actions.addAll(this.monitoring.getActions());
        actions.addAll(this.security.getActions());
        actions.addAll(this.watcher.getActions());
        actions.addAll(this.graph.getActions());
        return actions;
    }

    public List<Class<? extends ActionFilter>> getActionFilters() {
        ArrayList<Class<? extends ActionFilter>> filters = new ArrayList<Class<? extends ActionFilter>>();
        filters.addAll(this.licensing.getActionFilters());
        filters.addAll(this.monitoring.getActionFilters());
        filters.addAll(this.security.getActionFilters());
        filters.addAll(this.watcher.getActionFilters());
        return filters;
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add((RestHandler)new RestXPackInfoAction(settings, restController));
        handlers.add((RestHandler)new RestXPackUsageAction(settings, restController));
        handlers.addAll(this.licensing.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        handlers.addAll(this.monitoring.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        handlers.addAll(this.security.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        handlers.addAll(this.watcher.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        handlers.addAll(this.graph.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        return handlers;
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return this.security.getProcessors(parameters);
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, SECURITY, SecurityFeatureSet.Usage::new));
        entries.add(new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, WATCHER, WatcherFeatureSet.Usage::new));
        entries.add(new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, MONITORING, MonitoringFeatureSet.Usage::new));
        entries.add(new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, GRAPH, GraphFeatureSet.Usage::new));
        entries.addAll(this.watcher.getNamedWriteables());
        entries.addAll(this.licensing.getNamedWriteables());
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.addAll(this.watcher.getNamedXContent());
        entries.addAll(this.licensing.getNamedXContent());
        return entries;
    }

    public void onIndexModule(IndexModule module) {
        this.security.onIndexModule(module);
    }

    public static void bindFeatureSet(Binder binder, Class<? extends XPackFeatureSet> featureSet) {
        binder.bind(featureSet).asEagerSingleton();
        Multibinder featureSetBinder = Multibinder.newSetBinder((Binder)binder, XPackFeatureSet.class);
        featureSetBinder.addBinding().to(featureSet);
    }

    public static boolean transportClientMode(Settings settings) {
        return "transport".equals(settings.get(Client.CLIENT_TYPE_SETTING_S.getKey()));
    }

    public static boolean isTribeNode(Settings settings) {
        return !settings.getGroups("tribe", true).isEmpty();
    }

    public static boolean isTribeClientNode(Settings settings) {
        return settings.get("tribe.name") != null;
    }

    public static Path resolveConfigFile(Environment env, String name) {
        return env.configFile().resolve(NAME).resolve(name);
    }

    public static String featureSettingPrefix(String featureName) {
        return "xpack." + featureName;
    }

    public static Path resolveXPackExtensionsFile(Environment env) {
        return env.pluginsFile().resolve(NAME).resolve("extensions");
    }

    public List<TransportInterceptor> getTransportInterceptors(ThreadContext threadContext) {
        return this.security.getTransportInterceptors(threadContext);
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        return this.security.getTransports(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher) {
        return this.security.getHttpTransports(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, dispatcher);
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        return this.security.getRestHandlerWrapper(threadContext);
    }

    static {
        block3: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            Class.forName("com.unboundid.util.Debug");
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
            catch (ExceptionInInitializerError bogus) {
                if (bogus.getCause() instanceof SecurityException) break block3;
                throw bogus;
            }
        }
        BodyPartSource.init();
        Account.init();
    }
}

