/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.action.XPackUsageRequest;
import org.elasticsearch.xpack.action.XPackUsageResponse;
import org.elasticsearch.xpack.common.IteratingActionListener;

public class TransportXPackUsageAction
extends TransportMasterNodeAction<XPackUsageRequest, XPackUsageResponse> {
    private final List<XPackFeatureSet> featureSets;

    @Inject
    public TransportXPackUsageAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Set<XPackFeatureSet> featureSets) {
        super(settings, "cluster:monitor/xpack/usage", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, XPackUsageRequest::new);
        this.featureSets = Collections.unmodifiableList(new ArrayList<XPackFeatureSet>(featureSets));
    }

    protected String executor() {
        return "management";
    }

    protected XPackUsageResponse newResponse() {
        return new XPackUsageResponse();
    }

    protected void masterOperation(XPackUsageRequest request, ClusterState state, final ActionListener<XPackUsageResponse> listener) throws Exception {
        ActionListener<List<XPackFeatureSet.Usage>> usageActionListener = new ActionListener<List<XPackFeatureSet.Usage>>(){

            public void onResponse(List<XPackFeatureSet.Usage> usages) {
                listener.onResponse((Object)new XPackUsageResponse(usages));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        final AtomicReferenceArray featureSetUsages = new AtomicReferenceArray(this.featureSets.size());
        final AtomicInteger position = new AtomicInteger(0);
        BiConsumer<XPackFeatureSet, ActionListener> consumer = (featureSet, iteratingListener) -> featureSet.usage(new ActionListener<XPackFeatureSet.Usage>(){

            public void onResponse(XPackFeatureSet.Usage usage) {
                featureSetUsages.set(position.getAndIncrement(), usage);
                iteratingListener.onResponse(null);
            }

            public void onFailure(Exception e) {
                iteratingListener.onFailure(e);
            }
        });
        IteratingActionListener<List, XPackFeatureSet> iteratingActionListener = new IteratingActionListener<List, XPackFeatureSet>(usageActionListener, consumer, this.featureSets, this.threadPool.getThreadContext(), () -> {
            ArrayList usageList = new ArrayList(featureSetUsages.length());
            for (int i = 0; i < featureSetUsages.length(); ++i) {
                usageList.add(featureSetUsages.get(i));
            }
            return usageList;
        });
        iteratingActionListener.run();
    }

    protected ClusterBlockException checkBlock(XPackUsageRequest request, ClusterState state) {
        return null;
    }
}

