/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStateMonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;

public class ClusterStateResolver
extends MonitoringIndexNameResolver.Timestamped<ClusterStateMonitoringDoc> {
    public static final String TYPE = "cluster_state";
    static final Set<String> FILTERS;

    public ClusterStateResolver(MonitoredSystem id, Settings settings) {
        super(id, settings);
    }

    @Override
    public String type(ClusterStateMonitoringDoc document) {
        return TYPE;
    }

    @Override
    public Set<String> filters() {
        return FILTERS;
    }

    @Override
    protected void buildXContent(ClusterStateMonitoringDoc document, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TYPE);
        ClusterState clusterState = document.getClusterState();
        if (clusterState != null) {
            builder.field("status", document.getStatus().name().toLowerCase(Locale.ROOT));
            clusterState.toXContent(builder, params);
        }
        builder.endObject();
    }

    static {
        HashSet filters = Sets.newHashSet((Object[])new String[]{"cluster_uuid", "timestamp", "source_node", "cluster_state.version", "cluster_state.master_node", "cluster_state.state_uuid", "cluster_state.status", "cluster_state.nodes"});
        FILTERS = Collections.unmodifiableSet(filters);
    }

    static final class Fields {
        static final String CLUSTER_STATE = "cluster_state";
        static final String STATUS = "status";

        Fields() {
        }
    }
}

